/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper.util;

import com.github.phantomthief.util.ThrowableFunction;
import com.github.phantomthief.zookeeper.util.EphemeralNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZkUtils.class);
    private static final long DEFAULT_WAIT = TimeUnit.SECONDS.toMillis(1L);
    private static final int INFINITY_LOOP = -1;

    private ZkUtils() {
        throw new UnsupportedOperationException();
    }

    public static String getStringFromZk(CuratorFramework client, String path) {
        return (String)ZkUtils.getFromZk(client, path, String::new);
    }

    public static byte[] getBytesFromZk(CuratorFramework client, String path) {
        return (byte[])ZkUtils.getFromZk(client, path, b -> b);
    }

    public static <T, X extends Throwable> T getFromZk(CuratorFramework client, String path, ThrowableFunction<byte[], T, X> decoder) throws X {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(decoder);
        try {
            byte[] bytes = (byte[])client.getData().forPath(path);
            if (bytes == null) {
                return null;
            }
            return (T)decoder.apply((Object)bytes);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void setToZk(CuratorFramework client, String path, byte[] value) {
        ZkUtils.setToZk(client, path, value, CreateMode.PERSISTENT);
    }

    @Deprecated
    public static void setToZk(CuratorFramework client, String path, byte[] value, CreateMode createMode) {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull((Object)createMode);
        int retryTimes = 0;
        while (retryTimes++ < 3) {
            try {
                client.setData().forPath(path, value);
                break;
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    ((ACLBackgroundPathAndBytesable)client.create().creatingParentsIfNeeded().withMode(createMode)).forPath(path, value);
                    break;
                }
                catch (KeeperException.NodeExistsException retry) {
                }
                catch (Exception toThrow) {
                    Throwables.throwIfUnchecked((Throwable)toThrow);
                    throw new RuntimeException(toThrow);
                }
            }
            catch (Exception toThrow) {
                Throwables.throwIfUnchecked((Throwable)toThrow);
                throw new RuntimeException(toThrow);
            }
        }
    }

    public static EphemeralNode createEphemeralNode(CuratorFramework client, String path, byte[] value) throws KeeperException.NodeExistsException {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)value);
        return new KeepEphemeralListener(client, path, value);
    }

    public static void removeFromZk(CuratorFramework client, String path) {
        ZkUtils.removeFromZk(client, path, false);
    }

    public static void removeFromZk(CuratorFramework client, String path, boolean recruitDeletedChildren) {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)path);
        try {
            if (recruitDeletedChildren) {
                client.delete().deletingChildrenIfNeeded().forPath(path);
            } else {
                client.delete().forPath(path);
            }
        }
        catch (KeeperException.NoNodeException e) {
            logger.debug("no zookeeper path found:{}, ignore deleted.", (Object)path);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> void changeZkValue(CuratorFramework client, String path, Function<T, T> changeFunction, Function<byte[], T> decoder, Function<T, byte[]> encoder) {
        Function<byte[], byte[]> realFunction = old -> {
            Object decodedOld = decoder.apply((byte[])old);
            return (byte[])encoder.apply(changeFunction.apply(decodedOld));
        };
        ZkUtils.changeZkValue(client, path, realFunction, -1, DEFAULT_WAIT);
    }

    public static boolean changeZkValue(CuratorFramework client, String path, Function<byte[], byte[]> changeFunction, int retryTimes, long retryWait) {
        int times = 0;
        do {
            try {
                Stat stat = new Stat();
                byte[] oldData = (byte[])((WatchPathable)client.getData().storingStatIn(stat)).forPath(path);
                byte[] newData = changeFunction.apply(oldData);
                ((BackgroundPathAndBytesable)client.setData().withVersion(stat.getVersion())).forPath(path, newData);
                if (logger.isDebugEnabled()) {
                    logger.debug("success update znode:{} from {} to {}", new Object[]{path, Arrays.toString(oldData), Arrays.toString(newData)});
                }
                return true;
            }
            catch (KeeperException.BadVersionException e) {
                logger.debug("bad version for znode:{}, retry.{}", (Object)path, (Object)times);
            }
            catch (KeeperException.NoNodeException e) {
                byte[] newData = changeFunction.apply(null);
                try {
                    client.create().creatingParentsIfNeeded().forPath(path, newData);
                    if (logger.isDebugEnabled()) {
                        logger.debug("success create znode:{} -> {}", (Object)path, (Object)Arrays.toString(newData));
                    }
                    return true;
                }
                catch (KeeperException.NodeExistsException ex) {
                    logger.debug("node exist for znode:{}, retry.{}", (Object)path, (Object)times);
                }
                catch (Exception ex) {
                    logger.error("Ops.{}/{}", new Object[]{path, times, ex});
                }
            }
            catch (Exception e) {
                logger.error("Ops.{}/{}", new Object[]{path, times, e});
                ++times;
                Uninterruptibles.sleepUninterruptibly((long)retryWait, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        } while (times < retryTimes || retryTimes == -1);
        logger.warn("fail to change znode:{}, retry times:{}", (Object)path, (Object)times);
        return false;
    }

    public static Stream<ChildData> getAllChildrenWithData(CuratorFramework curator, String parentPath) {
        String parentPath0 = StringUtils.removeEnd((String)parentPath, (String)"/");
        return ZkUtils.getAllChildrenWithData0(curator, parentPath0);
    }

    private static Stream<ChildData> getAllChildrenWithData0(CuratorFramework curator, String parentPath) {
        try {
            List children = (List)curator.getChildren().forPath(parentPath);
            if (children.isEmpty()) {
                return Stream.empty();
            }
            Stream<ChildData> original = children.stream().map(child -> ZKPaths.makePath((String)parentPath, (String)child)).map(path -> ZkUtils.toChildData(curator, path)).filter(Objects::nonNull);
            return Stream.concat(original, children.stream().map(child -> ZKPaths.makePath((String)parentPath, (String)child)).flatMap(path -> ZkUtils.getAllChildrenWithData0(curator, path)));
        }
        catch (KeeperException.NoNodeException e) {
            return Stream.empty();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static ChildData toChildData(CuratorFramework curator, String path) {
        Stat stat = new Stat();
        try {
            byte[] bytes = (byte[])((WatchPathable)curator.getData().storingStatIn(stat)).forPath(path);
            return new ChildData(path, stat, bytes);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Stream<String> getAllChildren(CuratorFramework curator, String parentPath) {
        String parentPath0 = StringUtils.removeEnd((String)parentPath, (String)"/");
        return ZkUtils.getAllChildren0(curator, parentPath0).map(p -> StringUtils.removeStart((String)p, (String)parentPath0));
    }

    private static Stream<String> getAllChildren0(CuratorFramework curator, String parentPath) {
        try {
            List children = (List)curator.getChildren().forPath(parentPath);
            if (children.isEmpty()) {
                return children.stream();
            }
            Stream<String> original = children.stream().map(child -> ZKPaths.makePath((String)parentPath, (String)child));
            return Stream.concat(original, children.stream().map(child -> ZKPaths.makePath((String)parentPath, (String)child)).flatMap(path -> ZkUtils.getAllChildren0(curator, path)));
        }
        catch (KeeperException.NoNodeException e) {
            return Stream.empty();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static class KeepEphemeralListener
    implements EphemeralNode,
    ConnectionStateListener {
        private final CuratorFramework originalClient;
        private final String path;
        private volatile byte[] value;
        @GuardedBy(value="this")
        private volatile boolean closed;

        KeepEphemeralListener(CuratorFramework originalClient, String path, byte[] value) throws KeeperException.NodeExistsException {
            try {
                ((ACLBackgroundPathAndBytesable)originalClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, value);
            }
            catch (KeeperException.NodeExistsException e) {
                throw e;
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            this.originalClient = originalClient;
            this.path = path;
            this.value = value;
            this.originalClient.getConnectionStateListenable().addListener((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            KeepEphemeralListener keepEphemeralListener = this;
            synchronized (keepEphemeralListener) {
                this.closed = true;
                this.originalClient.getConnectionStateListenable().removeListener((Object)this);
                try {
                    this.originalClient.delete().forPath(this.path);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            KeepEphemeralListener keepEphemeralListener = this;
            synchronized (keepEphemeralListener) {
                if (this.closed) {
                    return;
                }
                if (newState == ConnectionState.RECONNECTED) {
                    try {
                        if (this.originalClient.checkExists().forPath(this.path) == null) {
                            logger.info("try recovery ephemeral node for:{}", (Object)this.path);
                            ((ACLBackgroundPathAndBytesable)this.originalClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.path, this.value);
                        }
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateValue(@Nonnull byte[] value) {
            KeepEphemeralListener keepEphemeralListener = this;
            synchronized (keepEphemeralListener) {
                if (this.closed) {
                    return;
                }
                this.value = (byte[])Preconditions.checkNotNull((Object)value);
                try {
                    this.originalClient.setData().forPath(this.path, value);
                }
                catch (KeeperException.NoNodeException e) {
                    try {
                        ((ACLBackgroundPathAndBytesable)this.originalClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.path, value);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                    }
                    catch (Exception e1) {
                        Throwables.throwIfUnchecked((Throwable)e1);
                        throw new RuntimeException(e1);
                    }
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

