/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.localcache.impl;

import com.github.phantomthief.concurrent.MoreFutures;
import com.github.phantomthief.localcache.CacheFactory;
import com.github.phantomthief.localcache.CacheFactoryEx;
import com.github.phantomthief.localcache.ReloadableCache;
import com.github.phantomthief.localcache.impl.CacheBuildFailedException;
import com.github.phantomthief.zookeeper.broadcast.Broadcaster;
import com.github.phantomthief.zookeeper.broadcast.ZkBroadcaster;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkNotifyReloadCache<T>
implements ReloadableCache<T> {
    private static final Logger logger = LoggerFactory.getLogger(ZkNotifyReloadCache.class);
    private final CacheFactoryEx<T> cacheFactory;
    private final Supplier<T> firstAccessFailFactory;
    private final Set<String> notifyZkPaths;
    private final Consumer<T> oldCleanup;
    private final LongSupplier maxRandomSleepOnNotifyReload;
    private final Broadcaster broadcaster;
    private final Supplier<Duration> scheduleRunDuration;
    @Nullable
    private final ScheduledExecutorService executor;
    private final Runnable recycleListener;
    private volatile T cachedObject;

    private ZkNotifyReloadCache(Builder<T> builder) {
        this.cacheFactory = ((Builder)builder).cacheFactory;
        this.firstAccessFailFactory = this.wrapTry(((Builder)builder).firstAccessFailFactory);
        this.notifyZkPaths = ((Builder)builder).notifyZkPaths;
        this.oldCleanup = this.wrapTry(((Builder)builder).oldCleanup);
        this.maxRandomSleepOnNotifyReload = ((Builder)builder).maxRandomSleepOnNotifyReload;
        this.broadcaster = ((Builder)builder).broadcaster;
        this.scheduleRunDuration = ((Builder)builder).scheduleRunDuration;
        this.executor = ((Builder)builder).executor;
        this.recycleListener = ((Builder)builder).recycleListener;
    }

    public static <T> ZkNotifyReloadCache<T> of(CacheFactory<T> cacheFactory, String notifyZkPath, Supplier<CuratorFramework> curatorFactory) {
        return ZkNotifyReloadCache.newBuilder().withCacheFactory(cacheFactory).withNotifyZkPath(notifyZkPath).withCuratorFactory(curatorFactory).build();
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.cachedObject == null) {
            ZkNotifyReloadCache zkNotifyReloadCache = this;
            synchronized (zkNotifyReloadCache) {
                if (this.cachedObject == null) {
                    this.cachedObject = this.init();
                }
            }
        }
        return this.cachedObject;
    }

    public Set<String> getZkNotifyPaths() {
        return this.notifyZkPaths;
    }

    private T init() {
        T obj;
        try {
            obj = this.cacheFactory.get(null);
        }
        catch (Throwable e) {
            if (this.firstAccessFailFactory != null) {
                obj = this.firstAccessFailFactory.get();
                logger.error("fail to build cache, using empty value:{}", obj, (Object)e);
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new CacheBuildFailedException("fail to build cache.", e);
        }
        if (obj != null) {
            if (this.broadcaster != null && this.notifyZkPaths != null) {
                this.notifyZkPaths.forEach(notifyZkPath -> {
                    AtomicLong sleeping = new AtomicLong();
                    AtomicLong lastNotifyTimestamp = new AtomicLong();
                    this.broadcaster.subscribe((String)notifyZkPath, content -> {
                        long lastNotify;
                        long timestamp;
                        try {
                            timestamp = Long.parseLong(content);
                        }
                        catch (Exception e) {
                            logger.warn("parse notify timestamp {} failed", (Object)content, (Object)e);
                            timestamp = System.currentTimeMillis();
                        }
                        do {
                            if ((lastNotify = lastNotifyTimestamp.get()) != timestamp) continue;
                            logger.debug("notify with same timestamp {} with previous, skip", (Object)timestamp);
                            return;
                        } while (!lastNotifyTimestamp.compareAndSet(lastNotify, timestamp));
                        long deadline = sleeping.get();
                        if (deadline > 0L) {
                            logger.warn("ignore rebuild cache:{}, remaining sleep in:{}ms.", notifyZkPath, (Object)(deadline - System.currentTimeMillis()));
                            return;
                        }
                        long sleepFor = Optional.ofNullable(this.maxRandomSleepOnNotifyReload).map(LongSupplier::getAsLong).filter(it -> it > 0L).map(ThreadLocalRandom.current()::nextLong).orElse(0L);
                        sleeping.set(sleepFor + System.currentTimeMillis());
                        this.executor.schedule(() -> {
                            sleeping.set(0L);
                            this.doRebuild();
                        }, sleepFor, TimeUnit.MILLISECONDS);
                    });
                });
            }
            if (this.scheduleRunDuration != null) {
                ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setPriority(1).setNameFormat("zkAutoReloadThread-" + this.notifyZkPaths + "-%d").build());
                WeakReference<ZkNotifyReloadCache> cacheReference = new WeakReference<ZkNotifyReloadCache>(this);
                AtomicReference<Future> futureReference = new AtomicReference<Future>();
                Runnable capturedRecycleListener = this.recycleListener;
                Future scheduleFuture = MoreFutures.scheduleWithDynamicDelay((ScheduledExecutorService)scheduledExecutor, this.scheduleRunDuration, () -> {
                    ZkNotifyReloadCache thisCache = (ZkNotifyReloadCache)cacheReference.get();
                    if (thisCache == null) {
                        if (!scheduledExecutor.isShutdown()) {
                            if (futureReference.get() != null) {
                                ((Future)futureReference.get()).cancel(true);
                            }
                            scheduledExecutor.shutdownNow();
                            logger.warn("ZkNotifyReloadCache is recycled, path: {}", this.notifyZkPaths);
                            if (capturedRecycleListener != null) {
                                try {
                                    capturedRecycleListener.run();
                                }
                                catch (Throwable e) {
                                    logger.error("run cache recycle listener error", e);
                                }
                            }
                        }
                        return;
                    }
                    thisCache.doRebuild();
                });
                futureReference.set(scheduleFuture);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebuild() {
        ZkNotifyReloadCache zkNotifyReloadCache = this;
        synchronized (zkNotifyReloadCache) {
            this.doRebuild0();
        }
    }

    private void doRebuild0() {
        Object newObject = null;
        try {
            newObject = this.cacheFactory.get(this.cachedObject);
        }
        catch (Throwable e) {
            logger.error("fail to rebuild cache, remain the previous one.", e);
        }
        if (newObject != null) {
            T old = this.cachedObject;
            this.cachedObject = newObject;
            if (this.oldCleanup != null && old != this.cachedObject) {
                this.oldCleanup.accept(old);
            }
        }
    }

    @Override
    public void reload() {
        if (this.broadcaster != null && this.notifyZkPaths != null) {
            String content = String.valueOf(System.currentTimeMillis());
            this.notifyZkPaths.forEach(notifyZkPath -> this.broadcaster.broadcast((String)notifyZkPath, content));
        } else {
            logger.warn("no zk broadcast or notify zk path found. ignore reload.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadLocal() {
        ZkNotifyReloadCache zkNotifyReloadCache = this;
        synchronized (zkNotifyReloadCache) {
            if (this.cachedObject != null) {
                this.doRebuild0();
            }
        }
    }

    private Supplier<T> wrapTry(CacheFactory<T> supplier) {
        if (supplier == null) {
            return null;
        }
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                logger.error("fail to create obj.", e);
                return null;
            }
        };
    }

    private Consumer<T> wrapTry(Consumer<T> consumer) {
        if (consumer == null) {
            return t -> {};
        }
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable e) {
                logger.error("fail to cleanup.", e);
            }
        };
    }

    public static final class Builder<T> {
        private CacheFactoryEx<T> cacheFactory;
        private CacheFactory<T> firstAccessFailFactory;
        private Set<String> notifyZkPaths;
        private Consumer<T> oldCleanup;
        private LongSupplier maxRandomSleepOnNotifyReload;
        private Broadcaster broadcaster;
        private Supplier<Duration> scheduleRunDuration;
        @Nullable
        private ScheduledExecutorService executor;
        private Runnable recycleListener;

        @CheckReturnValue
        @Nonnull
        public Builder<T> subscribeThreadFactory(@Nonnull ThreadFactory threadFactory) {
            this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)Preconditions.checkNotNull((Object)threadFactory));
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> enableAutoReload(@Nonnull Supplier<Duration> duration) {
            this.scheduleRunDuration = (Supplier)Preconditions.checkNotNull(duration);
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> enableAutoReload(long timeDuration, TimeUnit unit) {
            return this.enableAutoReload(() -> Duration.ofMillis(unit.toMillis(timeDuration)));
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withZkBroadcaster(ZkBroadcaster zkBroadcaster) {
            this.broadcaster = zkBroadcaster;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withBroadcaster(@Nonnull Broadcaster broadcaster) {
            this.broadcaster = Objects.requireNonNull(broadcaster);
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withCuratorFactory(Supplier<CuratorFramework> curatorFactory) {
            return this.withCuratorFactory(curatorFactory, null);
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withCuratorFactory(Supplier<CuratorFramework> curatorFactory, String broadcastPrefix) {
            this.broadcaster = new ZkBroadcaster(curatorFactory, broadcastPrefix);
            return this;
        }

        @Nonnull
        @CheckReturnValue
        public Builder<T> withCacheFactory(CacheFactory<T> cacheFactory) {
            this.cacheFactory = prev -> cacheFactory.get();
            return this;
        }

        @Nonnull
        @CheckReturnValue
        public Builder<T> withCacheFactoryEx(CacheFactoryEx<T> cacheFactoryEx) {
            this.cacheFactory = cacheFactoryEx;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> firstAccessFailObject(T obj) {
            if (obj != null) {
                this.firstAccessFailFactory = () -> obj;
            }
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> firstAccessFailFactory(CacheFactory<T> firstAccessFailFactory) {
            this.firstAccessFailFactory = firstAccessFailFactory;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withNotifyZkPath(String notifyZkPath) {
            if (this.notifyZkPaths == null) {
                this.notifyZkPaths = new HashSet<String>();
            }
            this.notifyZkPaths.add(notifyZkPath);
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withOldCleanup(Consumer<T> oldCleanup) {
            this.oldCleanup = oldCleanup;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withMaxRandomSleepOnNotifyReload(long maxRandomSleepOnNotifyReloadInMs) {
            this.maxRandomSleepOnNotifyReload = () -> maxRandomSleepOnNotifyReloadInMs;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withMaxRandomSleepOnNotifyReload(LongSupplier maxRandomSleepOnNotifyReloadInMs) {
            this.maxRandomSleepOnNotifyReload = maxRandomSleepOnNotifyReloadInMs;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> withMaxRandomSleepOnNotifyReload(long maxRandomSleepOnNotify, TimeUnit unit) {
            return this.withMaxRandomSleepOnNotifyReload(unit.toMillis(maxRandomSleepOnNotify));
        }

        @CheckReturnValue
        @Nonnull
        public Builder<T> onResourceRecycled(Runnable recycleListener) {
            this.recycleListener = Objects.requireNonNull(recycleListener);
            return this;
        }

        @Nonnull
        public ZkNotifyReloadCache<T> build() {
            this.ensure();
            return new ZkNotifyReloadCache(this);
        }

        private void ensure() {
            Preconditions.checkNotNull(this.cacheFactory, (Object)"no cache factory.");
            if (this.notifyZkPaths != null && !this.notifyZkPaths.isEmpty()) {
                Preconditions.checkNotNull((Object)this.broadcaster, (Object)"no broadcaster.");
                if (this.executor == null) {
                    this.executor = Executors.newSingleThreadScheduledExecutor();
                }
            }
        }
    }
}

