/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.events4j.simple.domain;

import com.github.philippheuer.events4j.api.domain.IDisposable;
import com.github.philippheuer.events4j.api.domain.IEventSubscription;
import java.util.Map;
import java.util.function.Consumer;

public class SimpleDisposableWrapper
implements IEventSubscription {
    private final IDisposable disposable;
    private final String id;
    private final Class eventType;
    private final Consumer consumer;
    private final Map<String, IEventSubscription> activeSubscriptions;

    public SimpleDisposableWrapper(IDisposable disposable, String id, Class eventType, Consumer consumer, Map<String, IEventSubscription> activeSubscriptions) {
        this.disposable = disposable;
        this.id = id;
        this.eventType = eventType;
        this.consumer = consumer;
        this.activeSubscriptions = activeSubscriptions;
        activeSubscriptions.put(id, this);
    }

    public void dispose() {
        if (!this.disposable.isDisposed()) {
            this.disposable.dispose();
            this.activeSubscriptions.remove(this.id);
        }
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    public IDisposable getDisposable() {
        return this.disposable;
    }

    public String getId() {
        return this.id;
    }

    public Class getEventType() {
        return this.eventType;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Map<String, IEventSubscription> getActiveSubscriptions() {
        return this.activeSubscriptions;
    }

    public String toString() {
        return "SimpleDisposableWrapper(disposable=" + this.getDisposable() + ", id=" + this.getId() + ", eventType=" + this.getEventType() + ", consumer=" + this.getConsumer() + ")";
    }
}

