/*
 * Decompiled with CFR 0.152.
 */
package com.github.phisgr.gatling.grpc.stream;

import com.github.phisgr.gatling.generic.SessionCombiner;
import com.github.phisgr.gatling.grpc.check.GrpcResponse;
import com.github.phisgr.gatling.grpc.check.StreamCheck;
import com.github.phisgr.gatling.grpc.stream.ClientStreamer;
import com.github.phisgr.gatling.grpc.stream.StreamCall;
import com.github.phisgr.gatling.grpc.stream.StreamCall$BothOpen$;
import com.github.phisgr.gatling.grpc.stream.StreamCall$Receiving$;
import com.github.phisgr.gatling.grpc.stream.StreamListener;
import com.github.phisgr.gatling.grpc.stream.TimestampExtractor;
import com.github.phisgr.gatling.grpc.util.package$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.structure.ScenarioContext;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001\u0002\n\u0014\u0001\u0001B\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t3\u0002\u0011\t\u0011)A\u0005#\"I!\f\u0001B\u0001B\u0003%1L\u0019\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"Aq\r\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003s\u0011!)\bA!A!\u0002\u00131\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B?\t\u0015\u0005\u001d\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0006\u0002(\u0001\u0011\t\u0011)A\u0005\u0003SA!\"a\u0010\u0001\u0005\u0003\u0005\u000b\u0011BA!\u0011)\t9\u0005\u0001B\u0001B\u0003%\u0011\u0011\n\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\ti\u0007\u0001C\u0006\u0003_Bq!! \u0001\t\u0003\ny\bC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005E\u0006\u0001\"\u0003\u00024\nq!)\u001b3j'R\u0014X-Y7DC2d'B\u0001\u000b\u0016\u0003\u0019\u0019HO]3b[*\u0011acF\u0001\u0005OJ\u00048M\u0003\u0002\u00193\u00059q-\u0019;mS:<'B\u0001\u000e\u001c\u0003\u0019\u0001\b.[:he*\u0011A$H\u0001\u0007O&$\b.\u001e2\u000b\u0003y\t1aY8n\u0007\u0001)2!\t\u00156'\r\u0001!%\u0014\t\u0006G\u00112CgN\u0007\u0002'%\u0011Qe\u0005\u0002\u000b'R\u0014X-Y7DC2d\u0007CA\u0014)\u0019\u0001!Q!\u000b\u0001C\u0002)\u00121AU3r#\tY\u0013\u0007\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0004O_RD\u0017N\\4\u0011\u00051\u0012\u0014BA\u001a.\u0005\r\te.\u001f\t\u0003OU\"QA\u000e\u0001C\u0002)\u00121AU3t!\tA$J\u0004\u0002:\u0011:\u0011!h\u0012\b\u0003w\u0019s!\u0001P#\u000f\u0005u\"eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\tu$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A$H\u0005\u00035mI!\u0001G\r\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\tI5#\u0001\u0006TiJ,\u0017-\\\"bY2L!a\u0013'\u0003\u001f\tKG-[*ue\u0016\fWn\u0015;bi\u0016T!!S\n\u0011\u0007\rre%\u0003\u0002P'\tq1\t\\5f]R\u001cFO]3b[\u0016\u0014\u0018a\u0003:fcV,7\u000f\u001e(b[\u0016\u0004\"A\u0015,\u000f\u0005M#\u0006CA .\u0013\t)V&\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+.\u0003)\u0019HO]3b[:\u000bW.Z\u0001\u0005G\u0006dG\u000e\u0005\u0003]A\u001a\nT\"A/\u000b\u0005Yq&\"A0\u0002\u0005%|\u0017BA1^\u0005)\u0019E.[3oi\u000e\u000bG\u000e\\\u0005\u00035\u0012\nq\u0001[3bI\u0016\u00148\u000f\u0005\u0002]K&\u0011a-\u0018\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006\u00191\r\u001e=\u0011\u0005%|W\"\u00016\u000b\u0005-d\u0017!C:ueV\u001cG/\u001e:f\u0015\tig.\u0001\u0003d_J,'B\u0001\r_\u0013\t\u0001(NA\bTG\u0016t\u0017M]5p\u0007>tG/\u001a=u\u0003I!\u0018.\\3ti\u0006l\u0007/\u0012=ue\u0006\u001cGo\u001c:\u0011\u0007\r\u001aH'\u0003\u0002u'\t\u0011B+[7fgR\fW\u000e]#yiJ\f7\r^8s\u0003\u001d\u0019w.\u001c2j]\u0016\u0004\"a\u001e>\u000e\u0003aT!!_\f\u0002\u000f\u001d,g.\u001a:jG&\u00111\u0010\u001f\u0002\u0010'\u0016\u001c8/[8o\u0007>l'-\u001b8fe\u0006y1\u000f^1si&twmU3tg&|g\u000eE\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003a\u0017aB:fgNLwN\\\u0005\u0004\u0003\u000by(aB*fgNLwN\\\u0001\u0007G\",7m[:\u0011\r\u0005-\u0011QCA\u000e\u001d\u0011\ti!!\u0005\u000f\u0007}\ny!C\u0001/\u0013\r\t\u0019\"L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9\"!\u0007\u0003\t1K7\u000f\u001e\u0006\u0004\u0003'i\u0003#BA\u000f\u0003G!TBAA\u0010\u0015\r\t\t#F\u0001\u0006G\",7m[\u0005\u0005\u0003K\tyBA\u0006TiJ,\u0017-\\\"iK\u000e\\\u0017!C3oI\u000eCWmY6t!\u0019\tY!!\u0006\u0002,A1\u0011QDA\u0012\u0003[\u0001B!a\f\u0002:9!\u0011\u0011GA\u001b\u001d\rQ\u00141G\u0005\u0004\u0003C)\u0012\u0002BA\u001c\u0003?\tAb\u0012:qGJ+7\u000f]8og\u0016LA!a\u000f\u0002>\tiqI\u001d9d'R\u0014X-Y7F]\u0012TA!a\u000e\u0002 \u0005A!/Z9DY\u0006\u001c8\u000f\u0005\u0003S\u0003\u00072\u0013bAA#1\n)1\t\\1tg\u0006i\u0011n\u001a8pe\u0016lUm]:bO\u0016\u00042\u0001LA&\u0013\r\ti%\f\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}QQ\u00121KA+\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\n9'!\u001b\u0002lA!1\u0005\u0001\u00145\u0011\u0015\u0001V\u00021\u0001R\u0011\u0015IV\u00021\u0001R\u0011\u0015QV\u00021\u0001\\\u0011\u0015\u0019W\u00021\u0001e\u0011\u00159W\u00021\u0001i\u0011\u0015\tX\u00021\u0001s\u0011\u0015)X\u00021\u0001w\u0011\u0015aX\u00021\u0001~\u0011\u001d\t9!\u0004a\u0001\u0003\u0013Aq!a\n\u000e\u0001\u0004\tI\u0003C\u0004\u0002@5\u0001\r!!\u0011\t\u000f\u0005\u001dS\u00021\u0001\u0002J\u00051!/Z9UC\u001e,\"!!\u001d\u0011\u000b\u0005M\u0014\u0011\u0010\u0014\u000e\u0005\u0005U$bAA<[\u00059!/\u001a4mK\u000e$\u0018\u0002BA>\u0003k\u0012\u0001b\u00117bgN$\u0016mZ\u0001\u0006_:\u0014V-\u001d\u000b\u0005\u0003\u0003\u000b9\n\u0005\u0004\u0002\u0004\u00065\u0015\u0011S\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0007\u0005-e.A\u0004d_6lwN\\:\n\t\u0005=\u0015Q\u0011\u0002\u000b-\u0006d\u0017\u000eZ1uS>t\u0007c\u0001\u0017\u0002\u0014&\u0019\u0011QS\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u00033{\u0001\u0019\u0001\u0014\u0002\u0007I,\u0017/A\tp]\u000ec\u0017.\u001a8u\u0007>l\u0007\u000f\\3uK\u0012$b!!!\u0002 \u0006\u0005\u0006BBA\u0001!\u0001\u0007Q\u0010C\u0004\u0002$B\u0001\r!!*\u0002\t9,\u0007\u0010\u001e\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111\u00167\u0002\r\u0005\u001cG/[8o\u0013\u0011\ty+!+\u0003\r\u0005\u001bG/[8o\u0003E\tGN]3bIfD\u0015\r\u001c4DY>\u001cX\rZ\u000b\u0003\u0003k\u0003B!a!\u00028&!\u0011\u0011XAC\u0005\u001d1\u0015-\u001b7ve\u0016\u0004")
public class BidiStreamCall<Req, Res>
extends StreamCall<Req, Res, StreamCall.BidiStreamState>
implements ClientStreamer<Req> {
    private final String streamName;
    private final Class<Req> reqClass;

    private ClassTag<Req> reqTag() {
        return ClassTag$.MODULE$.apply(this.reqClass);
    }

    @Override
    public Validation<BoxedUnit> onReq(Req req) {
        if (!this.reqClass.isInstance(req)) {
            return package$.MODULE$.wrongTypeMessage(req, this.reqTag());
        }
        StreamCall.BidiStreamState bidiStreamState = (StreamCall.BidiStreamState)this.state();
        if (StreamCall$BothOpen$.MODULE$.equals(bidiStreamState)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Sending message {} with stream '{}': Scenario '{}', UserId #{}", new Object[]{package$.MODULE$.toProtoString(req), this.streamName, this.streamSession().scenario(), BoxesRunTime.boxToLong((long)this.streamSession().userId())});
            }
            super.call().sendMessage(req);
        } else {
            if (StreamCall$Receiving$.MODULE$.equals(bidiStreamState)) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Client issued message after client completion in stream {}", new Object[]{this.streamName});
                }
                return this.alreadyHalfClosed();
            }
            if (bidiStreamState instanceof StreamCall.Completed) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Client issued message but stream {} already completed", new Object[]{this.streamName});
                }
            } else {
                throw new MatchError((Object)bidiStreamState);
            }
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    public Validation<BoxedUnit> onClientCompleted(Session session, Action next) {
        StreamCall.BidiStreamState bidiStreamState = (StreamCall.BidiStreamState)this.state();
        if (StreamCall$Receiving$.MODULE$.equals(bidiStreamState)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Client completed bidi stream {} twice", new Object[]{this.streamName});
            }
            return this.alreadyHalfClosed();
        }
        if (StreamCall$BothOpen$.MODULE$.equals(bidiStreamState)) {
            this.state_$eq(StreamCall$Receiving$.MODULE$);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Completing bidi stream '{}': Scenario '{}', UserId #{}", new Object[]{this.streamName, session.scenario(), BoxesRunTime.boxToLong((long)session.userId())});
            }
            super.call().halfClose();
        } else if (bidiStreamState instanceof StreamCall.Completed) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Client issued complete order but stream {} already completed", new Object[]{this.streamName});
            }
        } else {
            throw new MatchError((Object)bidiStreamState);
        }
        this.combineState(session, next);
        return new Success((Object)BoxedUnit.UNIT);
    }

    private Failure alreadyHalfClosed() {
        return new Failure(new StringBuilder(35).append("Stream ").append(this.streamName).append(" already completed by client").toString());
    }

    public BidiStreamCall(String requestName, String streamName, ClientCall<Req, Object> call, Metadata headers, ScenarioContext ctx, TimestampExtractor<Res> timestampExtractor, SessionCombiner combine, Session startingSession, List<StreamCheck<Res>> checks, List<StreamCheck<GrpcResponse<Null$>>> endChecks, Class<Req> reqClass, boolean ignoreMessage) {
        this.streamName = streamName;
        this.reqClass = reqClass;
        super(requestName, streamName, StreamCall$BothOpen$.MODULE$, startingSession, call, timestampExtractor, combine, checks, endChecks, ctx.coreComponents().statsEngine());
        Clock clock = ctx.coreComponents().clock();
        try {
            StreamListener listener = new StreamListener(this, clock, this.streamSession().eventLoop(), ignoreMessage);
            this.callStartTime_$eq(clock.nowMillis());
            super.call().start(listener, headers);
            super.call().request(1);
            return;
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Call failed", e);
                }
                this.onServerCompleted(Status.ABORTED.withCause(e), new Metadata(), clock.nowMillis());
                return;
            }
            throw throwable;
        }
    }
}

