/*
 * Decompiled with CFR 0.152.
 */
package com.github.phiz71.vertx.swagger.router.auth;

import com.github.phiz71.vertx.swagger.router.auth.AuthProviderFactory;
import io.vertx.ext.auth.AuthProvider;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AuthProviderRegistry
implements AuthProviderFactory {
    private static AuthProviderRegistry instance = new AuthProviderRegistry();
    private Map<String, AuthProvider> authProviders = new ConcurrentHashMap<String, AuthProvider>();

    public static AuthProviderFactory getAuthProviderFactory() {
        return instance;
    }

    public static void register(AuthProviderFactory factory) {
        AuthProviderRegistry.instance.authProviders.putAll(factory.getAuthProviders());
    }

    public static void register(String name, AuthProvider authProvider) {
        AuthProviderRegistry.instance.authProviders.put(name, authProvider);
    }

    public static void clearRegistry() {
        AuthProviderRegistry.instance.authProviders.clear();
    }

    @Override
    public AuthProvider getAuthProviderByName(String name) {
        return this.authProviders.get(name);
    }

    @Override
    public Map<String, AuthProvider> getAuthProviders() {
        return Collections.unmodifiableMap(this.authProviders);
    }
}

