/*
 * Decompiled with CFR 0.152.
 */
package com.github.phiz71.vertx.swagger.router.auth;

import com.github.phiz71.vertx.swagger.router.auth.ApiKeyAuthHandler;
import com.github.phiz71.vertx.swagger.router.auth.AuthProviderRegistry;
import com.github.phiz71.vertx.swagger.router.auth.InterceptableRoutingContext;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SwaggerAuthHandlerFactory {
    private static Logger vertxLogger = LoggerFactory.getLogger(SwaggerAuthHandlerFactory.class);
    private final Map<String, AuthHandler> authHandlers = new ConcurrentHashMap<String, AuthHandler>();
    private final Map<String, SecuritySchemeDefinition> securitySchemes;

    public static SwaggerAuthHandlerFactory create(Map<String, SecuritySchemeDefinition> securitySchemes) {
        return new SwaggerAuthHandlerFactory(securitySchemes);
    }

    private SwaggerAuthHandlerFactory(Map<String, SecuritySchemeDefinition> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    private AuthHandler getAuthHandler(String name) {
        AuthHandler authHandler = this.authHandlers.get(name);
        if (authHandler != null) {
            return authHandler;
        }
        AuthProvider authProvider = AuthProviderRegistry.getAuthProviderFactory().getAuthProviderByName(name);
        if (authProvider == null) {
            return null;
        }
        SecuritySchemeDefinition securityScheme = this.securitySchemes.get(name);
        if (securityScheme != null) {
            switch (securityScheme.getType()) {
                case "apiKey": {
                    ApiKeyAuthDefinition apiKeyAuthDefinition = (ApiKeyAuthDefinition)securityScheme;
                    ApiKeyAuthHandler.Location apiKeyLocation = ApiKeyAuthHandler.Location.valueOf(apiKeyAuthDefinition.getIn().name());
                    authHandler = ApiKeyAuthHandler.create(authProvider, apiKeyLocation, apiKeyAuthDefinition.getName());
                    break;
                }
                case "basic": {
                    authHandler = BasicAuthHandler.create((AuthProvider)authProvider);
                    break;
                }
                case "oauth2": {
                    vertxLogger.warn((Object)"OAuth2 authentication has not been implemented yet!");
                    break;
                }
                default: {
                    vertxLogger.warn((Object)("SecurityScheme is not authorized : " + securityScheme.getType()));
                }
            }
            if (authHandler != null) {
                this.authHandlers.put(name, authHandler);
            }
        } else {
            vertxLogger.warn((Object)("No securityScheme definition in swagger file for auth provider: " + name));
        }
        return authHandler;
    }

    public AuthHandler createAuthHandler(final List<Map<String, List<String>>> security) {
        return new AuthHandler(){
            private Set<String> authorities = new HashSet<String>();

            public AuthHandler addAuthority(String authority) {
                this.authorities.add(authority);
                return this;
            }

            public AuthHandler addAuthorities(Set<String> authorities) {
                this.authorities.addAll(authorities);
                return this;
            }

            public void parseCredentials(RoutingContext routingContext, Handler<AsyncResult<JsonObject>> handler) {
            }

            public void authorize(User user, Handler<AsyncResult<Void>> handler) {
            }

            private void handle(InterceptableRoutingContext context, int orLevelIndex, int andLevelIndex) {
                Map orSecurityIdentifiers;
                context.clearUser();
                context.setNextCallback(null);
                context.setFailedCallback(null);
                if (andLevelIndex < ((Map)security.get(orLevelIndex)).size() - 1) {
                    context.setNextCallback(() -> this.handle(context, orLevelIndex, andLevelIndex + 1));
                }
                if (orLevelIndex < security.size() - 1) {
                    context.setFailedCallback(() -> this.handle(context, orLevelIndex + 1, 0));
                }
                if (!(orSecurityIdentifiers = (Map)security.get(orLevelIndex)).isEmpty()) {
                    ArrayList andSecurityIdentifiers = new ArrayList(orSecurityIdentifiers.keySet());
                    String securityIdentifier = (String)andSecurityIdentifiers.get(andLevelIndex);
                    AuthHandler handler = SwaggerAuthHandlerFactory.this.getAuthHandler(securityIdentifier);
                    if (handler != null) {
                        context.put("AUTH_PROVIDER_NAME", securityIdentifier);
                        handler.addAuthorities(this.authorities).handle((Object)context);
                    } else {
                        context.fail(401);
                    }
                } else {
                    context.fail(401);
                }
            }

            public void handle(RoutingContext context) {
                this.handle(new InterceptableRoutingContext(context), 0, 0);
            }
        };
    }
}

