/*
 * Decompiled with CFR 0.152.
 */
package com.github.picadoh.imc.model;

import com.google.common.base.Objects;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public class JavaMemoryObject
implements JavaFileObject {
    private ByteArrayOutputStream bos;
    private URI uri;
    private JavaFileObject.Kind kind;

    public JavaMemoryObject(String fileName, JavaFileObject.Kind fileKind) {
        this.uri = URI.create("string:///" + fileName.replace('.', '/') + fileKind.extension);
        this.kind = fileKind;
        this.bos = new ByteArrayOutputStream();
    }

    public byte[] getClassBytes() {
        return this.bos.toByteArray();
    }

    @Override
    public final URI toUri() {
        return this.uri;
    }

    @Override
    public final String getName() {
        return this.uri.getPath();
    }

    @Override
    public final InputStream openInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final OutputStream openOutputStream() throws IOException {
        return this.bos;
    }

    @Override
    public final Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream());
    }

    @Override
    public final long getLastModified() {
        return 0L;
    }

    @Override
    public final boolean delete() {
        return false;
    }

    @Override
    public final JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public final boolean isNameCompatible(String simpleName, JavaFileObject.Kind fileKind) {
        String baseName = simpleName + this.kind.extension;
        return fileKind.equals((Object)this.getKind()) && (baseName.equals(this.toUri().getPath()) || this.toUri().getPath().endsWith("/" + baseName));
    }

    @Override
    public final NestingKind getNestingKind() {
        return null;
    }

    @Override
    public final Modifier getAccessLevel() {
        return null;
    }

    public final String toString() {
        return this.getClass().getName() + "[" + this.toUri() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMemoryObject that = (JavaMemoryObject)o;
        return Objects.equal((Object)this.uri, (Object)that.uri) && Objects.equal((Object)((Object)this.kind), (Object)((Object)that.kind));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uri, this.kind});
    }
}

