/*
 * Decompiled with CFR 0.152.
 */
package pl.piomin.logging.config;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import com.github.loki4j.logback.AbstractLoki4jEncoder;
import com.github.loki4j.logback.HttpSender;
import com.github.loki4j.logback.JavaHttpSender;
import com.github.loki4j.logback.JsonEncoder;
import com.github.loki4j.logback.JsonLayout;
import com.github.loki4j.logback.Loki4jAppender;
import com.github.loki4j.logback.Loki4jEncoder;
import java.util.ArrayList;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import pl.piomin.logging.client.RestTemplateSetHeaderInterceptor;
import pl.piomin.logging.filter.SpringLoggingFilter;
import pl.piomin.logging.util.UniqueIDGenerator;

@Configuration
@ConfigurationProperties(prefix="logging.loki")
public class SpringLoggingAutoConfiguration {
    private static final String LOKI_APPENDER_NAME = "LOKI";
    private String url = "http://localhost:3100/loki/api/v1/push";
    private String ignorePatterns;
    private boolean logHeaders;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String requestIdHeaderName = "X-Request-ID";
    private String correlationIdHeaderName = "X-Correlation-ID";
    @Value(value="${spring.application.name:-}")
    String name;

    @Bean
    public UniqueIDGenerator generator() {
        return new UniqueIDGenerator(this.requestIdHeaderName, this.correlationIdHeaderName);
    }

    @Bean
    public SpringLoggingFilter loggingFilter() {
        return new SpringLoggingFilter(this.generator(), this.ignorePatterns, this.logHeaders);
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnBean
    public RestTemplate existingRestTemplate(RestTemplate restTemplate) {
        ArrayList<RestTemplateSetHeaderInterceptor> interceptorList = new ArrayList<RestTemplateSetHeaderInterceptor>();
        interceptorList.add(new RestTemplateSetHeaderInterceptor());
        restTemplate.setInterceptors(interceptorList);
        return restTemplate;
    }

    @Bean
    @ConditionalOnProperty(value={"logging.loki.enabled"}, matchIfMissing=true, havingValue="true")
    public Loki4jAppender lokiAppender() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Loki4jAppender loki4jAppender = new Loki4jAppender();
        loki4jAppender.setContext((Context)loggerContext);
        loki4jAppender.setName(LOKI_APPENDER_NAME);
        JavaHttpSender httpSender = new JavaHttpSender();
        httpSender.setUrl(this.url);
        loki4jAppender.setHttp((HttpSender)httpSender);
        JsonEncoder encoder = new JsonEncoder();
        encoder.setContext((Context)loggerContext);
        AbstractLoki4jEncoder.LabelCfg label = new AbstractLoki4jEncoder.LabelCfg();
        label.setReadMarkers(true);
        label.setPattern("app=" + this.name + ",host=${HOSTNAME},level=%level");
        encoder.setLabel(label);
        encoder.setSortByTime(true);
        JsonLayout l = new JsonLayout();
        encoder.setMessage((Layout)l);
        encoder.start();
        loki4jAppender.setFormat((Loki4jEncoder)encoder);
        loki4jAppender.start();
        loggerContext.getLogger("ROOT").addAppender((Appender)loki4jAppender);
        return loki4jAppender;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getIgnorePatterns() {
        return this.ignorePatterns;
    }

    public void setIgnorePatterns(String ignorePatterns) {
        this.ignorePatterns = ignorePatterns;
    }

    public boolean isLogHeaders() {
        return this.logHeaders;
    }

    public void setLogHeaders(boolean logHeaders) {
        this.logHeaders = logHeaders;
    }

    public String getRequestIdHeaderName() {
        return this.requestIdHeaderName;
    }

    public void setRequestIdHeaderName(String requestIdHeaderName) {
        this.requestIdHeaderName = requestIdHeaderName;
    }

    public String getCorrelationIdHeaderName() {
        return this.correlationIdHeaderName;
    }

    public void setCorrelationIdHeaderName(String correlationIdHeaderName) {
        this.correlationIdHeaderName = correlationIdHeaderName;
    }
}

