/*
 * Decompiled with CFR 0.152.
 */
package pl.piomin.logging.filter;

import com.github.loki4j.slf4j.marker.LabelMarker;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import pl.piomin.logging.util.UniqueIDGenerator;
import pl.piomin.logging.wrapper.SpringRequestWrapper;
import pl.piomin.logging.wrapper.SpringResponseWrapper;

public class SpringLoggingFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringLoggingFilter.class);
    private UniqueIDGenerator generator;
    private String ignorePatterns;
    private boolean logHeaders;
    @Autowired
    ApplicationContext context;

    public SpringLoggingFilter(UniqueIDGenerator generator, String ignorePatterns, boolean logHeaders) {
        this.generator = generator;
        this.ignorePatterns = ignorePatterns;
        this.logHeaders = logHeaders;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.ignorePatterns != null && request.getRequestURI().matches(this.ignorePatterns)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            this.generator.generateAndSetMDC(request);
            try {
                this.getHandlerMethod(request);
            }
            catch (Exception e) {
                LOGGER.trace("Cannot get handler method");
            }
            long startTime = System.currentTimeMillis();
            SpringRequestWrapper wrappedRequest = new SpringRequestWrapper(request);
            LabelMarker marker = LabelMarker.of(() -> Map.of("audit", "true", "requestId", MDC.get((String)"X-Request-ID"), "correlationId", MDC.get((String)"X-Correlation-ID")));
            if (this.logHeaders) {
                LOGGER.info((Marker)marker, "Request: method={}, uri={}, payload={}, headers={}, audit={}", new Object[]{wrappedRequest.getMethod(), wrappedRequest.getRequestURI(), IOUtils.toString((InputStream)wrappedRequest.getInputStream(), (String)wrappedRequest.getCharacterEncoding()), wrappedRequest.getAllHeaders(), true});
            } else {
                LOGGER.info((Marker)marker, "Request: method={}, uri={}, payload={}, audit={}", new Object[]{wrappedRequest.getMethod(), wrappedRequest.getRequestURI(), IOUtils.toString((InputStream)wrappedRequest.getInputStream(), (String)wrappedRequest.getCharacterEncoding()), true});
            }
            SpringResponseWrapper wrappedResponse = new SpringResponseWrapper(response);
            wrappedResponse.setHeader("X-Request-ID", MDC.get((String)"X-Request-ID"));
            wrappedResponse.setHeader("X-Correlation-ID", MDC.get((String)"X-Correlation-ID"));
            try {
                chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
            }
            catch (Exception e) {
                this.logResponse(startTime, wrappedResponse, 500);
                throw e;
            }
            this.logResponse(startTime, wrappedResponse, wrappedResponse.getStatus());
        }
    }

    private void logResponse(long startTime, SpringResponseWrapper wrappedResponse, int overriddenStatus) throws IOException {
        long duration = System.currentTimeMillis() - startTime;
        wrappedResponse.setCharacterEncoding("UTF-8");
        LabelMarker marker = LabelMarker.of(() -> Map.of("responseTime", String.valueOf(duration), "responseStatus", String.valueOf(overriddenStatus), "audit", "true", "requestId", MDC.get((String)"X-Request-ID"), "correlationId", MDC.get((String)"X-Correlation-ID")));
        if (this.logHeaders) {
            LOGGER.info((Marker)marker, "Response({} ms): status={}, payload={}, headers={}, audit={}", new Object[]{duration, overriddenStatus, IOUtils.toString((byte[])wrappedResponse.getContentAsByteArray(), (String)wrappedResponse.getCharacterEncoding()), wrappedResponse.getAllHeaders(), true});
        } else {
            LOGGER.info((Marker)marker, "Response({} ms): status={}, payload={}, audit={}", new Object[]{duration, overriddenStatus, IOUtils.toString((byte[])wrappedResponse.getContentAsByteArray(), (String)wrappedResponse.getCharacterEncoding()), true});
        }
    }

    private void getHandlerMethod(HttpServletRequest request) throws Exception {
        RequestMappingHandlerMapping mappings1 = (RequestMappingHandlerMapping)this.context.getBean("requestMappingHandlerMapping");
        Map handlerMethods = mappings1.getHandlerMethods();
        HandlerExecutionChain handler = mappings1.getHandler(request);
        if (Objects.nonNull(handler)) {
            HandlerMethod handler1 = (HandlerMethod)handler.getHandler();
            MDC.put((String)"X-Operation-Name", (String)(handler1.getBeanType().getSimpleName() + "." + handler1.getMethod().getName()));
        }
    }
}

