/*
 * Decompiled with CFR 0.152.
 */
package pl.piomin.logging.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.UUID;
import org.slf4j.MDC;

public class UniqueIDGenerator {
    private final String requestIdHeaderName;
    private final String correlationIdHeaderName;

    public UniqueIDGenerator(String requestIdHeaderName, String correlationIdHeaderName) {
        this.requestIdHeaderName = requestIdHeaderName;
        this.correlationIdHeaderName = correlationIdHeaderName;
    }

    public void generateAndSetMDC(HttpServletRequest request) {
        String requestId = request.getHeader(this.requestIdHeaderName);
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        MDC.put((String)this.requestIdHeaderName, (String)requestId);
        String correlationId = request.getHeader(this.correlationIdHeaderName);
        if (correlationId == null) {
            correlationId = UUID.randomUUID().toString();
        }
        MDC.put((String)this.correlationIdHeaderName, (String)correlationId);
    }
}

