/*
 * Decompiled with CFR 0.152.
 */
package com.datawizards.class2csv;

import com.datawizards.class2csv.package;
import com.datawizards.metadata.ClassMetadata$;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Date;
import org.json4s.DefaultFormats$;
import org.json4s.Extraction$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import shapeless.;
import shapeless.Generic;
import shapeless.HList;
import shapeless.HNil;
import shapeless.Lazy;

public final class package$ {
    public static final package$ MODULE$;
    private final package.FieldCsvEncoder<String> stringEnc;
    private final package.FieldCsvEncoder<Object> intEnc;
    private final package.FieldCsvEncoder<Object> booleanEnc;
    private final package.FieldCsvEncoder<Object> longEnc;
    private final package.FieldCsvEncoder<Object> doubleEnc;
    private final package.FieldCsvEncoder<Object> floatEnc;
    private final package.FieldCsvEncoder<Object> shortEnc;
    private final package.FieldCsvEncoder<Object> charEnc;
    private final package.FieldCsvEncoder<Object> byteEnc;
    private final package.FieldCsvEncoder<java.util.Date> dateEnc;
    private final package.FieldCsvEncoder<Date> dateSqlEnc;
    private final package.FieldCsvEncoder<BigInt> bigIntEnc;
    private final package.CsvEncoder<HNil> hnilEncoder;

    static {
        new package$();
    }

    public <A> package.CsvEncoder<A> createEncoder(Function1<A, List<String>> func) {
        return new package.CsvEncoder<A>(func){
            private final Function1 func$1;

            public List<String> encode(A value) {
                return (List)this.func$1.apply(value);
            }
            {
                this.func$1 = func$1;
            }
        };
    }

    public <A> package.FieldCsvEncoder<A> createFieldEncoder(Function1<A, List<String>> func) {
        return new package.FieldCsvEncoder<A>(func){
            private final Function1 func$2;

            public List<String> encode(A value) {
                return (List)this.func$2.apply(value);
            }
            {
                this.func$2 = func$2;
            }
        };
    }

    public package.FieldCsvEncoder<String> stringEnc() {
        return this.stringEnc;
    }

    public package.FieldCsvEncoder<Object> intEnc() {
        return this.intEnc;
    }

    public package.FieldCsvEncoder<Object> booleanEnc() {
        return this.booleanEnc;
    }

    public package.FieldCsvEncoder<Object> longEnc() {
        return this.longEnc;
    }

    public package.FieldCsvEncoder<Object> doubleEnc() {
        return this.doubleEnc;
    }

    public package.FieldCsvEncoder<Object> floatEnc() {
        return this.floatEnc;
    }

    public package.FieldCsvEncoder<Object> shortEnc() {
        return this.shortEnc;
    }

    public package.FieldCsvEncoder<Object> charEnc() {
        return this.charEnc;
    }

    public package.FieldCsvEncoder<Object> byteEnc() {
        return this.byteEnc;
    }

    public package.FieldCsvEncoder<java.util.Date> dateEnc() {
        return this.dateEnc;
    }

    public package.FieldCsvEncoder<Date> dateSqlEnc() {
        return this.dateSqlEnc;
    }

    public package.FieldCsvEncoder<BigInt> bigIntEnc() {
        return this.bigIntEnc;
    }

    public <T> package.FieldCsvEncoder<Option<T>> optionEnc(package.FieldCsvEncoder<T> innerEncoder) {
        return new package.FieldCsvEncoder<Option<T>>(innerEncoder){
            private final package.FieldCsvEncoder innerEncoder$1;

            public List<String> encode(Option<T> value) {
                return value.isDefined() ? this.innerEncoder$1.encode(value.get()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
            }
            {
                this.innerEncoder$1 = innerEncoder$1;
            }
        };
    }

    public <T> package.FieldCsvEncoder<T> jsonEncoder() {
        return new package.FieldCsvEncoder<T>(){
            private final DefaultFormats$ formats;

            private DefaultFormats$ formats() {
                return this.formats;
            }

            public List<String> encode(T value) {
                JsonAST.JValue json = Extraction$.MODULE$.decompose(value, (Formats)this.formats());
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{JsonMethods$.MODULE$.mapper().writeValueAsString((Object)json)}));
            }
            {
                this.formats = DefaultFormats$.MODULE$;
            }
        };
    }

    public <T> package.FieldCsvEncoder<Seq<T>> seqEncoder() {
        return this.jsonEncoder();
    }

    public <T> package.FieldCsvEncoder<T> otherFieldEncoder() {
        return this.jsonEncoder();
    }

    public package.CsvEncoder<HNil> hnilEncoder() {
        return this.hnilEncoder;
    }

    public <H, T extends HList> package.CsvEncoder<.colon.colon<H, T>> hlistEncoder(Lazy<package.FieldCsvEncoder<H>> hEncoder, package.CsvEncoder<T> tEncoder) {
        return this.createEncoder((Function1)new Serializable(hEncoder, tEncoder){
            public static final long serialVersionUID = 0L;
            private final Lazy hEncoder$1;
            private final package.CsvEncoder tEncoder$1;

            public final List<String> apply(.colon.colon<H, T> x0$1) {
                .colon.colon<H, T> colon2 = x0$1;
                if (colon2 != null) {
                    Object h = colon2.head();
                    HList t = colon2.tail();
                    List list = (List)((package.FieldCsvEncoder)this.hEncoder$1.value()).encode(h).$plus$plus(this.tEncoder$1.encode(t), List$.MODULE$.canBuildFrom());
                    return list;
                }
                throw new MatchError(colon2);
            }
            {
                this.hEncoder$1 = hEncoder$1;
                this.tEncoder$1 = tEncoder$1;
            }
        });
    }

    public <A, R> package.CsvEncoder<A> genericEncoder(Generic<A> gen, Lazy<package.CsvEncoder<R>> rEncoder) {
        return this.createEncoder((Function1<A, List<String>>)new Serializable(gen, rEncoder){
            public static final long serialVersionUID = 0L;
            private final Generic gen$1;
            private final Lazy rEncoder$1;

            public final List<String> apply(A value) {
                return ((package.CsvEncoder)this.rEncoder$1.value()).encode(this.gen$1.to(value));
            }
            {
                this.gen$1 = gen$1;
                this.rEncoder$1 = rEncoder$1;
            }
        });
    }

    public <T> void writeCSV(Traversable<T> data, String path, char delimiter, boolean header, Seq<String> columns, char escape, char quote, ClassTag<T> ct, package.CsvEncoder<T> encoder) {
        PrintWriter pw = new PrintWriter(path);
        CsvWriterSettings settings = new CsvWriterSettings();
        ((CsvFormat)settings.getFormat()).setDelimiter(delimiter);
        ((CsvFormat)settings.getFormat()).setQuote(quote);
        ((CsvFormat)settings.getFormat()).setQuoteEscape(escape);
        CsvWriter csvWriter = new CsvWriter((Writer)pw, settings);
        if (header) {
            Seq<String> headerColumns = columns.isEmpty() ? ClassMetadata$.MODULE$.getClassFields(ct) : columns;
            csvWriter.writeHeaders((String[])headerColumns.toArray(ClassTag$.MODULE$.apply(String.class)));
        }
        data.foreach((Function1)new Serializable(encoder, csvWriter){
            public static final long serialVersionUID = 0L;
            private final package.CsvEncoder encoder$1;
            private final CsvWriter csvWriter$1;

            public final void apply(T e) {
                this.csvWriter$1.writeRow((String[])this.encoder$1.encode(e).toArray(ClassTag$.MODULE$.apply(String.class)));
            }
            {
                this.encoder$1 = encoder$1;
                this.csvWriter$1 = csvWriter$1;
            }
        });
        pw.close();
    }

    public <T> char writeCSV$default$3() {
        return ',';
    }

    public <T> boolean writeCSV$default$4() {
        return true;
    }

    public <T> Seq<String> writeCSV$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public <T> char writeCSV$default$6() {
        return '\"';
    }

    public <T> char writeCSV$default$7() {
        return '\"';
    }

    private package$() {
        MODULE$ = this;
        this.stringEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(String str) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{str}));
            }
        });
        this.intEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(int num) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)num)).toString()}));
            }
        });
        this.booleanEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(boolean bool) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToBoolean((boolean)bool)).toString()}));
            }
        });
        this.longEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(long num) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToLong((long)num)).toString()}));
            }
        });
        this.doubleEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(double num) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToDouble((double)num)).toString()}));
            }
        });
        this.floatEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(float num) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToFloat((float)num)).toString()}));
            }
        });
        this.shortEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(short num) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToShort((short)num)).toString()}));
            }
        });
        this.charEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(char num) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToCharacter((char)num)).toString()}));
            }
        });
        this.byteEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(byte num) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToByte((byte)num)).toString()}));
            }
        });
        this.dateEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(java.util.Date date) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)date), "%tY-%1$tm-%1$td")}));
            }
        });
        this.dateSqlEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(Date date) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{date.toString()}));
            }
        });
        this.bigIntEnc = this.createFieldEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(BigInt num) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{num.toString()}));
            }
        });
        this.hnilEncoder = this.createEncoder((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply(HNil hnil) {
                return Nil$.MODULE$;
            }
        });
    }
}

