/*
 * Decompiled with CFR 0.152.
 */
package be.ugent;

import be.ugent.RDFWriter;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class IfcSpfReader {
    private String timeLog = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
    public final String DEFAULT_PATH = "http://linkedbuildingdata.net/ifc/resources" + this.timeLog + "/";
    public boolean logToFile = false;
    public BufferedWriter bw;
    private boolean removeDuplicates = false;
    private static final int FLAG_LOG = 0;
    private static final int FLAG_DIR = 1;
    private static final int FLAG_JSON = 2;
    private static final int FLAG_JSON_STRING = 3;
    private static final int FLAG_KEEP_DUPLICATES = 4;

    public static void main(String[] args) throws IOException {
        int numRequiredOptions;
        String[] options = new String[]{"--log", "--dir", "--json", "--json-string", "--keep-duplicates"};
        Boolean[] optionValues = new Boolean[]{false, false, false, false, false};
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        for (int i = 0; i < options.length; ++i) {
            optionValues[i] = argsList.contains(options[i]);
        }
        for (String flag : options) {
            argsList.remove(flag);
        }
        int n = numRequiredOptions = optionValues[1] != false || optionValues[2] != false || optionValues[3] != false ? 1 : 2;
        if (argsList.size() != numRequiredOptions) {
            System.out.println("Usage:\n    IFC_Converter [--log] [--keep-duplicates] <input_file> <output_file>\n    IFC_Converter [--log] [--keep-duplicates] --dir <directory>\n    IFC_Converter --json|--json-string <configuration>\n");
            return;
        }
        if (optionValues[2].booleanValue() || optionValues[3].booleanValue()) {
            String jsonString;
            if (optionValues[2].booleanValue()) {
                try {
                    FileInputStream fis = new FileInputStream(args[1]);
                    jsonString = IfcSpfReader.slurp(fis);
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            } else {
                jsonString = args[1];
            }
            IfcSpfReader r = new IfcSpfReader();
            r.convert(jsonString);
        } else {
            List<String> outputFiles;
            List<String> inputFiles;
            if (optionValues[1].booleanValue()) {
                inputFiles = IfcSpfReader.showFiles((String)argsList.get(0));
                outputFiles = null;
            } else {
                inputFiles = Arrays.asList((String)argsList.get(0));
                outputFiles = Arrays.asList((String)argsList.get(1));
            }
            for (int i = 0; i < inputFiles.size(); ++i) {
                String inputFile = inputFiles.get(i);
                if (!inputFile.endsWith(".ifc")) continue;
                String outputFile = outputFiles == null ? inputFile.substring(0, inputFile.length() - 4) + ".ttl" : outputFiles.get(i);
                IfcSpfReader r = new IfcSpfReader();
                r.removeDuplicates = optionValues[4] == false;
                r.logToFile = optionValues[0];
                if (optionValues[0].booleanValue()) {
                    r.setupLogger(inputFile);
                }
                System.out.println("Converting file : " + inputFile + "\r\n");
                if (r.logToFile) {
                    r.bw.write("Converting file : " + inputFile + "\r\n");
                }
                r.convert(inputFile, outputFile, r.DEFAULT_PATH);
                if (!r.logToFile) continue;
                r.bw.flush();
                r.bw.close();
            }
        }
    }

    public static List<String> showFiles(String dir) {
        ArrayList<String> goodFiles = new ArrayList<String>();
        File folder = new File(dir);
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (listOfFiles[i].isFile()) {
                goodFiles.add(listOfFiles[i].getAbsolutePath());
                continue;
            }
            if (!listOfFiles[i].isDirectory()) continue;
            goodFiles.addAll(IfcSpfReader.showFiles(listOfFiles[i].getAbsolutePath()));
        }
        return goodFiles;
    }

    public void setupLogger(String path) {
        String outputFile = path.substring(0, path.length() - 4) + ".log";
        try {
            File file = new File(outputFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            this.bw = new BufferedWriter(fw);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void convert(String jsonConfig) throws IOException {
        Gson gson = new Gson();
        String ifcFile = (String)gson.fromJson("\"ifc_file\"", String.class);
        String outputFile = (String)gson.fromJson("\"output_file\"", String.class);
        this.convert(ifcFile, outputFile, this.DEFAULT_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getExpressSchema(String ifc_file) {
        try {
            FileInputStream fstream = new FileInputStream(ifc_file);
            DataInputStream in = new DataInputStream(fstream);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                String strLine;
                do {
                    if ((strLine = br.readLine()) == null) return "";
                } while (strLine.length() <= 0 || !strLine.startsWith("FILE_SCHEMA"));
                if (strLine.indexOf("IFC2X3") != -1) {
                    String string = "IFC2X3_TC1";
                    return string;
                }
                if (strLine.indexOf("IFC4") != -1) {
                    String string = "IFC4_ADD1";
                    return string;
                }
                String string = "";
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String slurp(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(String ifcFile, String outputFile, String baseURI) throws IOException {
        String exp;
        if (!ifcFile.endsWith(".ifc")) {
            ifcFile = ifcFile + ".ifc";
        }
        if (!((exp = IfcSpfReader.getExpressSchema(ifcFile)).equalsIgnoreCase("IFC2X3_Final") || exp.equalsIgnoreCase("IFC2X3_TC1") || exp.equalsIgnoreCase("IFC4_ADD2") || exp.equalsIgnoreCase("IFC4_ADD1") || exp.equalsIgnoreCase("IFC4"))) {
            if (this.logToFile) {
                this.bw.write("ERROR: Unrecognised EXPRESS schema: " + exp + ". File should be in IFC4 or IFC2X3 schema. Stopping conversion.\r\n");
            }
            return;
        }
        OntModel om = null;
        InputStream in = null;
        try {
            om = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_TRANS_INF);
            in = IfcSpfReader.class.getResourceAsStream("/" + exp + ".ttl");
            om.read(in, null, "TTL");
            String expressTtl = "/express.ttl";
            InputStream expressTtlStream = IfcSpfReader.class.getResourceAsStream(expressTtl);
            OntModel expressModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_TRANS_INF);
            expressModel.read(expressTtlStream, null, "TTL");
            String rdfList = "/list.ttl";
            InputStream rdfListStream = IfcSpfReader.class.getResourceAsStream(rdfList);
            OntModel listModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_TRANS_INF);
            listModel.read(rdfListStream, null, "TTL");
            om.add((Model)expressModel);
            om.add((Model)listModel);
            InputStream fis = IfcSpfReader.class.getResourceAsStream("/ent" + exp + ".ser");
            Map ent = null;
            try (ObjectInputStream ois = new ObjectInputStream(fis);){
                ent = (Map)ois.readObject();
            }
            fis = IfcSpfReader.class.getResourceAsStream("/typ" + exp + ".ser");
            ois = new ObjectInputStream(fis);
            Map typ = null;
            try {
                typ = (Map)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                ois.close();
            }
            String ontURI = "http://www.buildingsmart-tech.org/ifcOWL/" + exp;
            RDFWriter conv = new RDFWriter(om, expressModel, listModel, new FileInputStream(ifcFile), baseURI, ent, typ, ontURI);
            conv.setRemoveDuplicates(this.removeDuplicates);
            conv.setIfcReader(this);
            FileOutputStream out = new FileOutputStream(outputFile);
            String s = "# baseURI: " + baseURI;
            s = s + "\r\n# imports: " + ontURI + "\r\n\r\n";
            out.write(s.getBytes());
            out.flush();
            System.out.println("started parsing stream");
            conv.parseModel2Stream(out);
            System.out.println("finished!!");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

