/*
 * Decompiled with CFR 0.152.
 */
package be.ugent;

import be.ugent.IfcSpfReader;
import com.buildingsmart.tech.ifcowl.ExpressReader;
import com.buildingsmart.tech.ifcowl.vo.AttributeVO;
import com.buildingsmart.tech.ifcowl.vo.EntityVO;
import com.buildingsmart.tech.ifcowl.vo.IFCVO;
import com.buildingsmart.tech.ifcowl.vo.TypeVO;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class RDFWriter {
    private final String baseURI;
    private final String ontNS;
    private static final String expressURI = "https://w3id.org/express";
    private static final String expressNS = "https://w3id.org/express#";
    private static final String listURI = "https://w3id.org/list";
    private static final String listNS = "https://w3id.org/list#";
    private final Map<String, EntityVO> ent;
    private final Map<String, TypeVO> typ;
    private int IDcounter = 0;
    private Map<Long, IFCVO> linemap = new HashMap<Long, IFCVO>();
    private StreamRDF ttlWriter;
    private InputStream inputStream;
    private final OntModel ontModel;
    private final OntModel expressModel;
    private final OntModel listModel;
    private IfcSpfReader myIfcReaderStream;
    private Map<String, Resource> listOfUniqueResources = new HashMap<String, Resource>();
    private Map<Long, Long> listOfDuplicateLineEntries = new HashMap<Long, Long>();
    private Map<String, Resource> propertyResourceMap = new HashMap<String, Resource>();
    private Map<String, Resource> resourceMap = new HashMap<String, Resource>();
    private boolean removeDuplicates = true;
    TypeVO typeRemembrance = null;

    public RDFWriter(OntModel ontModel, OntModel expressModel, OntModel listModel, InputStream inputStream, String baseURI, Map<String, EntityVO> ent, Map<String, TypeVO> typ, String ontURI) {
        this.ontModel = ontModel;
        this.expressModel = expressModel;
        this.listModel = listModel;
        this.inputStream = inputStream;
        this.baseURI = baseURI;
        this.ent = ent;
        this.typ = typ;
        this.ontNS = ontURI + "#";
    }

    public void setIfcReader(IfcSpfReader r) {
        this.myIfcReaderStream = r;
    }

    public void parseModel2Stream(OutputStream out) throws IOException {
        boolean parsedSuccessfully;
        this.ttlWriter = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)RDFFormat.TURTLE_BLOCKS);
        this.ttlWriter.base(this.baseURI);
        this.ttlWriter.prefix("ifcowl", this.ontNS);
        this.ttlWriter.prefix("inst", this.baseURI);
        this.ttlWriter.prefix("list", listNS);
        this.ttlWriter.prefix("express", expressNS);
        this.ttlWriter.prefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.ttlWriter.prefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.ttlWriter.prefix("owl", "http://www.w3.org/2002/07/owl#");
        this.ttlWriter.start();
        this.ttlWriter.triple(new Triple(NodeFactory.createURI((String)this.baseURI), RDF.type.asNode(), OWL.Ontology.asNode()));
        this.ttlWriter.triple(new Triple(NodeFactory.createURI((String)this.baseURI), OWL.imports.asNode(), NodeFactory.createURI((String)this.ontNS)));
        this.readModel();
        System.out.println("model parsed");
        if (this.removeDuplicates) {
            this.resolveDuplicates();
        }
        if (!(parsedSuccessfully = this.mapEntries())) {
            return;
        }
        System.out.println("entries mapped, now creating instances");
        this.createInstances();
        this.linemap.clear();
        this.linemap = null;
        this.ttlWriter.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readModel() {
        try {
            DataInputStream in = new DataInputStream(this.inputStream);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                String strLine;
                while ((strLine = br.readLine()) != null) {
                    if (strLine.length() <= 0 || strLine.charAt(0) != '#') continue;
                    StringBuffer sb = new StringBuffer();
                    String stmp = strLine;
                    sb.append(stmp.trim());
                    while (!stmp.contains(";") && (stmp = br.readLine()) != null) {
                        sb.append(stmp.trim());
                    }
                    this.parseIfcLineStatement(sb.toString().substring(1));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseIfcLineStatement(String line) {
        IFCVO ifcvo = new IFCVO();
        ifcvo.setFullLineAfterNum(line.substring(line.indexOf("=") + 1));
        int state = 0;
        StringBuffer sb = new StringBuffer();
        int clCount = 0;
        LinkedList<Object> current = (LinkedList<Object>)ifcvo.getObjectList();
        Stack<LinkedList<Object>> listStack = new Stack<LinkedList<Object>>();
        block6: for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '=') {
                        ifcvo.setLineNum(this.toLong(sb.toString()));
                        sb.setLength(0);
                        ++state;
                        continue block6;
                    }
                    if (!Character.isDigit(ch)) continue block6;
                    sb.append(ch);
                    continue block6;
                }
                case 1: {
                    if (ch == '(') {
                        ifcvo.setName(sb.toString());
                        sb.setLength(0);
                        ++state;
                        continue block6;
                    }
                    if (ch == ';') {
                        ifcvo.setName(sb.toString());
                        sb.setLength(0);
                        state = Integer.MAX_VALUE;
                        continue block6;
                    }
                    if (Character.isWhitespace(ch)) continue block6;
                    sb.append(ch);
                    continue block6;
                }
                case 2: {
                    if (ch == '\'') {
                        ++state;
                    }
                    if (ch == '(') {
                        listStack.push(current);
                        LinkedList<Object> tmp = new LinkedList<Object>();
                        if (sb.toString().trim().length() > 0) {
                            current.add(sb.toString().trim());
                        }
                        sb.setLength(0);
                        current.add(tmp);
                        current = tmp;
                        ++clCount;
                        continue block6;
                    }
                    if (ch == ')') {
                        if (clCount == 0) {
                            if (sb.toString().trim().length() > 0) {
                                current.add(sb.toString().trim());
                            }
                            sb.setLength(0);
                            state = Integer.MAX_VALUE;
                            continue block6;
                        }
                        if (sb.toString().trim().length() > 0) {
                            current.add(sb.toString().trim());
                        }
                        sb.setLength(0);
                        --clCount;
                        current = (LinkedList)listStack.pop();
                        continue block6;
                    }
                    if (ch == ',') {
                        if (sb.toString().trim().length() > 0) {
                            current.add(sb.toString().trim());
                        }
                        current.add(Character.valueOf(ch));
                        sb.setLength(0);
                        continue block6;
                    }
                    sb.append(ch);
                    continue block6;
                }
                case 3: {
                    if (ch == '\'') {
                        --state;
                        continue block6;
                    }
                    sb.append(ch);
                    continue block6;
                }
            }
        }
        this.linemap.put(ifcvo.getLineNum(), ifcvo);
        ++this.IDcounter;
    }

    private void resolveDuplicates() throws IOException {
        HashMap<String, IFCVO> listOfUniqueResources = new HashMap<String, IFCVO>();
        ArrayList<Long> entriesToRemove = new ArrayList<Long>();
        for (Map.Entry<Long, IFCVO> entry : this.linemap.entrySet()) {
            IFCVO vo = entry.getValue();
            String t = vo.getFullLineAfterNum();
            if (!listOfUniqueResources.containsKey(t)) {
                listOfUniqueResources.put(t, vo);
                continue;
            }
            entriesToRemove.add(entry.getKey());
            this.listOfDuplicateLineEntries.put(vo.getLineNum(), ((IFCVO)listOfUniqueResources.get(t)).getLineNum());
        }
        if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.write("MESSAGE: found and removed " + this.listOfDuplicateLineEntries.size() + " duplicates! \r\n");
        }
        for (Long x : entriesToRemove) {
            this.linemap.remove(x);
        }
    }

    private boolean mapEntries() throws IOException {
        for (Map.Entry<Long, IFCVO> entry : this.linemap.entrySet()) {
            IFCVO vo = entry.getValue();
            for (int i = 0; i < vo.getObjectList().size(); ++i) {
                Object o = vo.getObjectList().get(i);
                if (Character.class.isInstance(o)) {
                    if (((Character)o).charValue() == ',' || !this.myIfcReaderStream.logToFile) continue;
                    this.myIfcReaderStream.bw.write("*ERROR 15*: We found a character that is not a comma. That should not be possible\r\n");
                    continue;
                }
                if (String.class.isInstance(o)) {
                    String s = (String)o;
                    if (s.length() < 1 || s.charAt(0) != '#') continue;
                    IFCVO or = null;
                    or = this.listOfDuplicateLineEntries.containsKey(this.toLong(s.substring(1))) ? this.linemap.get(this.listOfDuplicateLineEntries.get(this.toLong(s.substring(1)))) : this.linemap.get(this.toLong(s.substring(1)));
                    if (or == null) {
                        if (this.myIfcReaderStream.logToFile) {
                            this.myIfcReaderStream.bw.write("*ERROR 6*: Reference to non-existing line number in line: #" + vo.getLineNum() + "=" + vo.getFullLineAfterNum() + "\r\nQuitting the application without output!\r\n ");
                        }
                        System.err.println("*ERROR 6*: Reference to non-existing line number in line: #" + vo.getLineNum() + " - " + vo.getFullLineAfterNum() + "\r\nQuitting the application without output!");
                        return false;
                    }
                    vo.getObjectList().set(i, or);
                    continue;
                }
                if (!LinkedList.class.isInstance(o)) continue;
                LinkedList tmpList = (LinkedList)o;
                for (int j = 0; j < tmpList.size(); ++j) {
                    Object o1 = tmpList.get(j);
                    if (Character.class.isInstance(o)) {
                        if (((Character)o).charValue() == ',' || !this.myIfcReaderStream.logToFile) continue;
                        this.myIfcReaderStream.bw.write("*ERROR 16*: We found a character that is not a comma. That should not be possible!\r\n");
                        continue;
                    }
                    if (String.class.isInstance(o1)) {
                        String s = (String)o1;
                        if (s.length() < 1) continue;
                        if (s.charAt(0) == '#') {
                            IFCVO or = null;
                            or = this.listOfDuplicateLineEntries.containsKey(this.toLong(s.substring(1))) ? this.linemap.get(this.listOfDuplicateLineEntries.get(this.toLong(s.substring(1)))) : this.linemap.get(this.toLong(s.substring(1)));
                            if (or == null) {
                                if (this.myIfcReaderStream.logToFile) {
                                    this.myIfcReaderStream.bw.write("*ERROR 7*: Reference to non-existing line number in line: #" + vo.getLineNum() + "=" + vo.getFullLineAfterNum() + "\r\nQuitting the application without output!\r\n ");
                                }
                                System.err.println("*ERROR 7*: Reference to non-existing line number in line: #" + vo.getLineNum() + " - " + vo.getFullLineAfterNum() + "\r\nQuitting the application without output!");
                                tmpList.set(j, "-");
                                return false;
                            }
                            tmpList.set(j, or);
                            continue;
                        }
                        tmpList.set(j, s);
                        continue;
                    }
                    if (!LinkedList.class.isInstance(o1)) continue;
                    LinkedList tmp2List = (LinkedList)o1;
                    for (int j2 = 0; j2 < tmp2List.size(); ++j2) {
                        String s;
                        Object o2 = tmp2List.get(j2);
                        if (!String.class.isInstance(o2) || (s = (String)o2).length() < 1 || s.charAt(0) != '#') continue;
                        IFCVO or = null;
                        or = this.listOfDuplicateLineEntries.containsKey(this.toLong(s.substring(1))) ? this.linemap.get(this.listOfDuplicateLineEntries.get(this.toLong(s.substring(1)))) : this.linemap.get(this.toLong(s.substring(1)));
                        if (or == null) {
                            if (this.myIfcReaderStream.logToFile) {
                                this.myIfcReaderStream.bw.write("*ERROR 8*: Reference to non-existing line number in line: #" + vo.getLineNum() + "=" + vo.getFullLineAfterNum() + "\r\nQuitting the application without output!\r\n ");
                            }
                            System.err.println("*ERROR 8*: Reference to non-existing line number in line: #" + vo.getLineNum() + " - " + vo.getFullLineAfterNum() + "\r\nQuitting the application without output!");
                            tmp2List.set(j2, "-");
                            return false;
                        }
                        tmp2List.set(j2, or);
                    }
                    tmpList.set(j, tmp2List);
                }
            }
        }
        return true;
    }

    private void createInstances() throws IOException {
        for (Map.Entry<Long, IFCVO> entry : this.linemap.entrySet()) {
            IFCVO ifcLineEntry = entry.getValue();
            String typeName = "";
            if (this.ent.containsKey(ifcLineEntry.getName())) {
                typeName = this.ent.get(ifcLineEntry.getName()).getName();
            } else if (this.typ.containsKey(ifcLineEntry.getName())) {
                typeName = this.typ.get(ifcLineEntry.getName()).getName();
            }
            OntClass cl = this.ontModel.getOntClass(this.ontNS + typeName);
            Resource r = this.getResource(this.baseURI + typeName + "_" + ifcLineEntry.getLineNum(), (OntResource)cl);
            if (r == null) {
                return;
            }
            this.listOfUniqueResources.put(ifcLineEntry.getFullLineAfterNum(), r);
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("-------------------------------\r\n");
            }
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write(r.getLocalName() + "\r\n");
            }
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("-------------------------------\r\n");
            }
            this.fillProperties(ifcLineEntry, r, cl);
        }
        this.propertyResourceMap.clear();
    }

    private void fillProperties(IFCVO ifcLineEntry, Resource r, OntClass cl) throws IOException {
        EntityVO evo = this.ent.get(ExpressReader.formatClassName((String)ifcLineEntry.getName()));
        TypeVO tvo = this.typ.get(ExpressReader.formatClassName((String)ifcLineEntry.getName()));
        if (tvo == null && evo == null) {
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*ERROR 3*: fillProperties 1 - Type nor entity exists: " + ifcLineEntry.getName() + "\r\n");
            }
            System.err.println("ERROR 3*: fillProperties 1 - Type nor entity exists: " + ifcLineEntry.getName());
        }
        if (evo == null && tvo != null) {
            this.typeRemembrance = null;
            for (Object o : ifcLineEntry.getObjectList()) {
                if (Character.class.isInstance(o)) {
                    if (((Character)o).charValue() != ',' && this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*ERROR 17*: We found a character that is not a comma. That should not be possible!\r\n");
                    }
                } else if (String.class.isInstance(o)) {
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*WARNING 1*: fillProperties 2 - WARNING: unhandled type property found.\r\n");
                    }
                    System.out.println("*WARNING 1*: unhandled type property found.");
                } else if (IFCVO.class.isInstance(o)) {
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*WARNING 2*: fillProperties 2 - WARNING: unhandled type property found.\r\n");
                    }
                    System.out.println("*WARNING 2*: unhandled type property found.");
                } else if (LinkedList.class.isInstance(o)) {
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("fillProperties 3 - fillPropertiesHandleListObject(tvo)\r\n");
                    }
                    this.fillPropertiesHandleListObject(r, tvo, o);
                }
                if (!this.myIfcReaderStream.logToFile) continue;
                this.myIfcReaderStream.bw.flush();
            }
        }
        if (tvo == null && evo != null) {
            String subject = evo.getName() + "_" + ifcLineEntry.getLineNum();
            this.typeRemembrance = null;
            int attributePointer = 0;
            for (Object o : ifcLineEntry.getObjectList()) {
                if (Character.class.isInstance(o)) {
                    if (((Character)o).charValue() != ',' && this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*ERROR 18*: We found a character that is not a comma. That should not be possible!\r\n");
                    }
                } else if (String.class.isInstance(o)) {
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("fillProperties 4 - fillPropertiesHandleStringObject(evo)\r\n");
                    }
                    attributePointer = this.fillPropertiesHandleStringObject(r, evo, subject, attributePointer, o);
                } else if (IFCVO.class.isInstance(o)) {
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("fillProperties 5 - fillPropertiesHandleIfcObject(evo)\r\n");
                    }
                    attributePointer = this.fillPropertiesHandleIfcObject(r, evo, attributePointer, o);
                } else if (LinkedList.class.isInstance(o)) {
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("fillProperties 6 - fillPropertiesHandleListObject(evo)\r\n");
                    }
                    attributePointer = this.fillPropertiesHandleListObject(r, evo, attributePointer, o);
                }
                if (!this.myIfcReaderStream.logToFile) continue;
                this.myIfcReaderStream.bw.flush();
            }
        }
        if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.flush();
        }
    }

    private int fillPropertiesHandleStringObject(Resource r, EntityVO evo, String subject, int attributePointer, Object o) throws IOException {
        if (!((String)o).equals("$") && !((String)o).equals("*")) {
            if (this.typ.get(ExpressReader.formatClassName((String)((String)o))) == null) {
                if (evo != null && evo.getDerivedAttributeList() != null) {
                    if (evo.getDerivedAttributeList().size() <= attributePointer) {
                        if (this.myIfcReaderStream.logToFile) {
                            this.myIfcReaderStream.bw.write("*ERROR 4*: Entity in IFC files has more attributes than it is allowed have: " + subject + "\r\n");
                        }
                        System.err.println("*ERROR 4*: Entity in IFC files has more attributes than it is allowed have: " + subject);
                        return ++attributePointer;
                    }
                    String propURI = this.ontNS + ((AttributeVO)evo.getDerivedAttributeList().get(attributePointer)).getLowerCaseName();
                    String literalString = this.filterExtras((String)o);
                    OntProperty p = this.ontModel.getOntProperty(propURI);
                    OntResource range = p.getRange();
                    if (range.isClass()) {
                        if (range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#ENUMERATION"))) {
                            this.addEnumProperty(r, (Property)p, range, literalString);
                        } else if (range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#SELECT"))) {
                            if (this.myIfcReaderStream.logToFile) {
                                this.myIfcReaderStream.bw.write("*OK 25*: found subClass of SELECT Class, now doing nothing with it: " + p + " - " + range.getLocalName() + " - " + literalString + "\r\n");
                            }
                            this.createLiteralProperty(r, (OntResource)p, range, literalString);
                        } else if (range.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                            if (this.myIfcReaderStream.logToFile) {
                                this.myIfcReaderStream.bw.write("*WARNING 5*: found LIST property (but doing nothing with it): " + subject + " -- " + p + " - " + range.getLocalName() + " - " + literalString + "\r\n");
                            }
                        } else {
                            this.createLiteralProperty(r, (OntResource)p, range, literalString);
                        }
                    } else if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*WARNING 7*: found other kind of property: " + p + " - " + range.getLocalName() + "\r\n");
                    }
                } else if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*WARNING 8*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                }
                ++attributePointer;
            } else {
                this.typeRemembrance = this.typ.get(ExpressReader.formatClassName((String)((String)o)));
            }
        } else {
            ++attributePointer;
        }
        return attributePointer;
    }

    private int fillPropertiesHandleIfcObject(Resource r, EntityVO evo, int attributePointer, Object o) throws IOException {
        if (evo != null && evo.getDerivedAttributeList() != null && evo.getDerivedAttributeList().size() > attributePointer) {
            String propURI = this.ontNS + ((AttributeVO)evo.getDerivedAttributeList().get(attributePointer)).getLowerCaseName();
            EntityVO evorange = this.ent.get(ExpressReader.formatClassName((String)((IFCVO)o).getName()));
            OntProperty p = this.ontModel.getOntProperty(propURI);
            OntResource rclass = this.ontModel.getOntResource(this.ontNS + evorange.getName());
            Resource r1 = this.getResource(this.baseURI + evorange.getName() + "_" + ((IFCVO)o).getLineNum(), rclass);
            this.ttlWriter.triple(new Triple(r.asNode(), p.asNode(), r1.asNode()));
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*OK 1*: added property: " + r.getLocalName() + " - " + p.getLocalName() + " - " + r1.getLocalName() + "\r\n");
            }
        } else if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.write("*WARNING 3*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
        }
        return ++attributePointer;
    }

    private int fillPropertiesHandleListObject(Resource r, EntityVO evo, int attributePointer, Object o) throws IOException {
        OntProperty p;
        LinkedList tmpList = (LinkedList)o;
        LinkedList<String> literals = new LinkedList<String>();
        LinkedList<Resource> listRemembranceResources = new LinkedList<Resource>();
        LinkedList<IFCVO> IFCVOs = new LinkedList<IFCVO>();
        for (int j = 0; j < tmpList.size(); ++j) {
            Resource r1;
            Object o1 = tmpList.get(j);
            if (Character.class.isInstance(o1)) {
                Character c = (Character)o1;
                if (c.charValue() == ',' || !this.myIfcReaderStream.logToFile) continue;
                this.myIfcReaderStream.bw.write("*ERROR 12*: We found a character that is not a comma. That is odd. Check!\r\n");
                continue;
            }
            if (String.class.isInstance(o1)) {
                TypeVO t = this.typ.get(ExpressReader.formatClassName((String)((String)o1)));
                if (this.typeRemembrance == null) {
                    if (t != null) {
                        this.typeRemembrance = t;
                        continue;
                    }
                    literals.add(this.filterExtras((String)o1));
                    continue;
                }
                if (t != null) {
                    if (t == this.typeRemembrance || !this.myIfcReaderStream.logToFile) continue;
                    this.myIfcReaderStream.bw.write("*WARNING 37*: Found two different types in one list. This is worth checking.\r\n ");
                    continue;
                }
                literals.add(this.filterExtras((String)o1));
                continue;
            }
            if (IFCVO.class.isInstance(o1)) {
                if (evo != null && evo.getDerivedAttributeList() != null && evo.getDerivedAttributeList().size() > attributePointer) {
                    String propURI = ((AttributeVO)evo.getDerivedAttributeList().get(attributePointer)).getLowerCaseName();
                    OntProperty p2 = this.ontModel.getOntProperty(this.ontNS + propURI);
                    OntResource typerange = p2.getRange();
                    if (typerange.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                        String listvaluepropURI = this.ontNS + typerange.getLocalName().substring(0, typerange.getLocalName().length() - 5);
                        OntResource listrange = this.ontModel.getOntResource(listvaluepropURI);
                        if (listrange.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                            if (!this.myIfcReaderStream.logToFile) continue;
                            this.myIfcReaderStream.bw.write("*ERROR 22*: Found supposedly unhandled ListOfList, but this should not be possible.\r\n");
                            continue;
                        }
                        this.fillClassInstanceList(tmpList, typerange, p2, r);
                        j = tmpList.size() - 1;
                        continue;
                    }
                    EntityVO evorange = this.ent.get(ExpressReader.formatClassName((String)((IFCVO)o1).getName()));
                    OntResource rclass = this.ontModel.getOntResource(this.ontNS + evorange.getName());
                    r1 = this.getResource(this.baseURI + evorange.getName() + "_" + ((IFCVO)o1).getLineNum(), rclass);
                    this.ttlWriter.triple(new Triple(r.asNode(), p2.asNode(), r1.asNode()));
                    if (!this.myIfcReaderStream.logToFile) continue;
                    this.myIfcReaderStream.bw.write("*OK 5*: added property: " + r.getLocalName() + " - " + p2.getLocalName() + " - " + r1.getLocalName() + "\r\n");
                    continue;
                }
                if (!this.myIfcReaderStream.logToFile) continue;
                this.myIfcReaderStream.bw.write("*WARNING 13*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                continue;
            }
            if (LinkedList.class.isInstance(o1)) {
                Object o2;
                LinkedList tmpListInList;
                if (this.typeRemembrance != null) {
                    tmpListInList = (LinkedList)o1;
                    for (int jj = 0; jj < tmpListInList.size(); ++jj) {
                        o2 = tmpListInList.get(jj);
                        if (Character.class.isInstance(o2)) {
                            if (((Character)o2).charValue() == ',' || !this.myIfcReaderStream.logToFile) continue;
                            this.myIfcReaderStream.bw.write("*ERROR 20*: We found a character that is not a comma. That should not be possible\r\n");
                            continue;
                        }
                        if (String.class.isInstance(o2)) {
                            literals.add(this.filterExtras((String)o2));
                            continue;
                        }
                        if (IFCVO.class.isInstance(o2)) {
                            if (this.myIfcReaderStream.logToFile) {
                                this.myIfcReaderStream.bw.write("*WARNING 30*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                            }
                            System.out.println("*WARNING 30: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                            continue;
                        }
                        if (LinkedList.class.isInstance(o2)) {
                            LinkedList tmpListInListInList = (LinkedList)o2;
                            for (int jjj = 0; jjj < tmpListInListInList.size(); ++jjj) {
                                Object o3 = tmpListInListInList.get(jjj);
                                if (Character.class.isInstance(o3)) {
                                    if (((Character)o3).charValue() == ',' || !this.myIfcReaderStream.logToFile) continue;
                                    this.myIfcReaderStream.bw.write("*ERROR 24*: We found a character that is not a comma. That should not be possible\r\n");
                                    continue;
                                }
                                if (String.class.isInstance(o3)) {
                                    literals.add(this.filterExtras((String)o3));
                                    continue;
                                }
                                if (this.myIfcReaderStream.logToFile) {
                                    this.myIfcReaderStream.bw.write("*WARNING 31*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                                }
                                System.out.println("*WARNING 31: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                            }
                            if (evo != null && evo.getDerivedAttributeList() != null && evo.getDerivedAttributeList().size() > attributePointer) {
                                OntClass cl = this.ontModel.getOntClass(this.ontNS + this.typeRemembrance.getName());
                                r1 = this.getResource(this.baseURI + this.typeRemembrance.getName() + "_" + this.IDcounter, (OntResource)cl);
                                ++this.IDcounter;
                                OntResource range = this.ontModel.getOntResource(this.ontNS + this.typeRemembrance.getName());
                                String[] primTypeArr = this.typeRemembrance.getPrimarytype().split(" ");
                                String primType = this.ontNS + primTypeArr[primTypeArr.length - 1].replace(";", "");
                                OntResource listrange = this.ontModel.getOntResource(primType);
                                ArrayList<Object> literalObjects = new ArrayList<Object>();
                                literalObjects.addAll(literals);
                                this.addDirectRegularListProperty(r1, range, listrange, literalObjects, 0);
                                listRemembranceResources.add(r1);
                            }
                            this.typeRemembrance = null;
                            literals.clear();
                            continue;
                        }
                        if (this.myIfcReaderStream.logToFile) {
                            this.myIfcReaderStream.bw.write("*WARNING 35*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                        }
                        System.out.println("*WARNING 35: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                    }
                    continue;
                }
                tmpListInList = (LinkedList)o1;
                for (int jj = 0; jj < tmpListInList.size(); ++jj) {
                    o2 = tmpListInList.get(jj);
                    if (Character.class.isInstance(o2)) {
                        if (((Character)o2).charValue() == ',' || !this.myIfcReaderStream.logToFile) continue;
                        this.myIfcReaderStream.bw.write("*ERROR 21*: We found a character that is not a comma. That should not be possible\r\n");
                        continue;
                    }
                    if (String.class.isInstance(o2)) {
                        literals.add(this.filterExtras((String)o2));
                        continue;
                    }
                    if (IFCVO.class.isInstance(o2)) {
                        IFCVOs.add((IFCVO)o2);
                        continue;
                    }
                    if (LinkedList.class.isInstance(o2)) {
                        if (this.myIfcReaderStream.logToFile) {
                            this.myIfcReaderStream.bw.write("*ERROR 19*: Found List of List of List. Code cannot handle that.\r\n");
                        }
                        System.err.println("*ERROR 19*: Found List of List of List. Code cannot handle that.");
                        continue;
                    }
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*WARNING 32*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                    }
                    System.out.println("*WARNING 32: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                }
                if (evo != null && evo.getDerivedAttributeList() != null && evo.getDerivedAttributeList().size() > attributePointer) {
                    String propURI = this.ontNS + ((AttributeVO)evo.getDerivedAttributeList().get(attributePointer)).getLowerCaseName();
                    OntProperty p3 = this.ontModel.getOntProperty(propURI);
                    OntClass typerange = p3.getRange().asClass();
                    if (typerange.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                        OntResource listcontentrange;
                        String listvaluepropURI = typerange.getLocalName().substring(0, typerange.getLocalName().length() - 5);
                        OntResource listrange = this.ontModel.getOntResource(this.ontNS + listvaluepropURI);
                        Resource r12 = this.getResource(this.baseURI + listvaluepropURI + "_" + this.IDcounter, listrange);
                        ++this.IDcounter;
                        ArrayList<Object> objects = new ArrayList<Object>();
                        if (IFCVOs.size() > 0) {
                            objects.addAll(IFCVOs);
                            listcontentrange = this.getListContentType(listrange.asClass());
                            this.addDirectRegularListProperty(r12, listrange, listcontentrange, objects, 1);
                        } else if (literals.size() > 0) {
                            objects.addAll(literals);
                            listcontentrange = this.getListContentType(listrange.asClass());
                            this.addDirectRegularListProperty(r12, listrange, listcontentrange, objects, 0);
                        }
                        listRemembranceResources.add(r12);
                    } else {
                        if (this.myIfcReaderStream.logToFile) {
                            this.myIfcReaderStream.bw.write("*ERROR 23*: Impossible: found a list that is actually not a list.\r\n");
                        }
                        System.err.println("*ERROR 23: Impossible: found a list that is actually not a list.\r\n");
                    }
                }
                literals.clear();
                IFCVOs.clear();
                continue;
            }
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*ERROR 11*: We found something that is not an IFC entity, not a list, not a string, and not a character. Check!\r\n");
            }
            System.out.println("*ERROR 11*: We found something that is not an IFC entity, not a list, not a string, and not a character. Check!");
        }
        if (literals.size() > 0) {
            String propURI = this.ontNS + ((AttributeVO)evo.getDerivedAttributeList().get(attributePointer)).getLowerCaseName();
            p = this.ontModel.getOntProperty(propURI);
            OntResource typerange = p.getRange();
            if (this.typeRemembrance != null) {
                if (evo != null && evo.getDerivedAttributeList() != null && evo.getDerivedAttributeList().size() > attributePointer) {
                    if (typerange.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                        this.addRegularListProperty(r, p, literals, this.typeRemembrance);
                    } else {
                        this.addSinglePropertyFromTypeRemembrance(r, p, (String)literals.getFirst(), this.typeRemembrance);
                        if (literals.size() > 1 && this.myIfcReaderStream.logToFile) {
                            this.myIfcReaderStream.bw.write("*WARNING 37*: We are ignoring a number of literal values here.\r\n");
                        }
                    }
                } else if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*WARNING 15*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                }
                this.typeRemembrance = null;
            } else if (evo != null && evo.getDerivedAttributeList() != null && evo.getDerivedAttributeList().size() > attributePointer) {
                if (typerange.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                    this.addRegularListProperty(r, p, literals, null);
                } else {
                    for (int i = 0; i < literals.size(); ++i) {
                        this.createLiteralProperty(r, (OntResource)p, typerange, literals.get(i));
                    }
                }
            } else if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*WARNING 14*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
            }
        }
        if (listRemembranceResources.size() > 0 && evo != null && evo.getDerivedAttributeList() != null && evo.getDerivedAttributeList().size() > attributePointer) {
            String propURI = this.ontNS + ((AttributeVO)evo.getDerivedAttributeList().get(attributePointer)).getLowerCaseName();
            p = this.ontModel.getOntProperty(propURI);
            this.addListPropertyToGivenEntities(r, p, listRemembranceResources);
        }
        return ++attributePointer;
    }

    private void fillPropertiesHandleListObject(Resource r, TypeVO tvo, Object o) throws IOException {
        LinkedList tmpList = (LinkedList)o;
        LinkedList<String> literals = new LinkedList<String>();
        for (int j = 0; j < tmpList.size(); ++j) {
            Object o1 = tmpList.get(j);
            if (Character.class.isInstance(o1)) {
                Character c = (Character)o1;
                if (c.charValue() == ',' || !this.myIfcReaderStream.logToFile) continue;
                this.myIfcReaderStream.bw.write("*ERROR 13*: We found a character that is not a comma. That is odd. Check!\r\n");
                continue;
            }
            if (String.class.isInstance(o1)) {
                if (this.typ.get(ExpressReader.formatClassName((String)((String)o1))) != null && this.typeRemembrance == null) {
                    this.typeRemembrance = this.typ.get(ExpressReader.formatClassName((String)((String)o1)));
                    continue;
                }
                literals.add(this.filterExtras((String)o1));
                continue;
            }
            if (IFCVO.class.isInstance(o1)) {
                if (tvo != null) {
                    if (!this.myIfcReaderStream.logToFile) continue;
                    this.myIfcReaderStream.bw.write("*WARNING 16*: found TYPE that is equivalent to a list if IFC entities - below is the code used when this happens for ENTITIES with a list of ENTITIES\r\n");
                    continue;
                }
                if (!this.myIfcReaderStream.logToFile) continue;
                this.myIfcReaderStream.bw.write("*WARNING 19*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                continue;
            }
            if (LinkedList.class.isInstance(o1) && this.typeRemembrance != null) {
                LinkedList tmpListInlist = (LinkedList)o1;
                for (int jj = 0; jj < tmpListInlist.size(); ++jj) {
                    Object o2 = tmpListInlist.get(jj);
                    if (String.class.isInstance(o2)) {
                        literals.add(this.filterExtras((String)o2));
                        continue;
                    }
                    if (!this.myIfcReaderStream.logToFile) continue;
                    this.myIfcReaderStream.bw.write("*WARNING 18*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                }
                continue;
            }
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*ERROR 10*: We found something that is not an IFC entity, not a list, not a string, and not a character. Check!\r\n");
            }
            System.out.println("*ERROR 10*: We found something that is not an IFC entity, not a list, not a string, and not a character. Check!");
        }
        if (literals.size() > 0) {
            String typeURI;
            String primType;
            if (this.typeRemembrance != null) {
                if (tvo != null) {
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*WARNING 20*: this part of the code has not been checked - it can't be correct\r\n");
                    }
                    String[] primtypeArr = tvo.getPrimarytype().split(" ");
                    primType = primtypeArr[primtypeArr.length - 1].replace(";", "") + "_" + primtypeArr[0].substring(0, 1).toUpperCase() + primtypeArr[0].substring(1).toLowerCase();
                    typeURI = this.ontNS + primType;
                    OntResource range = this.ontModel.getOntResource(typeURI);
                    OntResource listrange = this.getListContentType(range.asClass());
                    ArrayList<Object> literalObjects = new ArrayList<Object>();
                    literalObjects.addAll(literals);
                    this.addDirectRegularListProperty(r, range, listrange, literalObjects, 0);
                } else if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*WARNING 21*: Nothing happened. Not sure if this is good or bad, possible or not.\r\n");
                }
                this.typeRemembrance = null;
            } else if (tvo != null) {
                String[] primTypeArr = tvo.getPrimarytype().split(" ");
                primType = primTypeArr[primTypeArr.length - 1].replace(";", "") + "_" + primTypeArr[0].substring(0, 1).toUpperCase() + primTypeArr[0].substring(1).toLowerCase();
                typeURI = this.ontNS + primType;
                OntResource range = this.ontModel.getOntResource(typeURI);
                ArrayList<Object> literalObjects = new ArrayList<Object>();
                literalObjects.addAll(literals);
                OntResource listrange = this.getListContentType(range.asClass());
                this.addDirectRegularListProperty(r, range, listrange, literalObjects, 0);
            }
        }
    }

    private void addSinglePropertyFromTypeRemembrance(Resource r, OntProperty p, String literalString, TypeVO typeremembrance) throws IOException {
        OntResource range = this.ontModel.getOntResource(this.ontNS + typeremembrance.getName());
        if (range.isClass()) {
            if (range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#ENUMERATION"))) {
                this.addEnumProperty(r, (Property)p, range, literalString);
            } else if (range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#SELECT"))) {
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*OK 24*: found subClass of SELECT Class, now doing nothing with it: " + p + " - " + range.getLocalName() + " - " + literalString + "\r\n");
                }
                this.createLiteralProperty(r, (OntResource)p, range, literalString);
            } else if (range.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*WARNING 24*: found LIST property (but doing nothing with it): " + p + " - " + range.getLocalName() + " - " + literalString + "\r\n");
                }
            } else {
                this.createLiteralProperty(r, (OntResource)p, range, literalString);
            }
        } else if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.write("*WARNING 26*: found other kind of property: " + p + " - " + range.getLocalName() + "\r\n");
        }
    }

    private void addEnumProperty(Resource r, Property p, OntResource range, String literalString) throws IOException {
        ExtendedIterator instances = range.asClass().listInstances();
        while (instances.hasNext()) {
            OntResource rangeInstance = (OntResource)instances.next();
            if (!rangeInstance.getProperty(RDFS.label).getString().equalsIgnoreCase(this.filterPoints(literalString))) continue;
            this.ttlWriter.triple(new Triple(r.asNode(), p.asNode(), rangeInstance.asNode()));
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*OK 2*: added ENUM statement " + r.getLocalName() + " - " + p.getLocalName() + " - " + rangeInstance.getLocalName() + "\r\n");
            }
            return;
        }
        if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.write("*ERROR 9*: did not find ENUM individual for " + literalString + "\r\nQuitting the application without output!\r\n ");
        }
        System.err.println("*ERROR 9*: did not find ENUM individual for " + literalString + "\r\nQuitting the application without output!");
    }

    private void addLiteralToResource(Resource r1, OntProperty valueProp, String xsdType, String literalString) throws IOException {
        if (xsdType.equalsIgnoreCase("integer")) {
            this.addLiteral(r1, valueProp, ResourceFactory.createTypedLiteral((String)literalString, (RDFDatatype)XSDDatatype.XSDinteger));
        } else if (xsdType.equalsIgnoreCase("double")) {
            this.addLiteral(r1, valueProp, ResourceFactory.createTypedLiteral((String)literalString, (RDFDatatype)XSDDatatype.XSDdouble));
        } else if (xsdType.equalsIgnoreCase("hexBinary")) {
            this.addLiteral(r1, valueProp, ResourceFactory.createTypedLiteral((String)literalString, (RDFDatatype)XSDDatatype.XSDhexBinary));
        } else if (xsdType.equalsIgnoreCase("boolean")) {
            if (literalString.equalsIgnoreCase(".F.")) {
                this.addLiteral(r1, valueProp, ResourceFactory.createTypedLiteral((String)"false", (RDFDatatype)XSDDatatype.XSDboolean));
            } else if (literalString.equalsIgnoreCase(".T.")) {
                this.addLiteral(r1, valueProp, ResourceFactory.createTypedLiteral((String)"true", (RDFDatatype)XSDDatatype.XSDboolean));
            } else if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*WARNING 10*: found odd boolean value: " + literalString + "\r\n");
            }
        } else if (xsdType.equalsIgnoreCase("logical")) {
            if (literalString.equalsIgnoreCase(".F.")) {
                this.addProperty(r1, valueProp, this.expressModel.getResource("https://w3id.org/express#FALSE"));
            } else if (literalString.equalsIgnoreCase(".T.")) {
                this.addProperty(r1, valueProp, this.expressModel.getResource("https://w3id.org/express#TRUE"));
            } else if (literalString.equalsIgnoreCase(".U.")) {
                this.addProperty(r1, valueProp, this.expressModel.getResource("https://w3id.org/express#UNKNOWN"));
            } else if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*WARNING 9*: found odd logical value: " + literalString + "\r\n");
            }
        } else if (xsdType.equalsIgnoreCase("string")) {
            this.addLiteral(r1, valueProp, ResourceFactory.createTypedLiteral((String)literalString, (RDFDatatype)XSDDatatype.XSDstring));
        } else {
            this.addLiteral(r1, valueProp, ResourceFactory.createTypedLiteral((Object)literalString));
        }
        if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.write("*OK 4*: added literal: " + r1.getLocalName() + " - " + valueProp + " - " + literalString + "\r\n");
        }
    }

    private void addDirectRegularListProperty(Resource r, OntResource range, OntResource listrange, List<Object> el, int mySwitch) throws IOException {
        if (range.isClass()) {
            if (listrange.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*WARNING 27*: Found unhandled ListOfList\r\n");
                }
            } else {
                Resource r1;
                int i;
                ArrayList<Resource> reslist = new ArrayList<Resource>();
                for (i = 0; i < el.size(); ++i) {
                    if (i == 0) {
                        reslist.add(r);
                        continue;
                    }
                    r1 = this.getResource(this.baseURI + range.getLocalName() + "_" + this.IDcounter, range);
                    reslist.add(r1);
                    ++this.IDcounter;
                }
                if (mySwitch == 0) {
                    ArrayList<String> literals = new ArrayList<String>();
                    for (int i2 = 0; i2 < el.size(); ++i2) {
                        literals.add((String)el.get(i2));
                    }
                    this.addListInstanceProperties(reslist, literals, listrange);
                } else {
                    for (i = 0; i < reslist.size(); ++i) {
                        r1 = (Resource)reslist.get(i);
                        IFCVO vo = (IFCVO)el.get(i);
                        EntityVO evorange = this.ent.get(ExpressReader.formatClassName((String)vo.getName()));
                        OntResource rclass = this.ontModel.getOntResource(this.ontNS + evorange.getName());
                        Resource r2 = this.getResource(this.baseURI + evorange.getName() + "_" + vo.getLineNum(), rclass);
                        if (this.myIfcReaderStream.logToFile) {
                            this.myIfcReaderStream.bw.write("*OK 21*: created resource: " + r2.getLocalName() + "\r\n");
                        }
                        ++this.IDcounter;
                        this.ttlWriter.triple(new Triple(r1.asNode(), this.listModel.getOntProperty("https://w3id.org/list#hasContents").asNode(), r2.asNode()));
                        if (this.myIfcReaderStream.logToFile) {
                            this.myIfcReaderStream.bw.write("*OK 22*: added property: " + r1.getLocalName() + " - -hasContents- - " + r2.getLocalName() + "\r\n");
                        }
                        if (i >= el.size() - 1) continue;
                        this.ttlWriter.triple(new Triple(r1.asNode(), this.listModel.getOntProperty("https://w3id.org/list#hasNext").asNode(), ((Resource)reslist.get(i + 1)).asNode()));
                        if (!this.myIfcReaderStream.logToFile) continue;
                        this.myIfcReaderStream.bw.write("*OK 23*: added property: " + r1.getLocalName() + " - -hasNext- - " + ((Resource)reslist.get(i + 1)).getLocalName() + "\r\n");
                    }
                }
            }
        }
    }

    private void addRegularListProperty(Resource r, OntProperty p, List<String> el, TypeVO typeRemembranceOverride) throws IOException {
        OntResource range = p.getRange();
        if (range.isClass()) {
            OntResource listrange = this.getListContentType(range.asClass());
            if (typeRemembranceOverride != null) {
                OntClass cla = this.ontModel.getOntClass(this.ontNS + typeRemembranceOverride.getName());
                listrange = cla;
            }
            if (listrange == null) {
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*ERROR 14*: We could not find what kind of content is expected in the LIST.\r\n");
                }
            } else if (listrange.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*WARNING 28*: Found unhandled ListOfList\r\n");
                }
            } else {
                ArrayList<Resource> reslist = new ArrayList<Resource>();
                for (int ii = 0; ii < el.size(); ++ii) {
                    Resource r1 = this.getResource(this.baseURI + range.getLocalName() + "_" + this.IDcounter, range);
                    reslist.add(r1);
                    ++this.IDcounter;
                    if (ii != 0) continue;
                    this.ttlWriter.triple(new Triple(r.asNode(), p.asNode(), r1.asNode()));
                    if (!this.myIfcReaderStream.logToFile) continue;
                    this.myIfcReaderStream.bw.write("*OK 7*: added property: " + r.getLocalName() + " - " + p.getLocalName() + " - " + r1.getLocalName() + "\r\n");
                }
                this.addListInstanceProperties(reslist, el, listrange);
            }
        }
    }

    private void createLiteralProperty(Resource r, OntResource p, OntResource range, String literalString) throws IOException {
        String xsdType = this.getXSDTypeFromRange(range);
        if (xsdType == null) {
            xsdType = this.getXSDTypeFromRangeExpensiveMethod(range);
        }
        if (xsdType != null) {
            String xsdTypeCAP = Character.toUpperCase(xsdType.charAt(0)) + xsdType.substring(1);
            OntProperty valueProp = this.expressModel.getOntProperty("https://w3id.org/express#has" + xsdTypeCAP);
            String key = valueProp.toString() + ":" + xsdType + ":" + literalString;
            Resource r1 = this.propertyResourceMap.get(key);
            if (r1 == null) {
                r1 = ResourceFactory.createResource((String)(this.baseURI + range.getLocalName() + "_" + this.IDcounter));
                this.ttlWriter.triple(new Triple(r1.asNode(), RDF.type.asNode(), range.asNode()));
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*OK 17*: created resource: " + r1.getLocalName() + "\r\n");
                }
                ++this.IDcounter;
                this.propertyResourceMap.put(key, r1);
                this.addLiteralToResource(r1, valueProp, xsdType, literalString);
            }
            this.ttlWriter.triple(new Triple(r.asNode(), p.asNode(), r1.asNode()));
            if (this.myIfcReaderStream.logToFile) {
                this.myIfcReaderStream.bw.write("*OK 3*: added property: " + r.getLocalName() + " - " + p.getLocalName() + " - " + r1.getLocalName() + "\r\n");
            }
        } else if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.write("*ERROR 1*: XSD type not found for: " + p + " - " + range.getURI() + " - " + literalString + "\r\n");
        }
    }

    private void addListPropertyToGivenEntities(Resource r, OntProperty p, List<Resource> el) throws IOException {
        OntResource range = p.getRange();
        if (range.isClass()) {
            OntResource listrange = this.getListContentType(range.asClass());
            if (listrange.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*OK 20*: Handling list of list\r\n");
                }
                listrange = range;
            }
            for (int i = 0; i < el.size(); ++i) {
                Resource r1 = el.get(i);
                Resource r2 = ResourceFactory.createResource((String)(this.baseURI + range.getLocalName() + "_" + this.IDcounter));
                this.ttlWriter.triple(new Triple(r2.asNode(), RDF.type.asNode(), range.asNode()));
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*OK 14*: added property: " + r2.getLocalName() + " - rdf:type - " + range.getLocalName() + "\r\n");
                }
                ++this.IDcounter;
                Resource r3 = ResourceFactory.createResource((String)(this.baseURI + range.getLocalName() + "_" + this.IDcounter));
                if (i == 0) {
                    this.ttlWriter.triple(new Triple(r.asNode(), p.asNode(), r2.asNode()));
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*OK 15*: added property: " + r.getLocalName() + " - " + p.getLocalName() + " - " + r2.getLocalName() + "\r\n");
                    }
                }
                this.ttlWriter.triple(new Triple(r2.asNode(), this.listModel.getOntProperty("https://w3id.org/list#hasContents").asNode(), r1.asNode()));
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*OK 16*: added property: " + r2.getLocalName() + " - -hasContents- - " + r1.getLocalName() + "\r\n");
                }
                if (i >= el.size() - 1) continue;
                this.ttlWriter.triple(new Triple(r2.asNode(), this.listModel.getOntProperty("https://w3id.org/list#hasNext").asNode(), r3.asNode()));
                if (!this.myIfcReaderStream.logToFile) continue;
                this.myIfcReaderStream.bw.write("*OK 17*: added property: " + r2.getLocalName() + " - -hasNext- - " + r3.getLocalName() + "\r\n");
            }
        }
    }

    private void fillClassInstanceList(LinkedList<Object> tmpList, OntResource typerange, OntProperty p, Resource r) throws IOException {
        ArrayList<Resource> reslist = new ArrayList<Resource>();
        ArrayList<IFCVO> entlist = new ArrayList<IFCVO>();
        for (int i = 0; i < tmpList.size(); ++i) {
            if (!IFCVO.class.isInstance(tmpList.get(i))) continue;
            Resource r1 = this.getResource(this.baseURI + typerange.getLocalName() + "_" + this.IDcounter, typerange);
            reslist.add(r1);
            ++this.IDcounter;
            entlist.add((IFCVO)tmpList.get(i));
            if (i != 0) continue;
            this.ttlWriter.triple(new Triple(r.asNode(), p.asNode(), r1.asNode()));
            if (!this.myIfcReaderStream.logToFile) continue;
            this.myIfcReaderStream.bw.write("*OK 13*: added property: " + r.getLocalName() + " - " + p.getLocalName() + " - " + r1.getLocalName() + "\r\n");
        }
        String listvaluepropURI = this.ontNS + typerange.getLocalName().substring(0, typerange.getLocalName().length() - 5);
        OntResource listrange = this.ontModel.getOntResource(listvaluepropURI);
        this.addClassInstanceListProperties(reslist, entlist, listrange);
    }

    private void addClassInstanceListProperties(List<Resource> reslist, List<IFCVO> entlist, OntResource listrange) throws IOException {
        OntProperty listp = this.listModel.getOntProperty("https://w3id.org/list#hasContents");
        OntProperty isfollowed = this.listModel.getOntProperty("https://w3id.org/list#hasNext");
        for (int i = 0; i < reslist.size(); ++i) {
            Resource r = reslist.get(i);
            OntResource rclass = null;
            EntityVO evorange = this.ent.get(ExpressReader.formatClassName((String)entlist.get(i).getName()));
            if (evorange == null) {
                TypeVO typerange = this.typ.get(ExpressReader.formatClassName((String)entlist.get(i).getName()));
                rclass = this.ontModel.getOntResource(this.ontNS + typerange.getName());
                Resource r1 = this.getResource(this.baseURI + typerange.getName() + "_" + entlist.get(i).getLineNum(), rclass);
                this.ttlWriter.triple(new Triple(r.asNode(), listp.asNode(), r1.asNode()));
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*OK 8*: created property: " + r.getLocalName() + " - " + listp.getLocalName() + " - " + r1.getLocalName() + "\r\n");
                }
            } else {
                rclass = this.ontModel.getOntResource(this.ontNS + evorange.getName());
                Resource r1 = this.getResource(this.baseURI + evorange.getName() + "_" + entlist.get(i).getLineNum(), rclass);
                this.ttlWriter.triple(new Triple(r.asNode(), listp.asNode(), r1.asNode()));
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*OK 9*: created property: " + r.getLocalName() + " - " + listp.getLocalName() + " - " + r1.getLocalName() + "\r\n");
                }
            }
            if (i >= reslist.size() - 1) continue;
            this.ttlWriter.triple(new Triple(r.asNode(), isfollowed.asNode(), reslist.get(i + 1).asNode()));
            if (!this.myIfcReaderStream.logToFile) continue;
            this.myIfcReaderStream.bw.write("*OK 10*: created property: " + r.getLocalName() + " - " + isfollowed.getLocalName() + " - " + reslist.get(i + 1).getLocalName() + "\r\n");
        }
    }

    private void addListInstanceProperties(List<Resource> reslist, List<String> listelements, OntResource listrange) throws IOException {
        String xsdType = this.getXSDTypeFromRange(listrange);
        if (xsdType == null) {
            xsdType = this.getXSDTypeFromRangeExpensiveMethod(listrange);
        }
        if (xsdType != null) {
            String xsdTypeCAP = Character.toUpperCase(xsdType.charAt(0)) + xsdType.substring(1);
            OntProperty valueProp = this.expressModel.getOntProperty("https://w3id.org/express#has" + xsdTypeCAP);
            for (int i = 0; i < reslist.size(); ++i) {
                Resource r = reslist.get(i);
                String literalString = listelements.get(i);
                String key = valueProp.toString() + ":" + xsdType + ":" + literalString;
                Resource r2 = this.propertyResourceMap.get(key);
                if (r2 == null) {
                    r2 = ResourceFactory.createResource((String)(this.baseURI + listrange.getLocalName() + "_" + this.IDcounter));
                    this.ttlWriter.triple(new Triple(r2.asNode(), RDF.type.asNode(), listrange.asNode()));
                    if (this.myIfcReaderStream.logToFile) {
                        this.myIfcReaderStream.bw.write("*OK 19*: created resource: " + r2.getLocalName() + "\r\n");
                    }
                    ++this.IDcounter;
                    this.propertyResourceMap.put(key, r2);
                    this.addLiteralToResource(r2, valueProp, xsdType, literalString);
                }
                this.ttlWriter.triple(new Triple(r.asNode(), this.listModel.getOntProperty("https://w3id.org/list#hasContents").asNode(), r2.asNode()));
                if (this.myIfcReaderStream.logToFile) {
                    this.myIfcReaderStream.bw.write("*OK 11*: added property: " + r.getLocalName() + " - -hasContents- - " + r2.getLocalName() + "\r\n");
                }
                if (i >= listelements.size() - 1) continue;
                this.ttlWriter.triple(new Triple(r.asNode(), this.listModel.getOntProperty("https://w3id.org/list#hasNext").asNode(), reslist.get(i + 1).asNode()));
                if (!this.myIfcReaderStream.logToFile) continue;
                this.myIfcReaderStream.bw.write("*OK 12*: added property: " + r.getLocalName() + " - -hasNext- - " + reslist.get(i + 1).getLocalName() + "\r\n");
            }
        } else if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.write("*ERROR 5*: XSD type not found for: " + listrange.getLocalName() + "\r\n");
        }
    }

    private String filterExtras(String txt) {
        StringBuffer sb = new StringBuffer();
        block4: for (int n = 0; n < txt.length(); ++n) {
            char ch = txt.charAt(n);
            switch (ch) {
                case '\'': {
                    continue block4;
                }
                case '=': {
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private String filterPoints(String txt) {
        StringBuffer sb = new StringBuffer();
        block3: for (int n = 0; n < txt.length(); ++n) {
            char ch = txt.charAt(n);
            switch (ch) {
                case '.': {
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private Long toLong(String txt) {
        try {
            return Long.valueOf(txt);
        }
        catch (Exception e) {
            return Long.MIN_VALUE;
        }
    }

    private void addLiteral(Resource r, OntProperty valueProp, Literal l) {
        this.ttlWriter.triple(new Triple(r.asNode(), valueProp.asNode(), l.asNode()));
    }

    private void addProperty(Resource r, OntProperty valueProp, Resource r1) {
        this.ttlWriter.triple(new Triple(r.asNode(), valueProp.asNode(), r1.asNode()));
    }

    private OntResource getListContentType(OntClass range) throws IOException {
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#STRING_List") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#STRING_List"))) {
            return this.expressModel.getOntResource("https://w3id.org/express#STRING");
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#REAL_List") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#REAL_List"))) {
            return this.expressModel.getOntResource("https://w3id.org/express#REAL");
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#INTEGER_List") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#INTEGER_List"))) {
            return this.expressModel.getOntResource("https://w3id.org/express#INTEGER");
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#BINARY_List") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#BINARY_List"))) {
            return this.expressModel.getOntResource("https://w3id.org/express#BINARY");
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#BOOLEAN_List") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#BOOLEAN_List"))) {
            return this.expressModel.getOntResource("https://w3id.org/express#BOOLEAN");
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#LOGICAL_List") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#LOGICAL_List"))) {
            return this.expressModel.getOntResource("https://w3id.org/express#LOGICAL");
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#NUMBER_List") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#NUMBER_List"))) {
            return this.expressModel.getOntResource("https://w3id.org/express#NUMBER");
        }
        if (range.asClass().hasSuperClass((Resource)this.listModel.getOntClass("https://w3id.org/list#OWLList"))) {
            String listvaluepropURI = this.ontNS + range.getLocalName().substring(0, range.getLocalName().length() - 5);
            return this.ontModel.getOntResource(listvaluepropURI);
        }
        if (this.myIfcReaderStream.logToFile) {
            this.myIfcReaderStream.bw.write("*WARNING 29*: did not find listcontenttype for : " + range.getLocalName() + "\r\n");
        }
        return null;
    }

    private String getXSDTypeFromRange(OntResource range) {
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#STRING") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#STRING"))) {
            return "string";
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#REAL") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#REAL"))) {
            return "double";
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#INTEGER") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#INTEGER"))) {
            return "integer";
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#BINARY") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#BINARY"))) {
            return "hexBinary";
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#BOOLEAN") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#BOOLEAN"))) {
            return "boolean";
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#LOGICAL") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#LOGICAL"))) {
            return "logical";
        }
        if (range.asClass().getURI().equalsIgnoreCase("https://w3id.org/express#NUMBER") || range.asClass().hasSuperClass((Resource)this.expressModel.getOntClass("https://w3id.org/express#NUMBER"))) {
            return "double";
        }
        return null;
    }

    private String getXSDTypeFromRangeExpensiveMethod(OntResource range) {
        ExtendedIterator iter = range.asClass().listSuperClasses();
        while (iter.hasNext()) {
            String type;
            OntClass superc = (OntClass)iter.next();
            if (superc.isAnon() || (type = this.getXSDTypeFromRange((OntResource)superc)) == null) continue;
            return type;
        }
        return null;
    }

    private Resource getResource(String uri, OntResource rclass) {
        Resource r = this.resourceMap.get(uri);
        if (r == null) {
            r = ResourceFactory.createResource((String)uri);
            this.resourceMap.put(uri, r);
            try {
                this.ttlWriter.triple(new Triple(r.asNode(), RDF.type.asNode(), rclass.asNode()));
            }
            catch (Exception e) {
                if (this.myIfcReaderStream.logToFile) {
                    try {
                        this.myIfcReaderStream.bw.write("*ERROR 2*: getResource failed for " + uri + "\r\n");
                        System.err.println("*ERROR 2*: getResource failed for " + uri);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                return null;
            }
        }
        return r;
    }

    public boolean isRemoveDuplicates() {
        return this.removeDuplicates;
    }

    public void setRemoveDuplicates(boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
    }
}

