/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.control;

import com.github.pires.obd.commands.PersistentCommand;
import com.github.pires.obd.enums.AvailableCommandNames;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VinCommand
extends PersistentCommand {
    String vin = "";

    public VinCommand() {
        super("09 02");
    }

    public VinCommand(VinCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        String workingData;
        String result = this.getResult();
        if (result.contains(":")) {
            workingData = result.replaceAll(".:", "").substring(9);
            Matcher m = Pattern.compile("[^a-z0-9 ]", 2).matcher(this.convertHexToString(workingData));
            if (m.find()) {
                workingData = result.replaceAll("0:49", "").replaceAll(".:", "");
            }
        } else {
            workingData = result.replaceAll("49020.", "");
        }
        this.vin = this.convertHexToString(workingData).replaceAll("[\u0000-\u001f]", "");
    }

    @Override
    public String getFormattedResult() {
        return String.valueOf(this.vin);
    }

    @Override
    public String getName() {
        return AvailableCommandNames.VIN.getValue();
    }

    @Override
    public String getCalculatedResult() {
        return String.valueOf(this.vin);
    }

    @Override
    protected void fillBuffer() {
    }

    public String convertHexToString(String hex) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int decimal = Integer.parseInt(output, 16);
            sb.append((char)decimal);
        }
        return sb.toString();
    }
}

