/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.pressure;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.commands.SystemOfUnits;

public abstract class PressureCommand
extends ObdCommand
implements SystemOfUnits {
    protected int tempValue = 0;
    protected int pressure = 0;

    public PressureCommand(String cmd) {
        super(cmd);
    }

    public PressureCommand(PressureCommand other) {
        super(other);
    }

    protected int preparePressureValue() {
        return (Integer)this.buffer.get(2);
    }

    @Override
    protected void performCalculations() {
        this.pressure = this.preparePressureValue();
    }

    @Override
    public String getFormattedResult() {
        return this.useImperialUnits ? String.format("%.1f%s", Float.valueOf(this.getImperialUnit()), this.getResultUnit()) : String.format("%d%s", this.pressure, this.getResultUnit());
    }

    public int getMetricUnit() {
        return this.pressure;
    }

    @Override
    public float getImperialUnit() {
        return (float)this.pressure * 0.14503774f;
    }

    @Override
    public String getCalculatedResult() {
        return this.useImperialUnits ? String.valueOf(this.getImperialUnit()) : String.valueOf(this.pressure);
    }

    @Override
    public String getResultUnit() {
        return this.useImperialUnits ? "psi" : "kPa";
    }
}

