/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.temperature;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.commands.SystemOfUnits;

public abstract class TemperatureCommand
extends ObdCommand
implements SystemOfUnits {
    private float temperature = 0.0f;

    public TemperatureCommand(String cmd) {
        super(cmd);
    }

    public TemperatureCommand(TemperatureCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        this.temperature = (Integer)this.buffer.get(2) - 40;
    }

    @Override
    public String getFormattedResult() {
        return this.useImperialUnits ? String.format("%.1f%s", Float.valueOf(this.getImperialUnit()), this.getResultUnit()) : String.format("%.0f%s", Float.valueOf(this.temperature), this.getResultUnit());
    }

    @Override
    public String getCalculatedResult() {
        return this.useImperialUnits ? String.valueOf(this.getImperialUnit()) : String.valueOf(this.temperature);
    }

    @Override
    public String getResultUnit() {
        return this.useImperialUnits ? "F" : "C";
    }

    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public float getImperialUnit() {
        return this.temperature * 1.8f + 32.0f;
    }

    public float getKelvin() {
        return this.temperature + 273.15f;
    }

    @Override
    public abstract String getName();
}

