/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.pekkohttpspi;

import com.github.pjfanning.pekkohttpspi.PekkoHttpClient;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpCharset$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpHeader$;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaType$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.RequestEntityAcceptance;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType$;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString$;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.jdk.javaapi.OptionConverters$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

public final class PekkoHttpClient$ {
    public static final PekkoHttpClient$ MODULE$ = new PekkoHttpClient$();
    private static ContentType.Binary xAmzJson;
    private static ContentType.Binary xAmzJson11;
    private static ContentType.Binary xAmzCbor11;
    private static ContentType.WithCharset formUrlEncoded;
    private static ContentType.Binary applicationXml;
    private static scala.collection.immutable.Map<String, ContentType> contentTypeMap;
    private static final Logger logger;
    private static volatile byte bitmap$0;

    static {
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    public Logger logger() {
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest toPekkoRequest(SdkHttpRequest request, SdkHttpContentPublisher contentPublisher) {
        void var4_4;
        void var5_5;
        Tuple2<Option<HttpHeader>, Seq<HttpHeader>> tuple2 = this.convertHeaders(request.headers());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option contentTypeHeader = (Option)tuple2._1();
        Seq reqheaders = (Seq)tuple2._2();
        HttpMethod method = this.convertMethod(request.method().name());
        return HttpRequest$.MODULE$.apply(method, Uri$.MODULE$.apply(request.getUri().toString()), (Seq)var5_5, this.entityForMethodAndContentType(method, this.contentTypeHeaderToContentType((Option<HttpHeader>)var4_4), contentPublisher), HttpProtocols$.MODULE$.HTTP$div1$u002E1());
    }

    public RequestEntity entityForMethodAndContentType(HttpMethod method, ContentType contentType, SdkHttpContentPublisher contentPublisher) {
        RequestEntityAcceptance requestEntityAcceptance = method.requestEntityAcceptance();
        if (RequestEntityAcceptance.Expected$.MODULE$.equals(requestEntityAcceptance)) {
            Optional toScala_o = contentPublisher.contentLength();
            Object var7_5 = null;
            Option option = OptionConverters$.MODULE$.toScala(toScala_o);
            if (option instanceof Some) {
                Long length = (Long)((Some)option).value();
                return HttpEntity$.MODULE$.apply(contentType, Predef$.MODULE$.Long2long(length), (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1 & Serializable)x$2 -> ByteString$.MODULE$.apply(x$2)));
            }
            if (None$.MODULE$.equals(option)) {
                return HttpEntity$.MODULE$.apply(contentType, (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1 & Serializable)x$3 -> ByteString$.MODULE$.apply(x$3)));
            }
            throw new MatchError((Object)option);
        }
        return HttpEntity$.MODULE$.Empty();
    }

    public HttpMethod convertMethod(String method) {
        return (HttpMethod)HttpMethods$.MODULE$.getForKeyCaseInsensitive(method, (.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(23).append("Method not configured: ").append(method).toString());
        });
    }

    public ContentType contentTypeHeaderToContentType(Option<HttpHeader> contentTypeHeader) {
        return (ContentType)contentTypeHeader.map((Function1 & Serializable)x$4 -> x$4.value()).map((Function1 & Serializable)v -> (ContentType)MODULE$.contentTypeMap().getOrElse(v, (Function0 & Serializable)() -> MODULE$.tryCreateCustomContentType((String)v))).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.NoContentType());
    }

    public Tuple2<Option<HttpHeader>, Seq<HttpHeader>> convertHeaders(Map<String, java.util.List<String>> headers) {
        Builder builder = Map$.MODULE$.newBuilder();
        headers.forEach((x0$1, x1$1) -> builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1), x1$1)));
        return (Tuple2)((scala.collection.mutable.Map)builder.result()).foldLeft((Object)new Tuple2((Object)Option$.MODULE$.empty(), (Object)package$.MODULE$.List().empty()), (Function2 & Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (x0$2 != null) {
                void var5_5;
                void var6_6;
                Option ctHeader = (Option)x0$2._1();
                List hdrs = (List)x0$2._2();
                if (x1$2 == null) {
                    throw new MatchError(null);
                }
                String headerName = (String)x1$2._1();
                java.util.List headerValue = (java.util.List)x1$2._2();
                if (var6_6.size() != 1) {
                    StringBuilder stringBuilder = new StringBuilder(37).append("Found invalid header: key: ").append((String)var5_5).append(", Value: ");
                    Builder list = package$.MODULE$.List().newBuilder();
                    var6_6.forEach(v -> list.$plus$eq(v));
                    throw new IllegalArgumentException(stringBuilder.append(list.result()).append(".").toString());
                }
                String string = Content$minusLength$.MODULE$.lowercaseName();
                String string2 = var5_5.toLowerCase();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return new Tuple2((Object)ctHeader, (Object)hdrs);
                }
                HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse((String)var5_5, (String)var6_6.get(0), HttpHeader$.MODULE$.parse$default$3());
                if (parsingResult instanceof HttpHeader.ParsingResult$.Ok) {
                    HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
                    String string3 = ok.header().lowercaseName();
                    String string4 = Content$minusType$.MODULE$.lowercaseName();
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        return new Tuple2((Object)new Some((Object)ok.header()), (Object)hdrs);
                    }
                    return new Tuple2((Object)ctHeader, hdrs.$colon$plus((Object)ok.header()));
                }
                if (parsingResult instanceof HttpHeader.ParsingResult$.Error) {
                    HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)parsingResult;
                    throw new IllegalArgumentException(new StringBuilder(23).append("Found invalid header: ").append(error.errors()).append(".").toString());
                }
                throw new MatchError((Object)parsingResult);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public ContentType tryCreateCustomContentType(String contentTypeStr) {
        this.logger().debug(new StringBuilder(31).append("Try to parse content type from ").append(contentTypeStr).toString());
        String[] mainAndsubType = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(contentTypeStr), '/');
        if (mainAndsubType.length == 2) {
            return ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary(mainAndsubType[0], mainAndsubType[1], (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
        }
        throw new RuntimeException(new StringBuilder(39).append("Could not parse custom content type '").append(contentTypeStr).append("'.").toString());
    }

    public PekkoHttpClient.PekkoHttpClientBuilder builder() {
        return new PekkoHttpClient.PekkoHttpClientBuilder((Option<ActorSystem>)None$.MODULE$, (Option<ExecutionContext>)None$.MODULE$, (Option<ConnectionPoolSettings>)None$.MODULE$);
    }

    private ContentType.Binary xAmzJson$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 1) == 0) {
                xAmzJson = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.0", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return xAmzJson;
    }

    public ContentType.Binary xAmzJson() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.xAmzJson$lzycompute();
        }
        return xAmzJson;
    }

    private ContentType.Binary xAmzJson11$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 2) == 0) {
                xAmzJson11 = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.1", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return xAmzJson11;
    }

    public ContentType.Binary xAmzJson11() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.xAmzJson11$lzycompute();
        }
        return xAmzJson11;
    }

    private ContentType.Binary xAmzCbor11$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 4) == 0) {
                xAmzCbor11 = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-cbor-1.1", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return xAmzCbor11;
    }

    public ContentType.Binary xAmzCbor11() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.xAmzCbor11$lzycompute();
        }
        return xAmzCbor11;
    }

    private ContentType.WithCharset formUrlEncoded$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 8) == 0) {
                formUrlEncoded = ContentType$.MODULE$.apply(MediaType$.MODULE$.applicationWithOpenCharset("x-www-form-urlencoded", (Seq)Nil$.MODULE$), HttpCharset$.MODULE$.custom("utf-8", (Seq)Nil$.MODULE$));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return formUrlEncoded;
    }

    public ContentType.WithCharset formUrlEncoded() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.formUrlEncoded$lzycompute();
        }
        return formUrlEncoded;
    }

    private ContentType.Binary applicationXml$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                applicationXml = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "xml", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return applicationXml;
    }

    public ContentType.Binary applicationXml() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.applicationXml$lzycompute();
        }
        return applicationXml;
    }

    private scala.collection.immutable.Map<String, ContentType> contentTypeMap$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                contentTypeMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-json-1.0"), (Object)this.xAmzJson()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-json-1.1"), (Object)this.xAmzJson11()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-cbor-1.1"), (Object)this.xAmzCbor11()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-www-form-urlencoded; charset-UTF-8"), (Object)this.formUrlEncoded()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-www-form-urlencoded"), (Object)this.formUrlEncoded()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/xml"), (Object)this.applicationXml())}));
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return contentTypeMap;
    }

    public scala.collection.immutable.Map<String, ContentType> contentTypeMap() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.contentTypeMap$lzycompute();
        }
        return contentTypeMap;
    }

    private PekkoHttpClient$() {
    }
}

