/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.exceptions.MissingSheetException;
import com.github.pjfanning.xlsx.impl.StreamingSheet;
import com.github.pjfanning.xlsx.impl.StreamingWorkbookReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.Workbook;

public class StreamingWorkbook
implements Workbook,
AutoCloseable {
    private final StreamingWorkbookReader reader;
    private POIXMLProperties.CoreProperties coreProperties = null;

    public StreamingWorkbook(StreamingWorkbookReader reader) {
        this.reader = reader;
        reader.setWorkbook(this);
    }

    int findSheetByName(String name) {
        for (int i = 0; i < this.reader.getSheetProperties().size(); ++i) {
            if (!this.reader.getSheetProperties().get(i).get("name").equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Iterator<Sheet> iterator() {
        return this.reader.iterator();
    }

    public Iterator<Sheet> sheetIterator() {
        return this.iterator();
    }

    public String getSheetName(int sheet) {
        return this.reader.getSheetProperties().get(sheet).get("name");
    }

    public int getSheetIndex(String name) {
        return this.findSheetByName(name);
    }

    public int getSheetIndex(Sheet sheet) {
        if (sheet instanceof StreamingSheet) {
            return this.findSheetByName(sheet.getSheetName());
        }
        throw new UnsupportedOperationException("Cannot use non-StreamingSheet sheets");
    }

    public int getNumberOfSheets() {
        return this.reader.getSheets().size();
    }

    public Sheet getSheetAt(int index) {
        return this.reader.getSheets().get(index);
    }

    public Sheet getSheet(String name) {
        int index = this.getSheetIndex(name);
        if (index == -1) {
            throw new MissingSheetException("Sheet '" + name + "' does not exist");
        }
        return this.reader.getSheets().get(index);
    }

    public boolean isSheetHidden(int sheetIx) {
        return "hidden".equals(this.reader.getSheetProperties().get(sheetIx).get("state"));
    }

    public boolean isSheetVeryHidden(int sheetIx) {
        return "veryHidden".equals(this.reader.getSheetProperties().get(sheetIx).get("state"));
    }

    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public POIXMLProperties.CoreProperties getCoreProperties() {
        return this.coreProperties;
    }

    void setCoreProperties(POIXMLProperties.CoreProperties coreProperties) {
        this.coreProperties = coreProperties;
    }

    public int getActiveSheetIndex() {
        throw new UnsupportedOperationException();
    }

    public void setActiveSheet(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    public int getFirstVisibleTab() {
        throw new UnsupportedOperationException();
    }

    public void setFirstVisibleTab(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    public void setSheetOrder(String sheetname, int pos) {
        throw new UnsupportedOperationException();
    }

    public void setSelectedTab(int index) {
        throw new UnsupportedOperationException();
    }

    public void setSheetName(int sheet, String name) {
        throw new UnsupportedOperationException();
    }

    public Sheet createSheet() {
        throw new UnsupportedOperationException();
    }

    public Sheet createSheet(String sheetname) {
        throw new UnsupportedOperationException();
    }

    public Sheet cloneSheet(int sheetNum) {
        throw new UnsupportedOperationException();
    }

    public void removeSheetAt(int index) {
        throw new UnsupportedOperationException();
    }

    public Font createFont() {
        throw new UnsupportedOperationException();
    }

    public Font findFont(boolean b, short i, short i1, String s, boolean b1, boolean b2, short i2, byte b3) {
        throw new UnsupportedOperationException();
    }

    public short getNumberOfFonts() {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfFontsAsInt() {
        throw new UnsupportedOperationException();
    }

    public Font getFontAt(short idx) {
        throw new UnsupportedOperationException();
    }

    public Font getFontAt(int i) {
        throw new UnsupportedOperationException();
    }

    public CellStyle createCellStyle() {
        throw new UnsupportedOperationException();
    }

    public int getNumCellStyles() {
        throw new UnsupportedOperationException();
    }

    public CellStyle getCellStyleAt(int i) {
        throw new UnsupportedOperationException();
    }

    public void write(OutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfNames() {
        throw new UnsupportedOperationException();
    }

    public Name getName(String name) {
        throw new UnsupportedOperationException();
    }

    public List<? extends Name> getNames(String s) {
        throw new UnsupportedOperationException();
    }

    public List<? extends Name> getAllNames() {
        throw new UnsupportedOperationException();
    }

    public Name getNameAt(int nameIndex) {
        throw new UnsupportedOperationException();
    }

    public Name createName() {
        throw new UnsupportedOperationException();
    }

    public int getNameIndex(String name) {
        throw new UnsupportedOperationException();
    }

    public void removeName(int index) {
        throw new UnsupportedOperationException();
    }

    public void removeName(String name) {
        throw new UnsupportedOperationException();
    }

    public void removeName(Name name) {
        throw new UnsupportedOperationException();
    }

    public int linkExternalWorkbook(String name, Workbook workbook) {
        throw new UnsupportedOperationException();
    }

    public void setPrintArea(int sheetIndex, String reference) {
        throw new UnsupportedOperationException();
    }

    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        throw new UnsupportedOperationException();
    }

    public String getPrintArea(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    public void removePrintArea(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    public Row.MissingCellPolicy getMissingCellPolicy() {
        throw new UnsupportedOperationException();
    }

    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        throw new UnsupportedOperationException();
    }

    public DataFormat createDataFormat() {
        throw new UnsupportedOperationException();
    }

    public int addPicture(byte[] pictureData, int format) {
        throw new UnsupportedOperationException();
    }

    public List<? extends PictureData> getAllPictures() {
        throw new UnsupportedOperationException();
    }

    public CreationHelper getCreationHelper() {
        throw new UnsupportedOperationException();
    }

    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    public void setHidden(boolean hiddenFlag) {
        throw new UnsupportedOperationException();
    }

    public void setSheetHidden(int sheetIx, boolean hidden) {
        throw new UnsupportedOperationException();
    }

    public SheetVisibility getSheetVisibility(int i) {
        throw new UnsupportedOperationException();
    }

    public void setSheetVisibility(int i, SheetVisibility sheetVisibility) {
        throw new UnsupportedOperationException();
    }

    public void addToolPack(UDFFinder toopack) {
        throw new UnsupportedOperationException();
    }

    public void setForceFormulaRecalculation(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean getForceFormulaRecalculation() {
        throw new UnsupportedOperationException();
    }

    public int addOlePackage(byte[] bytes, String s, String s1, String s2) throws IOException {
        throw new UnsupportedOperationException();
    }
}

