/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl.ooxml;

import com.github.pjfanning.poi.xssf.streaming.TempFileCommentsTable;
import com.github.pjfanning.xlsx.StreamingReader;
import com.github.pjfanning.xlsx.impl.StreamingWorkbookReader;
import com.github.pjfanning.xlsx.impl.ooxml.OoxmlStrictHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.util.Internal;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Internal
public class OoxmlReader
extends XSSFReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OoxmlReader.class);
    static final String PURL_COMMENTS_RELATIONSHIP_URL = "http://purl.oclc.org/ooxml/officeDocument/relationships/comments";
    static final String PURL_DRAWING_RELATIONSHIP_URL = "http://purl.oclc.org/ooxml/officeDocument/relationships/drawing";
    private static final Set<String> OVERRIDE_WORKSHEET_RELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(XSSFRelation.WORKSHEET.getRelation(), "http://purl.oclc.org/ooxml/officeDocument/relationships/worksheet", XSSFRelation.CHARTSHEET.getRelation(), XSSFRelation.MACRO_SHEET_BIN.getRelation())));
    private final boolean strictOoxmlChecksNeeded;
    private final StreamingWorkbookReader streamingWorkbookReader;

    @Internal
    public OoxmlReader(StreamingWorkbookReader streamingWorkbookReader, OPCPackage pkg, boolean strictOoxmlChecksNeeded) throws IOException, OpenXML4JException {
        super(pkg, true);
        this.streamingWorkbookReader = streamingWorkbookReader;
        this.strictOoxmlChecksNeeded = strictOoxmlChecksNeeded;
        PackageRelationship coreDocRelationship = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        if (coreDocRelationship == null && (coreDocRelationship = this.pkg.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument").getRelationship(0)) == null) {
            throw new POIXMLException("OOXML file structure broken/invalid - no core document found!");
        }
        this.workbookPart = this.pkg.getPart(coreDocRelationship);
    }

    public SharedStringsTable getSharedStringsTable() throws IOException {
        ArrayList parts = this.pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        return parts.isEmpty() ? null : new SharedStringsTable((PackagePart)parts.get(0));
    }

    public SharedStrings getSharedStrings(StreamingReader.Builder builder) throws IOException, SAXException {
        ArrayList parts = this.pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        return parts.isEmpty() ? null : (builder.useSstReadOnly() ? new ReadOnlySharedStringsTable((PackagePart)parts.get(0)) : new SharedStringsTable((PackagePart)parts.get(0)));
    }

    public StylesTable getStylesTable() throws IOException, InvalidFormatException {
        ArrayList parts = this.pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        StylesTable styles = new StylesTable((PackagePart)parts.get(0));
        parts = this.pkg.getPartsByContentType(XSSFRelation.THEME.getContentType());
        if (!parts.isEmpty()) {
            styles.setTheme(new ThemesTable((PackagePart)parts.get(0)));
        }
        return styles;
    }

    public OoxmlSheetIterator getSheetsData() throws IOException {
        return new OoxmlSheetIterator(this.workbookPart);
    }

    public class OoxmlSheetIterator
    extends XSSFReader.SheetIterator {
        OoxmlSheetIterator(PackagePart wb) throws IOException {
            super(wb);
        }

        protected Set<String> getSheetRelationships() {
            return OVERRIDE_WORKSHEET_RELS;
        }

        public Comments getSheetComments(StreamingReader.Builder builder) {
            PackagePart sheetPkg = this.getSheetPart();
            try {
                PackageRelationshipCollection commentsList = sheetPkg.getRelationshipsByType(XSSFRelation.SHEET_COMMENTS.getRelation());
                if (commentsList.size() == 0 && OoxmlReader.this.strictOoxmlChecksNeeded) {
                    commentsList = sheetPkg.getRelationshipsByType(OoxmlReader.PURL_COMMENTS_RELATIONSHIP_URL);
                }
                if (commentsList.size() > 0) {
                    PackageRelationship comments = commentsList.getRelationship(0);
                    PackagePartName commentsName = PackagingURIHelper.createPartName((URI)comments.getTargetURI());
                    PackagePart commentsPart = sheetPkg.getPackage().getPart(commentsName);
                    return this.parseComments(builder, commentsPart);
                }
            }
            catch (IOException | XMLStreamException | InvalidFormatException e) {
                LOGGER.warn("issue getting sheet comments", e);
                return null;
            }
            return null;
        }

        public List<XSSFShape> getShapes() {
            PackagePart sheetPkg = this.getSheetPart();
            LinkedList<XSSFShape> shapes = new LinkedList<XSSFShape>();
            try {
                PackageRelationshipCollection drawingsList = sheetPkg.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation());
                if (drawingsList.size() == 0 && OoxmlReader.this.strictOoxmlChecksNeeded) {
                    drawingsList = sheetPkg.getRelationshipsByType(OoxmlReader.PURL_DRAWING_RELATIONSHIP_URL);
                }
                for (int i = 0; i < drawingsList.size(); ++i) {
                    PackageRelationship drawings = drawingsList.getRelationship(i);
                    PackagePartName drawingsName = PackagingURIHelper.createPartName((URI)drawings.getTargetURI());
                    PackagePart drawingsPart = sheetPkg.getPackage().getPart(drawingsName);
                    if (drawingsPart == null) {
                        LOGGER.warn("Missing drawing: {}. Skipping it.", (Object)drawingsName);
                        continue;
                    }
                    XSSFDrawing drawing = new XSSFDrawing(drawingsPart);
                    shapes.addAll(drawing.getShapes());
                }
            }
            catch (IOException | InvalidFormatException | XmlException e) {
                LOGGER.warn("issue getting shapes", e);
                return null;
            }
            return shapes;
        }

        private Comments parseComments(StreamingReader.Builder builder, PackagePart commentsPart) throws IOException, XMLStreamException, InvalidFormatException {
            if (builder.useCommentsTempFile()) {
                try (InputStream is = commentsPart.getInputStream();){
                    TempFileCommentsTable ct = new TempFileCommentsTable(builder.encryptCommentsTempFile(), builder.fullFormatRichText());
                    try {
                        ct.readFrom(is);
                    }
                    catch (IOException | RuntimeException e) {
                        ct.close();
                        throw e;
                    }
                    TempFileCommentsTable tempFileCommentsTable = ct;
                    return tempFileCommentsTable;
                }
            }
            if (OoxmlReader.this.strictOoxmlChecksNeeded) {
                return OoxmlStrictHelper.getCommentsTable(builder, commentsPart);
            }
            return new CommentsTable(commentsPart);
        }
    }
}

