/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.exceptions.NotSupportedException;
import com.github.pjfanning.xlsx.impl.StreamingCell;
import com.github.pjfanning.xlsx.impl.StreamingSheetReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class StreamingRow
implements Row {
    private final Sheet sheet;
    private final int rowIndex;
    private boolean isHidden;
    private TreeMap<Integer, Cell> cellMap = new TreeMap();
    private StreamingSheetReader streamingSheetReader;

    public StreamingRow(Sheet sheet, int rowIndex, boolean isHidden) {
        this.sheet = sheet;
        this.rowIndex = rowIndex;
        this.isHidden = isHidden;
    }

    void setStreamingSheetReader(StreamingSheetReader streamingSheetReader) {
        this.streamingSheetReader = streamingSheetReader;
    }

    public Map<Integer, Cell> getCellMap() {
        return this.cellMap;
    }

    public int getRowNum() {
        return this.rowIndex;
    }

    public Iterator<Cell> cellIterator() {
        return this.cellMap.values().iterator();
    }

    public Iterator<Cell> iterator() {
        return this.cellMap.values().iterator();
    }

    public Spliterator<Cell> spliterator() {
        return Spliterators.spliterator(this.cellMap.values(), 16);
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Cell getCell(int cellnum) {
        return this.cellMap.get(cellnum);
    }

    public short getLastCellNum() {
        return (short)(this.cellMap.isEmpty() ? -1 : this.cellMap.lastEntry().getValue().getColumnIndex() + 1);
    }

    public boolean getZeroHeight() {
        return this.isHidden;
    }

    public int getPhysicalNumberOfCells() {
        return this.cellMap.size();
    }

    public short getFirstCellNum() {
        if (this.cellMap.isEmpty()) {
            return -1;
        }
        return this.cellMap.firstKey().shortValue();
    }

    public Cell getCell(int cellnum, Row.MissingCellPolicy policy) {
        StreamingCell cell = (StreamingCell)this.cellMap.get(cellnum);
        if (policy == Row.MissingCellPolicy.CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                boolean use1904Dates = this.streamingSheetReader != null && this.streamingSheetReader.isUse1904Dates();
                return new StreamingCell(this.sheet, cellnum, this, use1904Dates);
            }
        } else if (policy == Row.MissingCellPolicy.RETURN_BLANK_AS_NULL && (cell == null || cell.getCellType() == CellType.BLANK)) {
            return null;
        }
        return cell;
    }

    public Cell createCell(int column) {
        throw new NotSupportedException();
    }

    public Cell createCell(int i, CellType cellType) {
        throw new NotSupportedException();
    }

    public void removeCell(Cell cell) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setRowNum(int rowNum) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setHeight(short height) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setZeroHeight(boolean zHeight) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setHeightInPoints(float height) {
        throw new NotSupportedException("update operations are not supported");
    }

    public short getHeight() {
        throw new NotSupportedException();
    }

    public float getHeightInPoints() {
        throw new NotSupportedException();
    }

    public boolean isFormatted() {
        throw new NotSupportedException();
    }

    public CellStyle getRowStyle() {
        throw new NotSupportedException();
    }

    public void setRowStyle(CellStyle style) {
        throw new NotSupportedException("update operations are not supported");
    }

    public int getOutlineLevel() {
        throw new NotSupportedException();
    }

    public void shiftCellsRight(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void shiftCellsLeft(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
        throw new NotSupportedException("update operations are not supported");
    }
}

