/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.poi.xssf.streaming.MapBackedSharedStringsTable;
import com.github.pjfanning.poi.xssf.streaming.TempFileSharedStringsTable;
import com.github.pjfanning.xlsx.SharedStringsImplementationType;
import com.github.pjfanning.xlsx.StreamingReader;
import com.github.pjfanning.xlsx.XmlUtils;
import com.github.pjfanning.xlsx.exceptions.NotSupportedException;
import com.github.pjfanning.xlsx.exceptions.OpenException;
import com.github.pjfanning.xlsx.exceptions.ParseException;
import com.github.pjfanning.xlsx.exceptions.ReadException;
import com.github.pjfanning.xlsx.impl.StreamingSheet;
import com.github.pjfanning.xlsx.impl.StreamingSheetReader;
import com.github.pjfanning.xlsx.impl.StreamingWorkbook;
import com.github.pjfanning.xlsx.impl.TempFileUtil;
import com.github.pjfanning.xlsx.impl.WorkbookUtil;
import com.github.pjfanning.xlsx.impl.ooxml.OoxmlReader;
import com.github.pjfanning.xlsx.impl.ooxml.OoxmlStrictHelper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Date1904Support;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StreamingWorkbookReader
implements Iterable<Sheet>,
Date1904Support,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamingWorkbookReader.class);
    private static XMLInputFactory xmlInputFactory;
    private final List<StreamingSheet> sheets;
    private final List<Map<String, String>> sheetProperties = new ArrayList<Map<String, String>>();
    private final Map<String, List<XSSFShape>> shapeMap = new HashMap<String, List<XSSFShape>>();
    private final StreamingReader.Builder builder;
    private File tmp;
    private OPCPackage pkg;
    private SharedStrings sst;
    private boolean use1904Dates = false;
    private StreamingWorkbook workbook = null;
    private POIXMLProperties.CoreProperties coreProperties = null;

    public StreamingWorkbookReader(StreamingReader.Builder builder) {
        this.sheets = new ArrayList<StreamingSheet>();
        this.builder = builder;
    }

    public void init(InputStream is) {
        if (this.builder.avoidTempFiles()) {
            try {
                if (this.builder.getPassword() != null) {
                    POIFSFileSystem poifs = new POIFSFileSystem(is);
                    this.pkg = this.decryptWorkbook(poifs);
                } else {
                    this.pkg = OPCPackage.open((InputStream)is);
                }
                this.loadPackage(this.pkg);
            }
            catch (SAXException e) {
                IOUtils.closeQuietly((Closeable)this.pkg);
                throw new ParseException("Failed to parse stream", e);
            }
            catch (IOException e) {
                IOUtils.closeQuietly((Closeable)this.pkg);
                throw new OpenException("Failed to open stream", e);
            }
            catch (XMLStreamException | OpenXML4JException e) {
                IOUtils.closeQuietly((Closeable)this.pkg);
                throw new ReadException("Unable to read workbook", (Exception)e);
            }
            catch (GeneralSecurityException e) {
                IOUtils.closeQuietly((Closeable)this.pkg);
                throw new ReadException("Unable to read workbook - Decryption failed", e);
            }
        }
        File f = null;
        try {
            f = TempFileUtil.writeInputStreamToFile(is, this.builder.getBufferSize());
            if (log.isDebugEnabled()) {
                log.debug("Created temp file [{}]", (Object)f.getAbsolutePath());
            }
            this.init(f);
            this.tmp = f;
        }
        catch (IOException e) {
            if (f != null && !f.delete()) {
                log.debug("failed to delete temp file");
            }
            throw new ReadException("Unable to read input stream", e);
        }
        catch (RuntimeException e) {
            if (f != null && !f.delete()) {
                log.debug("failed to delete temp file");
            }
            throw e;
        }
    }

    public void init(File f) {
        try {
            if (this.builder.getPassword() != null) {
                POIFSFileSystem poifs = new POIFSFileSystem(f);
                this.pkg = this.decryptWorkbook(poifs);
            } else {
                this.pkg = OPCPackage.open((File)f);
            }
            this.loadPackage(this.pkg);
        }
        catch (SAXException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new ParseException("Failed to parse file", e);
        }
        catch (IOException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new OpenException("Failed to open file", e);
        }
        catch (XMLStreamException | OpenXML4JException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new ReadException("Unable to read workbook", (Exception)e);
        }
        catch (GeneralSecurityException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new ReadException("Unable to read workbook - Decryption failed", e);
        }
    }

    private OPCPackage decryptWorkbook(POIFSFileSystem poifs) throws IOException, GeneralSecurityException, InvalidFormatException {
        EncryptionInfo info = new EncryptionInfo(poifs);
        Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
        d.verifyPassword(this.builder.getPassword());
        return OPCPackage.open((InputStream)d.getDataStream(poifs));
    }

    private void loadPackage(OPCPackage pkg) throws IOException, OpenXML4JException, SAXException, XMLStreamException {
        boolean strictFormat = pkg.isStrictOoxmlFormat();
        OoxmlReader reader = new OoxmlReader(this, pkg, strictFormat);
        if (strictFormat) {
            log.info("file is in strict OOXML format");
        }
        if (this.builder.getSharedStringsImplementationType() == SharedStringsImplementationType.TEMP_FILE_BACKED) {
            log.info("Created sst cache file");
            this.sst = new TempFileSharedStringsTable(pkg, this.builder.encryptSstTempFile(), this.builder.fullFormatRichText());
        } else {
            this.sst = this.builder.getSharedStringsImplementationType() == SharedStringsImplementationType.CUSTOM_MAP_BACKED ? new MapBackedSharedStringsTable(pkg, this.builder.fullFormatRichText()) : (strictFormat ? OoxmlStrictHelper.getSharedStringsTable(this.builder, pkg) : reader.getSharedStrings(this.builder));
        }
        if (this.builder.readCoreProperties()) {
            try {
                POIXMLProperties xmlProperties = new POIXMLProperties(pkg);
                this.coreProperties = xmlProperties.getCoreProperties();
            }
            catch (Exception e) {
                log.warn("Failed to read coreProperties", (Throwable)e);
            }
        }
        StylesTable styles = null;
        if (this.builder.readStyles()) {
            if (strictFormat) {
                ThemesTable themesTable = OoxmlStrictHelper.getThemesTable(this.builder, pkg);
                styles = OoxmlStrictHelper.getStylesTable(this.builder, pkg);
                styles.setTheme(themesTable);
            } else {
                styles = reader.getStylesTable();
            }
        }
        Document workbookDoc = XmlUtils.readDocument(reader.getWorkbookData());
        this.use1904Dates = WorkbookUtil.use1904Dates(workbookDoc);
        this.loadSheets(workbookDoc, reader, this.sst, styles);
    }

    void setWorkbook(StreamingWorkbook workbook) {
        this.workbook = workbook;
        workbook.setCoreProperties(this.coreProperties);
    }

    Workbook getWorkbook() {
        return this.workbook;
    }

    private void loadSheets(Document workbookDoc, OoxmlReader reader, SharedStrings sst, StylesTable stylesTable) throws IOException, XMLStreamException {
        this.lookupSheetNames(workbookDoc);
        OoxmlReader.OoxmlSheetIterator iter = reader.getSheetsData();
        LinkedHashMap<PackagePart, InputStream> sheetStreams = new LinkedHashMap<PackagePart, InputStream>();
        HashMap<PackagePart, Comments> sheetComments = new HashMap<PackagePart, Comments>();
        while (iter.hasNext()) {
            InputStream is = iter.next();
            if (this.builder.readShapes()) {
                this.shapeMap.put(iter.getSheetName(), iter.getShapes());
            }
            PackagePart part = iter.getSheetPart();
            sheetStreams.put(part, is);
            if (!this.builder.readComments()) continue;
            sheetComments.put(part, iter.getSheetComments(this.builder));
        }
        int i = 0;
        for (Map.Entry entry : sheetStreams.entrySet()) {
            XMLEventReader parser = StreamingWorkbookReader.getXmlInputFactory().createXMLEventReader((InputStream)entry.getValue());
            this.sheets.add(new StreamingSheet(this.sheetProperties.get(i++).get("name"), new StreamingSheetReader(this, (PackagePart)entry.getKey(), sst, stylesTable, (Comments)sheetComments.get(entry.getKey()), parser, this.use1904Dates, this.builder.getRowCacheSize())));
        }
    }

    private void lookupSheetNames(Document workbookDoc) {
        this.sheetProperties.clear();
        NodeList nl = XmlUtils.searchForNodeList(workbookDoc, "/ss:workbook/ss:sheets/ss:sheet");
        for (int i = 0; i < nl.getLength(); ++i) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("name", nl.item(i).getAttributes().getNamedItem("name").getTextContent());
            Node state = nl.item(i).getAttributes().getNamedItem("state");
            props.put("state", state == null ? "visible" : state.getTextContent());
            this.sheetProperties.add(props);
        }
    }

    List<StreamingSheet> getSheets() {
        return this.sheets;
    }

    public List<Map<String, String>> getSheetProperties() {
        return this.sheetProperties;
    }

    @Override
    public Iterator<Sheet> iterator() {
        return new StreamingSheetIterator(this.sheets.iterator());
    }

    @Override
    public Spliterator<Sheet> spliterator() {
        return Spliterators.spliterator(this.sheets, 16);
    }

    public boolean isDate1904() {
        return this.use1904Dates;
    }

    @Override
    public void close() throws IOException {
        try {
            for (StreamingSheet sheet : this.sheets) {
                sheet.getReader().close();
            }
            this.pkg.revert();
        }
        finally {
            if (this.tmp != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Deleting tmp file [{}]", (Object)this.tmp.getAbsolutePath());
                }
                if (!this.tmp.delete()) {
                    log.debug("Failed tp delete temp file");
                }
            }
            if (this.sst instanceof Closeable) {
                ((Closeable)this.sst).close();
            }
        }
    }

    StreamingReader.Builder getBuilder() {
        return this.builder;
    }

    OPCPackage getOPCPackage() {
        return this.pkg;
    }

    List<XSSFShape> getShapes(String sheetName) {
        return this.shapeMap.get(sheetName);
    }

    private static XMLInputFactory getXmlInputFactory() {
        if (xmlInputFactory == null) {
            try {
                xmlInputFactory = XMLHelper.newXMLInputFactory();
            }
            catch (Exception e) {
                log.error("Issue creating XMLInputFactory", (Throwable)e);
                throw e;
            }
        }
        return xmlInputFactory;
    }

    static class StreamingSheetIterator
    implements Iterator<Sheet> {
        private final Iterator<StreamingSheet> iterator;

        public StreamingSheetIterator(Iterator<StreamingSheet> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Sheet next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

