/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.poi.xssf.streaming.SharedStringsTableBase;
import com.github.pjfanning.xlsx.SharedFormula;
import com.github.pjfanning.xlsx.StreamingReader;
import com.github.pjfanning.xlsx.XmlUtils;
import com.github.pjfanning.xlsx.exceptions.CloseException;
import com.github.pjfanning.xlsx.exceptions.NotSupportedException;
import com.github.pjfanning.xlsx.exceptions.ParseException;
import com.github.pjfanning.xlsx.impl.CurrentRowEvaluationWorkbook;
import com.github.pjfanning.xlsx.impl.DateTimeUtil;
import com.github.pjfanning.xlsx.impl.RichTextStringSupplier;
import com.github.pjfanning.xlsx.impl.StreamingCell;
import com.github.pjfanning.xlsx.impl.StreamingRow;
import com.github.pjfanning.xlsx.impl.StreamingSheet;
import com.github.pjfanning.xlsx.impl.StreamingWorkbookReader;
import com.github.pjfanning.xlsx.impl.StringSupplier;
import com.github.pjfanning.xlsx.impl.Supplier;
import com.github.pjfanning.xlsx.impl.XlsxHyperlink;
import com.github.pjfanning.xlsx.impl.ooxml.HyperlinkData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSheetReader
implements Iterable<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingSheetReader.class);
    private static final QName QNAME_HIDDEN = QName.valueOf("hidden");
    private static final QName QNAME_HT = QName.valueOf("ht");
    private static final QName QNAME_MAX = QName.valueOf("max");
    private static final QName QNAME_MIN = QName.valueOf("min");
    private static final QName QNAME_R = QName.valueOf("r");
    private static final QName QNAME_REF = QName.valueOf("ref");
    private static final QName QNAME_S = QName.valueOf("s");
    private static final QName QNAME_T = QName.valueOf("t");
    private static final QName QNAME_WIDTH = QName.valueOf("width");
    private final StreamingWorkbookReader streamingWorkbookReader;
    private final PackagePart packagePart;
    private final SharedStrings sst;
    private final StylesTable stylesTable;
    private final Comments commentsTable;
    private final XMLEventReader parser;
    private final DataFormatter dataFormatter = new DataFormatter();
    private final Set<Integer> hiddenColumns = new HashSet<Integer>();
    private final Map<Integer, Float> columnWidths = new HashMap<Integer, Float>();
    private final List<CellRangeAddress> mergedCells = new ArrayList<CellRangeAddress>();
    private final List<HyperlinkData> hyperlinks = new ArrayList<HyperlinkData>();
    private List<XlsxHyperlink> xlsxHyperlinks;
    private Map<String, SharedFormula> sharedFormulaMap;
    private int firstRowNum = 0;
    private int lastRowNum;
    private int currentRowNum;
    private int firstColNum = 0;
    private int currentColNum;
    private int rowCacheSize;
    private float defaultRowHeight = 0.0f;
    private int baseColWidth = 8;
    private List<Row> rowCache = new ArrayList<Row>();
    private Iterator<Row> rowCacheIterator;
    private StringBuilder contentBuilder = new StringBuilder(64);
    private StringBuilder formulaBuilder = new StringBuilder(64);
    private StreamingSheet sheet;
    private StreamingRow currentRow;
    private StreamingCell currentCell;
    private CellAddress activeCell;
    private boolean use1904Dates;
    private boolean insideCharElement = false;
    private boolean insideFormulaElement = false;
    private boolean insideIS = false;
    private PaneInformation pane;

    StreamingSheetReader(StreamingWorkbookReader streamingWorkbookReader, PackagePart packagePart, SharedStrings sst, StylesTable stylesTable, Comments commentsTable, XMLEventReader parser, boolean use1904Dates, int rowCacheSize) {
        this.streamingWorkbookReader = streamingWorkbookReader;
        this.packagePart = packagePart;
        this.sst = sst;
        this.stylesTable = stylesTable;
        this.commentsTable = commentsTable;
        this.parser = parser;
        this.use1904Dates = use1904Dates;
        this.rowCacheSize = rowCacheSize;
    }

    void setSheet(StreamingSheet sheet) {
        this.sheet = sheet;
    }

    Map<String, SharedFormula> getSharedFormulaMap() {
        if (this.getBuilder().readSharedFormulas()) {
            if (this.sharedFormulaMap == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.sharedFormulaMap);
        }
        throw new IllegalStateException("The reading of shared formulas has been disabled. Enable using StreamingReader.Builder.");
    }

    void addSharedFormula(String siValue, SharedFormula sharedFormula) {
        if (this.getBuilder().readSharedFormulas()) {
            if (this.sharedFormulaMap == null) {
                this.sharedFormulaMap = new HashMap<String, SharedFormula>();
            }
            this.sharedFormulaMap.put(siValue, sharedFormula);
        }
    }

    SharedFormula removeSharedFormula(String siValue) {
        if (this.sharedFormulaMap != null) {
            return this.sharedFormulaMap.remove(siValue);
        }
        return null;
    }

    boolean isUse1904Dates() {
        return this.use1904Dates;
    }

    float getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    int getBaseColWidth() {
        return this.baseColWidth;
    }

    private boolean getRow() {
        try {
            this.rowCache.clear();
            while (this.rowCache.size() < this.rowCacheSize && this.parser.hasNext()) {
                this.handleEvent(this.parser.nextEvent());
            }
            this.rowCacheIterator = this.rowCache.iterator();
            return this.rowCacheIterator.hasNext();
        }
        catch (XMLStreamException e) {
            throw new ParseException("Error reading XML stream", e);
        }
    }

    private void handleEvent(XMLEvent event) {
        if (event.getEventType() == 4) {
            if (this.insideCharElement) {
                this.contentBuilder.append(event.asCharacters().getData());
            }
            if (this.insideFormulaElement) {
                this.formulaBuilder.append(event.asCharacters().getData());
            }
        } else if (event.getEventType() == 1 && this.isSpreadsheetTag(event.asStartElement().getName())) {
            StartElement startElement = event.asStartElement();
            String tagLocalName = startElement.getName().getLocalPart();
            if ("row".equals(tagLocalName)) {
                Attribute rowNumAttr = startElement.getAttributeByName(QNAME_R);
                int rowIndex = this.currentRowNum;
                if (rowNumAttr != null) {
                    this.currentRowNum = rowIndex = Integer.parseInt(rowNumAttr.getValue()) - 1;
                }
                Attribute isHiddenAttr = startElement.getAttributeByName(QNAME_HIDDEN);
                Attribute htAttr = startElement.getAttributeByName(QNAME_HT);
                float height = this.getDefaultRowHeight();
                if (htAttr != null) {
                    try {
                        height = Float.parseFloat(htAttr.getValue());
                    }
                    catch (Exception e) {
                        LOG.warn("unable to parse row {} height {}", (Object)rowIndex, (Object)htAttr.getValue());
                    }
                }
                boolean isHidden = isHiddenAttr != null && XmlUtils.evaluateBoolean(isHiddenAttr.getValue());
                this.currentRow = new StreamingRow(this.sheet, rowIndex, isHidden);
                this.currentRow.setStreamingSheetReader(this);
                this.currentRow.setHeight(height);
                this.currentColNum = this.firstColNum;
            } else if ("col".equals(tagLocalName)) {
                boolean isHidden;
                Attribute isHiddenAttr = startElement.getAttributeByName(QNAME_HIDDEN);
                Attribute widthAttr = startElement.getAttributeByName(QNAME_WIDTH);
                float width = -1.0f;
                if (widthAttr != null) {
                    try {
                        width = Float.parseFloat(widthAttr.getValue());
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to parse column width {}", (Object)Float.valueOf(width));
                    }
                }
                boolean bl = isHidden = isHiddenAttr != null && XmlUtils.evaluateBoolean(isHiddenAttr.getValue());
                if (isHidden || width >= 0.0f) {
                    Attribute minAttr = startElement.getAttributeByName(QNAME_MIN);
                    Attribute maxAttr = startElement.getAttributeByName(QNAME_MAX);
                    int min = Integer.parseInt(minAttr.getValue()) - 1;
                    int max = Integer.parseInt(maxAttr.getValue()) - 1;
                    for (int columnIndex = min; columnIndex <= max; ++columnIndex) {
                        if (isHidden) {
                            this.hiddenColumns.add(columnIndex);
                        }
                        if (!(width >= 0.0f)) continue;
                        this.columnWidths.put(columnIndex, Float.valueOf(width));
                    }
                }
            } else if ("c".equals(tagLocalName)) {
                Attribute ref = startElement.getAttributeByName(QNAME_R);
                if (ref != null) {
                    CellAddress cellAddress = new CellAddress(ref.getValue());
                    this.currentColNum = cellAddress.getColumn();
                    this.currentCell = this.currentRow.getRowNum() == this.currentRowNum ? new StreamingCell((Sheet)this.sheet, this.currentColNum, this.currentRow, this.use1904Dates) : new StreamingCell((Sheet)this.sheet, this.currentColNum, cellAddress.getRow(), this.use1904Dates);
                } else {
                    this.currentCell = this.currentRow != null ? new StreamingCell((Sheet)this.sheet, this.currentColNum, this.currentRow, this.use1904Dates) : new StreamingCell((Sheet)this.sheet, this.currentColNum, this.currentRowNum, this.use1904Dates);
                }
                this.setFormatString(startElement, this.currentCell);
                Attribute type = startElement.getAttributeByName(QNAME_T);
                if (type != null) {
                    this.currentCell.setType(type.getValue());
                } else {
                    this.currentCell.setType("n");
                }
                if (this.stylesTable != null) {
                    Attribute style = startElement.getAttributeByName(QNAME_S);
                    if (style != null) {
                        String indexStr = style.getValue();
                        try {
                            int index = Integer.parseInt(indexStr);
                            this.currentCell.setCellStyle((CellStyle)this.stylesTable.getStyleAt(index));
                        }
                        catch (NumberFormatException nfe) {
                            LOG.warn("Ignoring invalid style index {}", (Object)indexStr);
                        }
                    } else {
                        this.currentCell.setCellStyle((CellStyle)this.stylesTable.getStyleAt(0));
                    }
                }
            } else if ("pane".equals(tagLocalName)) {
                this.parsePane(startElement);
            } else if ("v".equals(tagLocalName) || "t".equals(tagLocalName)) {
                this.insideCharElement = true;
            } else if ("is".equals(tagLocalName)) {
                this.insideIS = true;
            } else if ("dimension".equals(tagLocalName)) {
                String ref;
                Attribute refAttr = startElement.getAttributeByName(QNAME_REF);
                String string = ref = refAttr != null ? refAttr.getValue() : null;
                if (ref != null) {
                    int colonPos;
                    for (int i = ref.length() - 1; i >= 0; --i) {
                        if (Character.isDigit(ref.charAt(i))) continue;
                        try {
                            this.lastRowNum = Integer.parseInt(ref.substring(i + 1)) - 1;
                        }
                        catch (NumberFormatException indexStr) {}
                        break;
                    }
                    if ((colonPos = ref.indexOf(58)) > 0) {
                        String firstPart = ref.substring(0, colonPos);
                        try {
                            CellReference cellReference = new CellReference(firstPart);
                            this.firstRowNum = cellReference.getRow();
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to parse cell reference {}", (Object)firstPart);
                        }
                    }
                    for (int i = 0; i < ref.length(); ++i) {
                        if (Character.isAlphabetic(ref.charAt(i))) continue;
                        this.firstColNum = CellReference.convertColStringToIndex((String)ref.substring(0, i));
                        break;
                    }
                }
            } else if ("f".equals(tagLocalName)) {
                this.insideFormulaElement = true;
                if (this.currentCell != null) {
                    Attribute siAttr;
                    this.currentCell.setFormulaType(true);
                    Attribute tAttr = startElement.getAttributeByName(new QName("t"));
                    if (tAttr != null && tAttr.getValue().equals("shared")) {
                        this.currentCell.setSharedFormula(true);
                    }
                    if ((siAttr = startElement.getAttributeByName(new QName("si"))) != null) {
                        this.currentCell.setFormulaSI(siAttr.getValue());
                    }
                }
            } else if ("mergeCell".equals(tagLocalName)) {
                this.parseMergeCell(startElement);
            } else if ("selection".equals(tagLocalName)) {
                Attribute activeCellAttr = startElement.getAttributeByName(QName.valueOf("activeCell"));
                if (activeCellAttr != null) {
                    String activeCellRef = this.getAttributeValue(activeCellAttr);
                    try {
                        this.activeCell = new CellAddress(activeCellRef);
                    }
                    catch (Exception e) {
                        LOG.warn("unable to parse active cell reference {}", (Object)activeCellRef);
                    }
                }
            } else if ("hyperlink".equals(tagLocalName)) {
                this.parseHyperlink(startElement);
            } else if ("sheetFormatPr".equals(tagLocalName)) {
                this.parseSheetFormatPr(startElement);
            }
            if (!this.insideIS) {
                this.contentBuilder.setLength(0);
            }
            this.formulaBuilder.setLength(0);
        } else if (event.getEventType() == 2 && this.isSpreadsheetTag(event.asEndElement().getName())) {
            EndElement endElement = event.asEndElement();
            String tagLocalName = endElement.getName().getLocalPart();
            if ("v".equals(tagLocalName) || "t".equals(tagLocalName)) {
                this.insideCharElement = false;
                Supplier formattedContentSupplier = this.formattedContents();
                this.currentCell.setRawContents(this.unformattedContents(formattedContentSupplier));
                this.currentCell.setContentSupplier(formattedContentSupplier);
            } else if ("row".equals(tagLocalName) && this.currentRow != null) {
                this.rowCache.add(this.currentRow);
                ++this.currentRowNum;
            } else if ("c".equals(tagLocalName)) {
                if (this.currentRow == null) {
                    CellAddress cellAddress = this.currentCell == null ? null : this.currentCell.getAddress();
                    LOG.warn("failed to add cell {} to cell map because currentRow is null", (Object)cellAddress);
                } else {
                    this.currentRow.getCellMap().put(this.currentCell.getColumnIndex(), this.currentCell);
                }
                this.currentCell = null;
                ++this.currentColNum;
            } else if ("is".equals(tagLocalName)) {
                this.insideIS = false;
            } else if ("f".equals(tagLocalName)) {
                this.insideFormulaElement = false;
                if (this.currentCell != null) {
                    String formula = this.formulaBuilder.toString();
                    this.currentCell.setFormula(formula);
                    if (this.currentCell.isSharedFormula() && this.currentCell.getFormulaSI() != null && this.getBuilder().readSharedFormulas()) {
                        if (this.sharedFormulaMap == null) {
                            this.sharedFormulaMap = new HashMap<String, SharedFormula>();
                        }
                        if (!this.sharedFormulaMap.containsKey(this.currentCell.getFormulaSI()) && !formula.isEmpty()) {
                            this.sharedFormulaMap.put(this.currentCell.getFormulaSI(), new SharedFormula(this.currentCell.getAddress(), formula));
                        } else if (formula.isEmpty()) {
                            Workbook wb = this.getWorkbook();
                            if (wb != null) {
                                SharedFormula sf = this.sharedFormulaMap.get(this.currentCell.getFormulaSI());
                                if (sf == null) {
                                    LOG.warn("No SharedFormula found for si={}", (Object)this.currentCell.getFormulaSI());
                                } else {
                                    CurrentRowEvaluationWorkbook evaluationWorkbook = new CurrentRowEvaluationWorkbook(wb, this.currentRow);
                                    int sheetIndex = wb.getSheetIndex((Sheet)this.sheet);
                                    if (sheetIndex < 0) {
                                        LOG.warn("Failed to find correct sheet index; defaulting to zero");
                                        sheetIndex = 0;
                                    }
                                    try {
                                        Ptg[] ptgs = FormulaParser.parse((String)sf.getFormula(), (FormulaParsingWorkbook)evaluationWorkbook, (FormulaType)FormulaType.CELL, (int)sheetIndex, (int)this.currentRow.getRowNum());
                                        String shiftedFmla = null;
                                        int rowsToMove = this.currentRowNum - sf.getCellAddress().getRow();
                                        FormulaShifter formulaShifter = FormulaShifter.createForRowShift((int)sheetIndex, (String)this.sheet.getSheetName(), (int)0, (int)SpreadsheetVersion.EXCEL2007.getLastRowIndex(), (int)rowsToMove, (SpreadsheetVersion)SpreadsheetVersion.EXCEL2007);
                                        if (formulaShifter.adjustFormula(ptgs, sheetIndex)) {
                                            shiftedFmla = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)evaluationWorkbook, (Ptg[])ptgs);
                                        }
                                        LOG.debug("cell {} should have formula {} based on shared formula {} (rowsToMove={})", new Object[]{this.currentCell.getAddress(), shiftedFmla, sf.getFormula(), rowsToMove});
                                        this.currentCell.setFormula(shiftedFmla);
                                    }
                                    catch (Exception e) {
                                        LOG.warn("cell {} should has a shared formula but excel-streaming-reader has an issue parsing it - will ignore the formula", (Object)this.currentCell.getAddress(), (Object)e);
                                    }
                                }
                            }
                        } else {
                            LOG.error("No eval workbook found");
                        }
                    }
                }
            }
        }
    }

    private void parseHyperlink(StartElement startElement) {
        String id = null;
        Iterator<Attribute> attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            Attribute att = attributeIterator.next();
            QName qn = att.getName();
            if (!"id".equals(qn.getLocalPart()) || !qn.getNamespaceURI().endsWith("relationships")) continue;
            id = att.getValue();
        }
        Attribute ref = startElement.getAttributeByName(QNAME_REF);
        Attribute location = startElement.getAttributeByName(QName.valueOf("location"));
        Attribute display = startElement.getAttributeByName(QName.valueOf("display"));
        Attribute tooltip = startElement.getAttributeByName(QName.valueOf("tooltip"));
        this.hyperlinks.add(new HyperlinkData(id, this.getAttributeValue(ref), this.getAttributeValue(location), this.getAttributeValue(display), this.getAttributeValue(tooltip)));
    }

    private void parseMergeCell(StartElement startElement) {
        Attribute ref = startElement.getAttributeByName(QNAME_REF);
        if (ref != null) {
            this.mergedCells.add(CellRangeAddress.valueOf((String)ref.getValue()));
        }
    }

    private void parsePane(StartElement startElement) {
        Attribute stateAtt = startElement.getAttributeByName(QName.valueOf("state"));
        Attribute activePaneAtt = startElement.getAttributeByName(QName.valueOf("activePane"));
        Attribute topLeftCellAtt = startElement.getAttributeByName(QName.valueOf("topLeftCell"));
        Float xValue = this.parseAttValueAsFloat("xSplit", startElement);
        short x = xValue == null ? (short)0 : xValue.shortValue();
        Float yValue = this.parseAttValueAsFloat("ySplit", startElement);
        short y = yValue == null ? (short)0 : yValue.shortValue();
        short row = 0;
        short col = 0;
        if (topLeftCellAtt != null) {
            try {
                CellReference cellRef = new CellReference(topLeftCellAtt.getValue());
                row = (short)cellRef.getRow();
                col = cellRef.getCol();
            }
            catch (Exception e) {
                LOG.warn("unable to parse topLeftCell {}", (Object)topLeftCellAtt.getValue());
            }
        }
        boolean frozen = stateAtt != null && "frozen".equals(stateAtt.getValue());
        byte active = 0;
        if (activePaneAtt != null) {
            try {
                STPane.Enum stPaneEnum = STPane.Enum.forString((String)activePaneAtt.getValue());
                active = (byte)(stPaneEnum.intValue() - 1);
            }
            catch (Exception e) {
                LOG.warn("unable to parse activePane {}", (Object)activePaneAtt.getValue());
            }
        }
        this.pane = new PaneInformation(x, y, row, col, active, frozen);
    }

    private Float parseAttValueAsFloat(String name, StartElement startElement) {
        Attribute att = startElement.getAttributeByName(QName.valueOf(name));
        if (att != null) {
            try {
                return Float.valueOf(Float.parseFloat(att.getValue()));
            }
            catch (Exception e) {
                LOG.warn("unable to parse {} {}", (Object)name, (Object)att.getValue());
            }
        }
        return null;
    }

    private void parseSheetFormatPr(StartElement startElement) {
        Attribute baseColWidthAtt;
        Attribute defaultRowHeightAtt = startElement.getAttributeByName(QName.valueOf("defaultRowHeight"));
        if (defaultRowHeightAtt != null) {
            try {
                this.defaultRowHeight = Float.parseFloat(defaultRowHeightAtt.getValue());
            }
            catch (Exception e) {
                LOG.warn("unable to parse defaultRowHeight {}", (Object)defaultRowHeightAtt.getValue());
            }
        }
        if ((baseColWidthAtt = startElement.getAttributeByName(QName.valueOf("baseColWidth"))) != null) {
            try {
                this.baseColWidth = Integer.parseInt(baseColWidthAtt.getValue());
            }
            catch (Exception e) {
                LOG.warn("unable to parse baseColWidth {}", (Object)baseColWidthAtt.getValue());
            }
        }
    }

    private boolean isSpreadsheetTag(QName name) {
        return name.getNamespaceURI() != null && name.getNamespaceURI().endsWith("/main");
    }

    boolean isColumnHidden(int columnIndex) {
        if (this.rowCacheIterator == null) {
            this.getRow();
        }
        return this.hiddenColumns.contains(columnIndex);
    }

    float getColumnWidth(int columnIndex) {
        Float width;
        if (this.rowCacheIterator == null) {
            this.getRow();
        }
        return (width = this.columnWidths.get(columnIndex)) == null ? (float)this.getBaseColWidth() : width.floatValue();
    }

    int getFirstRowNum() {
        if (this.rowCacheIterator == null) {
            this.getRow();
        }
        return this.firstRowNum;
    }

    int getLastRowNum() {
        if (this.rowCacheIterator == null) {
            this.getRow();
        }
        return this.lastRowNum;
    }

    void setFormatString(StartElement startElement, StreamingCell cell) {
        Attribute cellStyle = startElement.getAttributeByName(new QName("s"));
        String cellStyleString = cellStyle != null ? cellStyle.getValue() : null;
        XSSFCellStyle style = null;
        if (this.stylesTable != null) {
            if (cellStyleString != null) {
                style = this.stylesTable.getStyleAt(Integer.parseInt(cellStyleString));
            } else if (this.stylesTable.getNumCellStyles() > 0) {
                style = this.stylesTable.getStyleAt(0);
            }
        }
        if (style != null) {
            cell.setNumericFormatIndex(style.getDataFormat());
            String formatString = style.getDataFormatString();
            if (formatString != null) {
                cell.setNumericFormat(formatString);
            } else {
                cell.setNumericFormat(BuiltinFormats.getBuiltinFormat((int)cell.getNumericFormatIndex().shortValue()));
            }
        } else {
            cell.setNumericFormatIndex(null);
            cell.setNumericFormat(null);
        }
    }

    CellAddress getActiveCell() {
        return this.activeCell;
    }

    PaneInformation getPane() {
        if (this.rowCacheIterator == null) {
            this.getRow();
        }
        return this.pane;
    }

    private Supplier formattedContents() {
        return this.getFormatterForType(this.currentCell.getType());
    }

    private Supplier getFormatterForType(String type) {
        String lastContents = this.contentBuilder.toString();
        switch (type) {
            case "s": {
                if (!lastContents.isEmpty()) {
                    int idx = Integer.parseInt(lastContents);
                    if (!this.getBuilder().fullFormatRichText() && this.sst instanceof SharedStringsTableBase) {
                        return new StringSupplier(((SharedStringsTableBase)this.sst).getString(idx));
                    }
                    return new RichTextStringSupplier(this.sst.getItemAt(idx));
                }
                return new StringSupplier(lastContents);
            }
            case "inlineStr": 
            case "str": {
                return new StringSupplier(lastContents);
            }
            case "e": {
                return new StringSupplier("ERROR:  " + lastContents);
            }
            case "n": {
                if (this.currentCell.getNumericFormat() != null && lastContents.length() > 0) {
                    final String currentLastContents = lastContents;
                    final short currentNumericFormatIndex = this.currentCell.getNumericFormatIndex();
                    final String currentNumericFormat = this.currentCell.getNumericFormat();
                    return new Supplier(){
                        String cachedContent;

                        @Override
                        public Object getContent() {
                            if (this.cachedContent == null) {
                                this.cachedContent = StreamingSheetReader.this.dataFormatter.formatRawCellContents(Double.parseDouble(currentLastContents), currentNumericFormatIndex, currentNumericFormat);
                            }
                            return this.cachedContent;
                        }
                    };
                }
                return new StringSupplier(lastContents);
            }
            case "d": {
                if (this.currentCell.getNumericFormat() != null && lastContents.length() > 0) {
                    final String currentLastContents = lastContents;
                    final short currentNumericFormatIndex = this.currentCell.getNumericFormatIndex();
                    final String currentNumericFormat = this.currentCell.getNumericFormat();
                    return new Supplier(){
                        String cachedContent;

                        @Override
                        public Object getContent() {
                            if (this.cachedContent == null) {
                                try {
                                    Double dv;
                                    try {
                                        LocalDateTime dt = DateTimeUtil.parseDateTime(currentLastContents);
                                        dv = DateUtil.getExcelDate((LocalDateTime)dt, (boolean)StreamingSheetReader.this.use1904Dates);
                                    }
                                    catch (Exception e) {
                                        dv = DateTimeUtil.convertTime(currentLastContents);
                                    }
                                    this.cachedContent = StreamingSheetReader.this.dataFormatter.formatRawCellContents(dv.doubleValue(), currentNumericFormatIndex, currentNumericFormat);
                                }
                                catch (Exception e) {
                                    LOG.warn("cannot format strict format date/time {}", (Object)currentLastContents);
                                    this.cachedContent = currentLastContents;
                                }
                            }
                            return this.cachedContent;
                        }
                    };
                }
                return new StringSupplier(lastContents);
            }
        }
        return new StringSupplier(lastContents);
    }

    private String unformattedContents(Supplier formattedContentSupplier) {
        String lastContents = this.contentBuilder.toString();
        switch (this.currentCell.getType()) {
            case "s": {
                Object formattedContent = formattedContentSupplier.getContent();
                if (formattedContent instanceof RichTextString) {
                    return ((RichTextString)formattedContent).getString();
                }
                if (formattedContent != null) {
                    return formattedContent.toString();
                }
                if (!lastContents.isEmpty()) {
                    int idx = Integer.parseInt(lastContents);
                    if (this.sst == null) {
                        throw new NullPointerException("sst is null");
                    }
                    if (this.sst instanceof SharedStringsTableBase) {
                        return ((SharedStringsTableBase)this.sst).getString(idx);
                    }
                    return this.sst.getItemAt(idx).getString();
                }
                return lastContents;
            }
            case "inlineStr": {
                return new XSSFRichTextString(lastContents).getString();
            }
        }
        return lastContents;
    }

    @Override
    public Iterator<Row> iterator() {
        return new StreamingRowIterator();
    }

    Comments getCellComments() {
        if (!this.streamingWorkbookReader.getBuilder().readComments()) {
            throw new IllegalStateException("getCellComments() only works if StreamingWorking.Builder setReadComments is set to true");
        }
        return this.commentsTable;
    }

    List<CellRangeAddress> getMergedCells() {
        return this.mergedCells;
    }

    XSSFDrawing getDrawingPatriarch() {
        Iterator<XSSFShape> shapesIter;
        List<XSSFShape> shapes;
        if (!this.streamingWorkbookReader.getBuilder().readShapes()) {
            throw new IllegalStateException("getDrawingPatriarch() only works if StreamingWorking.Builder setReadShapes is set to true");
        }
        if (this.sheet != null && (shapes = this.streamingWorkbookReader.getShapes(this.sheet.getSheetName())) != null && (shapesIter = shapes.iterator()).hasNext()) {
            return shapesIter.next().getDrawing();
        }
        return null;
    }

    public void close() {
        try {
            this.parser.close();
        }
        catch (XMLStreamException e) {
            throw new CloseException(e);
        }
    }

    StreamingReader.Builder getBuilder() {
        return this.streamingWorkbookReader.getBuilder();
    }

    Workbook getWorkbook() {
        return this.streamingWorkbookReader.getWorkbook();
    }

    List<XlsxHyperlink> getHyperlinks() {
        if (!this.getBuilder().readHyperlinks()) {
            throw new IllegalStateException("getHyperlinks() only works if StreamingWorking.Builder setReadHyperlinks is set to true");
        }
        this.initHyperlinks();
        return this.xlsxHyperlinks;
    }

    private String getAttributeValue(Attribute att) {
        return att == null ? null : att.getValue();
    }

    private void initHyperlinks() {
        if (this.xlsxHyperlinks == null || this.xlsxHyperlinks.isEmpty()) {
            ArrayList<XlsxHyperlink> links = new ArrayList<XlsxHyperlink>();
            try {
                PackageRelationshipCollection hyperRels = this.packagePart.getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
                for (HyperlinkData hyperlink : this.hyperlinks) {
                    PackageRelationship hyperRel = null;
                    if (hyperlink.getId() != null) {
                        hyperRel = hyperRels.getRelationshipByID(hyperlink.getId());
                    }
                    links.add(new XlsxHyperlink(hyperlink, hyperRel));
                }
            }
            catch (InvalidFormatException e) {
                throw new POIXMLException((Throwable)e);
            }
            this.xlsxHyperlinks = links;
        }
    }

    class StreamingRowIterator
    implements Iterator<Row> {
        public StreamingRowIterator() {
            if (StreamingSheetReader.this.rowCacheIterator == null && !this.hasNext()) {
                LOG.debug("there appear to be no rows");
            }
        }

        @Override
        public boolean hasNext() {
            return StreamingSheetReader.this.rowCacheIterator != null && StreamingSheetReader.this.rowCacheIterator.hasNext() || StreamingSheetReader.this.getRow();
        }

        @Override
        public Row next() {
            try {
                return (Row)StreamingSheetReader.this.rowCacheIterator.next();
            }
            catch (NoSuchElementException nsee) {
                if (this.hasNext()) {
                    return (Row)StreamingSheetReader.this.rowCacheIterator.next();
                }
                throw nsee;
            }
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

