/*   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.poi.xmlbeans;

/**
 * Describes a code-generated string enumeration
 * 
 * @see SchemaType#getStringEnumEntries
 */ 
public interface SchemaStringEnumEntry
{
    /**
     * The enumerated string value
     */ 
    public String getString();
    
    /**
     * An integer to represent this choice in the enumeration
     */ 
    public int getIntValue();
    
    /**
     * A capitalized name to use for the enumeration constant name
     */ 
    public String getEnumName();
}
