/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xmlbeans.impl.jam.internal.classrefs;

import org.apache.poi.xmlbeans.impl.jam.JClass;
import org.apache.poi.xmlbeans.impl.jam.JamClassLoader;
import org.apache.poi.xmlbeans.impl.jam.internal.classrefs.JClassRef;
import org.apache.poi.xmlbeans.impl.jam.internal.classrefs.JClassRefContext;

public class QualifiedJClassRef
implements JClassRef {
    private String mQualifiedClassname;
    private JamClassLoader mClassLoader;

    public static JClassRef create(JClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null clazz");
        }
        return new QualifiedJClassRef(clazz.getFieldDescriptor(), clazz.getClassLoader());
    }

    public static JClassRef create(String qcname, JClassRefContext ctx) {
        if (qcname == null) {
            throw new IllegalArgumentException("null qcname");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("null ctx");
        }
        return QualifiedJClassRef.create(qcname, ctx.getClassLoader());
    }

    public static JClassRef create(String qcname, JamClassLoader cl) {
        if (qcname == null) {
            throw new IllegalArgumentException("null qcname");
        }
        if (cl == null) {
            throw new IllegalArgumentException("null classloader");
        }
        return new QualifiedJClassRef(qcname, cl);
    }

    private QualifiedJClassRef(String qcname, JamClassLoader cl) {
        this.mClassLoader = cl;
        this.mQualifiedClassname = qcname;
    }

    public JClass getRefClass() {
        return this.mClassLoader.loadClass(this.mQualifiedClassname);
    }

    public String getQualifiedName() {
        return this.mQualifiedClassname;
    }

    public String toString() {
        return "(QualifiedJClassRef '" + this.mQualifiedClassname + "')";
    }
}

