/*
 * Decompiled with CFR 0.152.
 */
package com.github.platform.team.plugin.util;

import com.amazonaws.ClientConfiguration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;

public abstract class S3Utils {
    private static final String KEY_FORMAT = "%s%s";

    public static String getBucketName(Repository repository) {
        Objects.requireNonNull(repository, "repository must not be null");
        return repository.getHost();
    }

    public static String getBaseDirectory(Repository repository) {
        Objects.requireNonNull(repository, "repository must not be null");
        String basedir = StringUtils.substringAfter((String)repository.getBasedir(), (String)"/");
        return StringUtils.isNotBlank((CharSequence)basedir) ? StringUtils.appendIfMissing((String)basedir, (CharSequence)"/", (CharSequence[])new CharSequence[]{"/"}) : basedir;
    }

    public static ClientConfiguration getClientConfiguration(ProxyInfoProvider proxyInfoProvider) {
        ProxyInfo proxyInfo;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (proxyInfoProvider != null && (proxyInfo = proxyInfoProvider.getProxyInfo("s3")) != null) {
            clientConfiguration.withProxyHost(proxyInfo.getHost()).withProxyPort(proxyInfo.getPort());
        }
        return clientConfiguration;
    }
}

