/*
 * Decompiled with CFR 0.152.
 */
package com.github.pnowy.nc.spring;

import com.github.pnowy.nc.core.CriteriaResult;
import com.github.pnowy.nc.core.exceptions.InvalidDataAccessException;
import com.github.pnowy.nc.core.mappers.NativeObjectMapper;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class NativeBeanPropertyMapper<T>
implements NativeObjectMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(NativeBeanPropertyMapper.class);
    private Class<T> mappedClass;
    private boolean checkFullyPopulated = false;
    private boolean primitivesDefaultedForNullValue = false;
    private Map<String, PropertyDescriptor> mappedFields;

    public NativeBeanPropertyMapper() {
    }

    public NativeBeanPropertyMapper(Class<T> mappedClass) {
        this.initialize(mappedClass);
    }

    public NativeBeanPropertyMapper(Class<T> mappedClass, boolean checkFullyPopulated) {
        this.initialize(mappedClass);
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public void setMappedClass(Class<T> mappedClass) {
        if (this.mappedClass == null) {
            this.initialize(mappedClass);
        } else if (!this.mappedClass.equals(mappedClass)) {
            throw new InvalidDataAccessException("The mapped class can not be reassigned to map to " + mappedClass + " since it is already providing mapping for " + this.mappedClass);
        }
    }

    public final Class<T> getMappedClass() {
        return this.mappedClass;
    }

    public void setCheckFullyPopulated(boolean checkFullyPopulated) {
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public boolean isCheckFullyPopulated() {
        return this.checkFullyPopulated;
    }

    public void setPrimitivesDefaultedForNullValue(boolean primitivesDefaultedForNullValue) {
        this.primitivesDefaultedForNullValue = primitivesDefaultedForNullValue;
    }

    public boolean isPrimitivesDefaultedForNullValue() {
        return this.primitivesDefaultedForNullValue;
    }

    protected void initialize(Class<T> mappedClass) {
        PropertyDescriptor[] pds;
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : pds = BeanUtils.getPropertyDescriptors(mappedClass)) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(pd.getName(), pd);
        }
    }

    protected String underscoreName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.lowerCaseName(name.substring(0, 1)));
        for (int i = 1; i < name.length(); ++i) {
            String slc;
            String s = name.substring(i, i + 1);
            if (!s.equals(slc = this.lowerCaseName(s))) {
                result.append("_").append(slc);
                continue;
            }
            result.append(s);
        }
        return result.toString();
    }

    protected String lowerCaseName(String name) {
        return name.toLowerCase(Locale.US);
    }

    public T mapObject(CriteriaResult cr) {
        Assert.state((this.mappedClass != null ? 1 : 0) != 0, (String)"Mapped class was not specified");
        Object mappedObject = BeanUtils.instantiate(this.mappedClass);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)mappedObject);
        this.initBeanWrapper(bw);
        HashSet<String> populatedProperties = this.isCheckFullyPopulated() ? new HashSet<String>() : null;
        for (String beanProperty : this.mappedFields.keySet()) {
            PropertyDescriptor pd = this.mappedFields.get(beanProperty);
            if (pd == null) continue;
            try {
                String alias = pd.getName();
                Object value = null;
                if (cr.hasProperty(alias)) {
                    value = cr.getValue(pd.getName(), null);
                    if (populatedProperties != null) {
                        populatedProperties.add(pd.getName());
                    }
                }
                if (value == null && cr.hasProperty(alias = this.lowerCaseName(pd.getName()))) {
                    value = cr.getValue(this.lowerCaseName(alias));
                    if (populatedProperties != null) {
                        populatedProperties.add(pd.getName());
                    }
                }
                if (value == null && cr.hasProperty(alias = this.underscoreName(pd.getName()))) {
                    value = cr.getValue(alias);
                    if (populatedProperties != null) {
                        populatedProperties.add(pd.getName());
                    }
                }
                if (this.logger.isDebugEnabled() && cr.getRowNumber() == 0) {
                    this.logger.debug("Mapping column (retrieved by alias) '" + alias + "' to property '" + pd.getName() + "' of type " + pd.getPropertyType());
                }
                try {
                    bw.setPropertyValue(pd.getName(), value);
                }
                catch (TypeMismatchException ex) {
                    if (value == null && this.primitivesDefaultedForNullValue) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Intercepted TypeMismatchException for row " + cr.getRowNumber() + " and column '" + alias + "' with null value when setting property '" + pd.getName() + "' of type " + pd.getPropertyType() + " on object: " + mappedObject);
                        continue;
                    }
                    throw ex;
                }
            }
            catch (NotWritablePropertyException ex) {
                throw new DataRetrievalFailureException("Unable to map property " + pd.getName(), (Throwable)ex);
            }
        }
        if (populatedProperties != null && !populatedProperties.equals(this.mappedFields.keySet())) {
            throw new InvalidDataAccessApiUsageException("Given ResultSet does not contain all fields necessary to populate object of class [" + this.mappedClass + "]: " + this.mappedFields.keySet());
        }
        return (T)mappedObject;
    }

    protected void initBeanWrapper(BeanWrapper bw) {
    }

    public static <T> NativeBeanPropertyMapper<T> newInstance(Class<T> mappedClass) {
        return new NativeBeanPropertyMapper<T>(mappedClass);
    }
}

