/*
 * Decompiled with CFR 0.152.
 */
package com.github.pnowy.nc.spring;

import com.github.pnowy.nc.core.CriteriaResult;
import com.github.pnowy.nc.core.NativeCriteria;
import com.github.pnowy.nc.core.NativeExps;
import com.github.pnowy.nc.core.NativeQueryProvider;
import com.github.pnowy.nc.core.expressions.NativeExp;
import com.github.pnowy.nc.core.expressions.NativeOrderExp;
import com.github.pnowy.nc.core.mappers.NativeObjectMapper;
import com.github.pnowy.nc.spring.NativeBeanPropertyMapper;
import com.github.pnowy.nc.spring.OrderByApproach;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SpringNativeCriteria
extends NativeCriteria {
    public SpringNativeCriteria(NativeQueryProvider nativeProvider, String mainTable, String mainAlias) {
        super(nativeProvider, mainTable, mainAlias);
    }

    public <T> List<T> criteriaResult(NativeBeanPropertyMapper<T> mapper) {
        CriteriaResult criteriaResult = this.criteriaResult();
        LinkedList result = Lists.newLinkedList();
        while (criteriaResult.next()) {
            result.add(mapper.mapObject(criteriaResult));
        }
        return result;
    }

    public NativeCriteria setPageable(Pageable pageable) {
        return this.setPageable(pageable, OrderByApproach.DEFAULT);
    }

    public NativeCriteria setPageable(Pageable pageable, OrderByApproach orderByApproach) {
        if (pageable == null) {
            throw new NullPointerException("Pageable cannot be null!");
        }
        if (orderByApproach == null) {
            throw new NullPointerException("Order by approach cannot be null!");
        }
        if (pageable.getOffset() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The offset value must be in Integer range! We do not accept long range yet!");
        }
        this.setOffset((int)pageable.getOffset());
        this.setLimit(pageable.getPageSize());
        if (pageable.getSort() != null) {
            NativeOrderExp nativeOrder = NativeExps.order();
            for (Sort.Order sort : pageable.getSort()) {
                nativeOrder.add(orderByApproach.sort(sort));
            }
            this.setOrder((NativeExp)nativeOrder);
        }
        return this;
    }

    public <T> PageImpl<T> criteriaResult(String countAlias, boolean distinctCount, NativeObjectMapper<T> nativeObjectMapper, Pageable pageable) {
        this.setPageable(pageable);
        List result = this.criteriaResult(nativeObjectMapper);
        return new PageImpl(result, pageable, (long)this.fetchCount(countAlias, distinctCount));
    }

    public <T> PageImpl<T> criteriaResult(String countAlias, NativeObjectMapper<T> nativeObjectMapper, Pageable pageable) {
        return this.criteriaResult(countAlias, true, nativeObjectMapper, pageable);
    }

    public <T> PageImpl<T> criteriaResult(String countAlias, boolean distinctCount, NativeBeanPropertyMapper<T> beanPropertyMapper, Pageable pageable) {
        this.setPageable(pageable);
        List<T> result = this.criteriaResult(beanPropertyMapper);
        return new PageImpl(result, pageable, (long)this.fetchCount(countAlias, distinctCount));
    }

    public <T> PageImpl<T> criteriaResult(String countAlias, NativeBeanPropertyMapper<T> beanPropertyMapper, Pageable pageable) {
        return this.criteriaResult(countAlias, true, beanPropertyMapper, pageable);
    }
}

