/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MimeMessageParser {
    private final MimeMessage mimeMessage;
    private String plainContent;
    private String htmlContent;
    private final List<DataSource> attachmentList = new ArrayList<DataSource>();
    private final Map<String, DataSource> cidMap = new HashMap<String, DataSource>();
    private boolean isMultiPart;

    public MimeMessageParser(MimeMessage message) {
        this.mimeMessage = message;
        this.isMultiPart = false;
    }

    public MimeMessageParser parse() throws Exception {
        this.parse(null, (MimePart)this.mimeMessage);
        return this;
    }

    public List<Address> getTo() throws Exception {
        Address[] recipients = this.mimeMessage.getRecipients(Message.RecipientType.TO);
        return recipients != null ? Arrays.asList(recipients) : new ArrayList<Address>();
    }

    public List<Address> getCc() throws Exception {
        Address[] recipients = this.mimeMessage.getRecipients(Message.RecipientType.CC);
        return recipients != null ? Arrays.asList(recipients) : new ArrayList<Address>();
    }

    public List<Address> getBcc() throws Exception {
        Address[] recipients = this.mimeMessage.getRecipients(Message.RecipientType.BCC);
        return recipients != null ? Arrays.asList(recipients) : new ArrayList<Address>();
    }

    public String getFrom() throws Exception {
        Address[] addresses = this.mimeMessage.getFrom();
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return ((InternetAddress)addresses[0]).getAddress();
    }

    public String getReplyTo() throws Exception {
        Address[] addresses = this.mimeMessage.getReplyTo();
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return ((InternetAddress)addresses[0]).getAddress();
    }

    public String getSubject() throws Exception {
        return this.mimeMessage.getSubject();
    }

    protected void parse(Multipart parent, MimePart part) throws MessagingException, IOException {
        if (this.isMimeType(part, "text/plain") && this.plainContent == null && !"attachment".equalsIgnoreCase(part.getDisposition())) {
            this.plainContent = (String)part.getContent();
        } else if (this.isMimeType(part, "text/html") && this.htmlContent == null && !"attachment".equalsIgnoreCase(part.getDisposition())) {
            this.htmlContent = (String)part.getContent();
        } else if (this.isMimeType(part, "multipart/*")) {
            this.isMultiPart = true;
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.parse(mp, (MimePart)((MimeBodyPart)mp.getBodyPart(i)));
            }
        } else {
            String cid = this.stripContentId(part.getContentID());
            DataSource ds = this.createDataSource(parent, part);
            if (cid != null) {
                this.cidMap.put(cid, ds);
            }
            this.attachmentList.add(ds);
        }
    }

    private String stripContentId(String contentId) {
        if (contentId == null) {
            return null;
        }
        return contentId.trim().replaceAll("[\\<\\>]", "");
    }

    private boolean isMimeType(MimePart part, String mimeType) throws MessagingException, IOException {
        try {
            ContentType ct = new ContentType(part.getDataHandler().getContentType());
            return ct.match(mimeType);
        }
        catch (ParseException ex) {
            return part.getContentType().equalsIgnoreCase(mimeType);
        }
    }

    protected DataSource createDataSource(Multipart parent, MimePart part) throws MessagingException, IOException {
        byte[] content;
        DataHandler dataHandler = part.getDataHandler();
        DataSource dataSource = dataHandler.getDataSource();
        String contentType = this.getBaseMimeType(dataSource.getContentType());
        try (InputStream inputStream = dataSource.getInputStream();){
            content = this.getContent(inputStream);
        }
        ByteArrayDataSource result = new ByteArrayDataSource(content, contentType);
        String dataSourceName = this.getDataSourceName((Part)part, dataSource);
        result.setName(dataSourceName);
        return result;
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public boolean isMultipart() {
        return this.isMultiPart;
    }

    public String getPlainContent() {
        return this.plainContent;
    }

    public List<DataSource> getAttachmentList() {
        return this.attachmentList;
    }

    public Collection<String> getContentIds() {
        return Collections.unmodifiableSet(this.cidMap.keySet());
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    public boolean hasPlainContent() {
        return this.plainContent != null;
    }

    public boolean hasHtmlContent() {
        return this.htmlContent != null;
    }

    public boolean hasAttachments() {
        return !this.attachmentList.isEmpty();
    }

    public DataSource findAttachmentByName(String name) {
        for (DataSource element : this.getAttachmentList()) {
            DataSource dataSource = element;
            if (!name.equalsIgnoreCase(dataSource.getName())) continue;
            return dataSource;
        }
        return null;
    }

    public DataSource findAttachmentByCid(String cid) {
        DataSource dataSource = this.cidMap.get(cid);
        return dataSource;
    }

    protected String getDataSourceName(Part part, DataSource dataSource) throws MessagingException, UnsupportedEncodingException {
        String result = dataSource.getName();
        if (result == null || result.isEmpty()) {
            result = part.getFileName();
        }
        result = result != null && !result.isEmpty() ? MimeUtility.decodeText((String)result) : null;
        return result;
    }

    private byte[] getContent(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedInputStream isReader = new BufferedInputStream(is);
        try (BufferedOutputStream osWriter = new BufferedOutputStream(os);){
            int ch;
            while ((ch = isReader.read()) != -1) {
                osWriter.write(ch);
            }
            osWriter.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    private String getBaseMimeType(String fullMimeType) {
        int pos = fullMimeType.indexOf(59);
        if (pos >= 0) {
            return fullMimeType.substring(0, pos);
        }
        return fullMimeType;
    }
}

