/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.api.testng.CucumberExceptionWrapper;
import cucumber.api.testng.CucumberFeatureWrapperImpl;
import cucumber.api.testng.CucumberTagStatementWrapperImpl;
import cucumber.api.testng.FeatureResultListener;
import cucumber.api.testng.TestNgReporter;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import cucumber.runtime.model.CucumberTagStatement;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGCucumberRunner {
    private Runtime runtime;
    private RuntimeOptions runtimeOptions;
    private ResourceLoader resourceLoader;
    private FeatureResultListener resultListener;
    private ClassLoader classLoader;

    public TestNGCucumberRunner(Class clazz) {
        this.classLoader = clazz.getClassLoader();
        this.resourceLoader = new MultiLoader(this.classLoader);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        this.runtimeOptions = runtimeOptionsFactory.create();
        TestNgReporter reporter = new TestNgReporter(System.out);
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(this.resourceLoader, this.classLoader);
        this.resultListener = new FeatureResultListener(this.runtimeOptions.reporter(this.classLoader), this.runtimeOptions.isStrict());
        this.runtime = new Runtime(this.resourceLoader, (ClassFinder)classFinder, this.classLoader, this.runtimeOptions);
    }

    public void runCukes() {
        for (CucumberFeature cucumberFeature : this.getFeatures()) {
            cucumberFeature.run(this.runtimeOptions.formatter(this.classLoader), (Reporter)this.resultListener, this.runtime);
        }
        this.finish();
        if (!this.resultListener.isPassed()) {
            throw new CucumberException(this.resultListener.getFirstError());
        }
    }

    public void runCucumber(CucumberFeature cucumberFeature) {
        this.resultListener.startFeature();
        cucumberFeature.run(this.runtimeOptions.formatter(this.classLoader), (Reporter)this.resultListener, this.runtime);
        if (!this.resultListener.isPassed()) {
            throw new CucumberException(this.resultListener.getFirstError());
        }
    }

    public void runCucumberScenario(CucumberTagStatement cucumberTagStatement) throws Throwable {
        this.resultListener.startFeature();
        cucumberTagStatement.run(this.runtimeOptions.formatter(this.classLoader), (Reporter)this.resultListener, this.runtime);
        if (!this.resultListener.isPassed()) {
            throw this.resultListener.getFirstError();
        }
    }

    public void finish() {
        Formatter formatter = this.runtimeOptions.formatter(this.classLoader);
        formatter.done();
        formatter.close();
        this.runtime.printSummary();
    }

    public List<CucumberFeature> getFeatures() {
        return this.runtimeOptions.cucumberFeatures(this.resourceLoader);
    }

    public List<CucumberTagStatement> getScenarios() {
        ArrayList<CucumberTagStatement> scenarios = new ArrayList<CucumberTagStatement>();
        List<CucumberFeature> features = this.getFeatures();
        for (CucumberFeature feature : features) {
            List featureScenarios = feature.getFeatureElements();
            scenarios.addAll(featureScenarios);
        }
        return scenarios;
    }

    public Object[][] provideFeatures() {
        try {
            List<CucumberFeature> features = this.getFeatures();
            ArrayList<Object[]> featuresList = new ArrayList<Object[]>(features.size());
            for (CucumberFeature feature : features) {
                featuresList.add(new Object[]{new CucumberFeatureWrapperImpl(feature)});
            }
            return (Object[][])featuresList.toArray((T[])new Object[0][]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e)}};
        }
    }

    public Object[][] provideScenarios() {
        try {
            List<CucumberFeature> features = this.getFeatures();
            ArrayList<Object[]> scenarioList = new ArrayList<Object[]>(features.size());
            for (CucumberFeature feature : features) {
                List scenarios = feature.getFeatureElements();
                for (CucumberTagStatement scenario : scenarios) {
                    if (scenario instanceof CucumberScenarioOutline) {
                        List cucumberExamplesList = ((CucumberScenarioOutline)scenario).getCucumberExamplesList();
                        for (CucumberExamples cucumberExamples : cucumberExamplesList) {
                            List exampleScenarios = cucumberExamples.createExampleScenarios();
                            for (CucumberScenario exampleScenario : exampleScenarios) {
                                scenarioList.add(new Object[]{new CucumberTagStatementWrapperImpl((CucumberTagStatement)exampleScenario)});
                            }
                        }
                        continue;
                    }
                    scenarioList.add(new Object[]{new CucumberTagStatementWrapperImpl(scenario)});
                }
            }
            return (Object[][])scenarioList.toArray((T[])new Object[0][]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e)}};
        }
    }

    public Object[][] provideScenariosWithFeature() {
        try {
            List<CucumberFeature> features = this.getFeatures();
            ArrayList<Object[]> scenarioList = new ArrayList<Object[]>(features.size());
            for (CucumberFeature feature : features) {
                List scenarios = feature.getFeatureElements();
                for (CucumberTagStatement scenario : scenarios) {
                    if (scenario instanceof CucumberScenarioOutline) {
                        List cucumberExamplesList = ((CucumberScenarioOutline)scenario).getCucumberExamplesList();
                        for (CucumberExamples cucumberExamples : cucumberExamplesList) {
                            List exampleScenarios = cucumberExamples.createExampleScenarios();
                            for (CucumberScenario exampleScenario : exampleScenarios) {
                                scenarioList.add(new Object[]{new CucumberTagStatementWrapperImpl((CucumberTagStatement)exampleScenario, feature)});
                            }
                        }
                        continue;
                    }
                    scenarioList.add(new Object[]{new CucumberTagStatementWrapperImpl(scenario, feature)});
                }
            }
            return (Object[][])scenarioList.toArray((T[])new Object[0][]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e)}};
        }
    }
}

