/*
 * Decompiled with CFR 0.152.
 */
package com.github.pravin.raha.lexorank4j;

import com.github.pravin.raha.lexorank4j.LexoInteger;
import com.github.pravin.raha.lexorank4j.numerical.system.LexoNumeralSystem;
import java.util.Objects;

public class LexoDecimal
implements Comparable<LexoDecimal> {
    private final LexoInteger mag;
    private final int sig;

    private LexoDecimal(LexoInteger mag, int sig) {
        this.mag = mag;
        this.sig = sig;
    }

    public static LexoDecimal half(LexoNumeralSystem sys) {
        int mid = sys.getBase() / 2;
        return LexoDecimal.make(LexoInteger.make(sys, 1, new int[]{mid}), 1);
    }

    public static LexoDecimal parse(String str, LexoNumeralSystem system) {
        int partialIndex = str.indexOf(system.getRadixPointChar());
        if (str.lastIndexOf(system.getRadixPointChar()) != partialIndex) {
            throw new IllegalArgumentException("More than one " + system.getRadixPointChar());
        }
        if (partialIndex < 0) {
            return LexoDecimal.make(LexoInteger.parse(str, system), 0);
        }
        String intStr = str.substring(0, partialIndex) + str.substring(partialIndex + 1);
        return LexoDecimal.make(LexoInteger.parse(intStr, system), str.length() - 1 - partialIndex);
    }

    public static LexoDecimal from(LexoInteger integer) {
        return LexoDecimal.make(integer, 0);
    }

    public static LexoDecimal make(LexoInteger integer, int sig) {
        if (integer.isZero()) {
            return new LexoDecimal(integer, 0);
        }
        int zeroCount = 0;
        for (int i = 0; i < sig && integer.getMag(i) == 0; ++i) {
            ++zeroCount;
        }
        LexoInteger newInteger = integer.shiftRight(zeroCount);
        int newSig = sig - zeroCount;
        return new LexoDecimal(newInteger, newSig);
    }

    public LexoNumeralSystem getSystem() {
        return this.mag.getSystem();
    }

    public LexoDecimal add(LexoDecimal other) {
        int tSig;
        LexoInteger tMag = this.mag;
        LexoInteger oMag = other.mag;
        int oSig = other.sig;
        for (tSig = this.sig; tSig < oSig; ++tSig) {
            tMag = tMag.shiftLeft();
        }
        while (tSig > oSig) {
            oMag = oMag.shiftLeft();
            ++oSig;
        }
        return LexoDecimal.make(tMag.add(oMag), tSig);
    }

    public LexoDecimal subtract(LexoDecimal other) {
        int thisSig;
        LexoInteger thisMag = this.mag;
        LexoInteger otherMag = other.mag;
        int otherSig = other.sig;
        for (thisSig = this.sig; thisSig < otherSig; ++thisSig) {
            thisMag = thisMag.shiftLeft();
        }
        while (thisSig > otherSig) {
            otherMag = otherMag.shiftLeft();
            ++otherSig;
        }
        return LexoDecimal.make(thisMag.subtract(otherMag), thisSig);
    }

    public LexoDecimal multiply(LexoDecimal other) {
        return LexoDecimal.make(this.mag.multiply(other.mag), this.sig + other.sig);
    }

    public LexoInteger floor() {
        return this.mag.shiftRight(this.sig);
    }

    public LexoInteger ceil() {
        if (this.isExact()) {
            return this.mag;
        }
        LexoInteger floor = this.floor();
        return floor.add(LexoInteger.one(floor.getSystem()));
    }

    public boolean isExact() {
        if (this.sig == 0) {
            return true;
        }
        for (int i = 0; i < this.sig; ++i) {
            if (this.mag.getMag(i) == 0) continue;
            return false;
        }
        return true;
    }

    public int getScale() {
        return this.sig;
    }

    public LexoDecimal setScale(int nSig) {
        return this.setScale(nSig, false);
    }

    public LexoDecimal setScale(int nSig, boolean ceiling) {
        if (nSig >= this.sig) {
            return this;
        }
        if (nSig < 0) {
            nSig = 0;
        }
        int diff = this.sig - nSig;
        LexoInteger nmag = this.mag.shiftRight(diff);
        if (ceiling) {
            nmag = nmag.add(LexoInteger.one(nmag.getSystem()));
        }
        return LexoDecimal.make(nmag, nSig);
    }

    public String format() {
        boolean specialHead;
        String intStr = this.mag.format();
        if (this.sig == 0) {
            return intStr;
        }
        StringBuilder sb = new StringBuilder(intStr);
        char head = sb.charAt(0);
        boolean bl = specialHead = head == this.mag.getSystem().getPositiveChar() || head == this.mag.getSystem().getNegativeChar();
        if (specialHead) {
            sb.delete(0, 1);
        }
        while (sb.length() < this.sig + 1) {
            sb.insert(0, this.mag.getSystem().toChar(0));
        }
        sb.insert(sb.length() - this.sig, this.mag.getSystem().getRadixPointChar());
        if (sb.length() - this.sig == 0) {
            sb.insert(0, this.mag.getSystem().toChar(0));
        }
        if (specialHead) {
            sb.insert(0, head);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexoDecimal that = (LexoDecimal)o;
        return this.sig == that.sig && Objects.equals(this.mag, that.mag);
    }

    public int hashCode() {
        return Objects.hash(this.mag, this.sig);
    }

    public String toString() {
        return this.format();
    }

    @Override
    public int compareTo(LexoDecimal lexoDecimal) {
        if (Objects.equals(this, lexoDecimal)) {
            return 0;
        }
        if (Objects.equals(null, lexoDecimal)) {
            return 1;
        }
        LexoInteger tMag = this.mag;
        LexoInteger oMag = lexoDecimal.mag;
        if (this.sig > lexoDecimal.sig) {
            oMag = oMag.shiftLeft(this.sig - lexoDecimal.sig);
        } else if (this.sig < lexoDecimal.sig) {
            tMag = tMag.shiftLeft(lexoDecimal.sig - this.sig);
        }
        return tMag.compareTo(oMag);
    }
}

