/*
 * Decompiled with CFR 0.152.
 */
package com.github.pravin.raha.lexorank4j;

import com.github.pravin.raha.lexorank4j.LexoDecimal;
import com.github.pravin.raha.lexorank4j.LexoInteger;
import com.github.pravin.raha.lexorank4j.LexoRankBucket;
import com.github.pravin.raha.lexorank4j.numerical.system.LexoNumeralSystem;
import com.github.pravin.raha.lexorank4j.numerical.system.LexoNumeralSystem36;
import java.util.Objects;

public class LexoRank
implements Comparable<LexoRank> {
    public static final LexoNumeralSystem NUMERAL_SYSTEM = new LexoNumeralSystem36();
    private static final LexoDecimal ZERO_DECIMAL = LexoDecimal.parse("0", NUMERAL_SYSTEM);
    private static final LexoDecimal ONE_DECIMAL = LexoDecimal.parse("1", NUMERAL_SYSTEM);
    private static final LexoDecimal EIGHT_DECIMAL = LexoDecimal.parse("8", NUMERAL_SYSTEM);
    private static final LexoDecimal MIN_DECIMAL = ZERO_DECIMAL;
    private static final LexoDecimal MAX_DECIMAL = LexoDecimal.parse("1000000", NUMERAL_SYSTEM).subtract(ONE_DECIMAL);
    private static final LexoDecimal MID_DECIMAL = LexoRank.between(MIN_DECIMAL, MAX_DECIMAL);
    private static final LexoDecimal INITIAL_MIN_DECIMAL = LexoDecimal.parse("100000", NUMERAL_SYSTEM);
    private static final LexoDecimal INITIAL_MAX_DECIMAL = LexoDecimal.parse(NUMERAL_SYSTEM.toChar(NUMERAL_SYSTEM.getBase() - 2) + "00000", NUMERAL_SYSTEM);
    private final String value;
    private final LexoRankBucket bucket;
    private final LexoDecimal decimal;

    private LexoRank(String value) {
        this.value = value;
        String[] parts = this.value.split("\\|");
        this.bucket = LexoRankBucket.from(parts[0]);
        this.decimal = LexoDecimal.parse(parts[1], NUMERAL_SYSTEM);
    }

    private LexoRank(LexoRankBucket bucket, LexoDecimal dec) {
        this.value = bucket.format() + "|" + LexoRank.formatDecimal(dec);
        this.bucket = bucket;
        this.decimal = dec;
    }

    public static LexoRank min() {
        return LexoRank.from(LexoRankBucket.BUCKET_0, MIN_DECIMAL);
    }

    public static LexoRank max() {
        return LexoRank.max(LexoRankBucket.BUCKET_0);
    }

    public static LexoRank middle() {
        LexoRank minLexoRank = LexoRank.min();
        return minLexoRank.between(LexoRank.max(minLexoRank.bucket));
    }

    public static LexoRank max(LexoRankBucket bucket) {
        return LexoRank.from(bucket, MAX_DECIMAL);
    }

    public static LexoRank initial(LexoRankBucket bucket) {
        return bucket == LexoRankBucket.BUCKET_0 ? LexoRank.from(bucket, INITIAL_MIN_DECIMAL) : LexoRank.from(bucket, INITIAL_MAX_DECIMAL);
    }

    private static LexoDecimal between(LexoDecimal oLeft, LexoDecimal oRight) {
        int nScale;
        LexoDecimal nMid;
        LexoDecimal nLeft;
        if (oLeft.getSystem() != oRight.getSystem()) {
            throw new IllegalArgumentException("Expected same system");
        }
        LexoDecimal left = oLeft;
        LexoDecimal right = oRight;
        if (oLeft.getScale() < oRight.getScale()) {
            nLeft = oRight.setScale(oLeft.getScale(), false);
            if (oLeft.compareTo(nLeft) >= 0) {
                return LexoRank.middle(oLeft, oRight);
            }
            right = nLeft;
        }
        if (oLeft.getScale() > right.getScale()) {
            nLeft = oLeft.setScale(right.getScale(), true);
            if (nLeft.compareTo(right) >= 0) {
                return LexoRank.middle(oLeft, oRight);
            }
            left = nLeft;
        }
        int scale = left.getScale();
        while (scale > 0) {
            LexoDecimal nRight;
            int nScale1 = scale - 1;
            LexoDecimal nLeft1 = left.setScale(nScale1, true);
            int cmp = nLeft1.compareTo(nRight = right.setScale(nScale1, false));
            if (cmp == 0) {
                return LexoRank.checkMid(oLeft, oRight, nLeft1);
            }
            if (nLeft1.compareTo(nRight) > 0) break;
            scale = nScale1;
            left = nLeft1;
            right = nRight;
        }
        LexoDecimal mid = LexoRank.middle(oLeft, oRight, left, right);
        int mScale = mid.getScale();
        while (mScale > 0 && oLeft.compareTo(nMid = mid.setScale(nScale = mScale - 1)) < 0 && nMid.compareTo(oRight) < 0) {
            mid = nMid;
            mScale = nScale;
        }
        return mid;
    }

    private static LexoDecimal middle(LexoDecimal lBound, LexoDecimal rBound, LexoDecimal left, LexoDecimal right) {
        LexoDecimal mid = LexoRank.middle(left, right);
        return LexoRank.checkMid(lBound, rBound, mid);
    }

    private static LexoDecimal checkMid(LexoDecimal lBound, LexoDecimal rBound, LexoDecimal mid) {
        if (lBound.compareTo(mid) >= 0) {
            return LexoRank.middle(lBound, rBound);
        }
        return mid.compareTo(rBound) >= 0 ? LexoRank.middle(lBound, rBound) : mid;
    }

    private static LexoDecimal middle(LexoDecimal left, LexoDecimal right) {
        LexoDecimal sum = left.add(right);
        LexoDecimal mid = sum.multiply(LexoDecimal.half(left.getSystem()));
        int scale = Math.max(left.getScale(), right.getScale());
        if (mid.getScale() > scale) {
            LexoDecimal roundDown = mid.setScale(scale, false);
            if (roundDown.compareTo(left) > 0) {
                return roundDown;
            }
            LexoDecimal roundUp = mid.setScale(scale, true);
            if (roundUp.compareTo(right) < 0) {
                return roundUp;
            }
        }
        return mid;
    }

    private static String formatDecimal(LexoDecimal dec) {
        String formatVal = dec.format();
        StringBuilder val = new StringBuilder(formatVal);
        int partialIndex = formatVal.indexOf(NUMERAL_SYSTEM.getRadixPointChar());
        char zero = NUMERAL_SYSTEM.toChar(0);
        if (partialIndex < 0) {
            partialIndex = formatVal.length();
            val.append(NUMERAL_SYSTEM.getRadixPointChar());
        }
        while (partialIndex < 6) {
            val.insert(0, zero);
            ++partialIndex;
        }
        int valLength = val.length() - 1;
        while (val.charAt(valLength) == zero) {
            valLength = val.length() - 1;
        }
        return val.toString();
    }

    public static LexoRank parse(String str) {
        if (LexoRank.isNullOrWhiteSpace(str)) {
            throw new IllegalArgumentException(str);
        }
        return new LexoRank(str);
    }

    public static LexoRank from(LexoRankBucket bucket, LexoDecimal dec) {
        if (!dec.getSystem().getName().equals(NUMERAL_SYSTEM.getName())) {
            throw new IllegalArgumentException("Expected different system");
        }
        return new LexoRank(bucket, dec);
    }

    private static boolean isNullOrWhiteSpace(String string) {
        return string == null || string.equals(" ");
    }

    public LexoRankBucket getBucket() {
        return this.bucket;
    }

    public LexoDecimal getDecimal() {
        return this.decimal;
    }

    public int CompareTo(LexoRank other) {
        if (Objects.equals(this, other)) {
            return 0;
        }
        if (Objects.equals(null, other)) {
            return 1;
        }
        return this.value.compareTo(other.value);
    }

    public LexoRank genPrev() {
        if (this.isMax()) {
            return new LexoRank(this.bucket, INITIAL_MAX_DECIMAL);
        }
        LexoInteger floorInteger = this.decimal.floor();
        LexoDecimal floorDecimal = LexoDecimal.from(floorInteger);
        LexoDecimal nextDecimal = floorDecimal.subtract(EIGHT_DECIMAL);
        if (nextDecimal.compareTo(MIN_DECIMAL) <= 0) {
            nextDecimal = LexoRank.between(MIN_DECIMAL, this.decimal);
        }
        return new LexoRank(this.bucket, nextDecimal);
    }

    public LexoRank inNextBucket() {
        return LexoRank.from(this.bucket.next(), this.decimal);
    }

    public LexoRank inPrevBucket() {
        return LexoRank.from(this.bucket.prev(), this.decimal);
    }

    public boolean isMin() {
        return this.decimal.equals(MIN_DECIMAL);
    }

    public boolean isMax() {
        return this.decimal.equals(MAX_DECIMAL);
    }

    public String format() {
        return this.value;
    }

    public LexoRank genNext() {
        if (this.isMin()) {
            return new LexoRank(this.bucket, INITIAL_MIN_DECIMAL);
        }
        LexoInteger ceilInteger = this.decimal.ceil();
        LexoDecimal ceilDecimal = LexoDecimal.from(ceilInteger);
        LexoDecimal nextDecimal = ceilDecimal.add(EIGHT_DECIMAL);
        if (nextDecimal.compareTo(MAX_DECIMAL) >= 0) {
            nextDecimal = LexoRank.between(this.decimal, MAX_DECIMAL);
        }
        return new LexoRank(this.bucket, nextDecimal);
    }

    public LexoRank between(LexoRank other) {
        if (!this.bucket.equals(other.bucket)) {
            throw new IllegalArgumentException("Between works only within the same bucket");
        }
        int cmp = this.decimal.compareTo(other.decimal);
        if (cmp > 0) {
            return new LexoRank(this.bucket, LexoRank.between(other.decimal, this.decimal));
        }
        if (cmp == 0) {
            throw new IllegalArgumentException("Try to rank between issues with same rank this=" + this + " other=" + other + " this.decimal=" + this.decimal + " other.decimal=" + other.decimal);
        }
        return new LexoRank(this.bucket, LexoRank.between(this.decimal, other.decimal));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexoRank lexoRank = (LexoRank)o;
        return Objects.equals(this.value, lexoRank.value) && Objects.equals(this.bucket, lexoRank.bucket) && Objects.equals(this.decimal, lexoRank.decimal);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.bucket, this.decimal);
    }

    public String toString() {
        return this.format();
    }

    @Override
    public int compareTo(LexoRank lexoRank) {
        if (Objects.equals(this, lexoRank)) {
            return 0;
        }
        if (Objects.equals(null, lexoRank)) {
            return 1;
        }
        return this.value.compareTo(lexoRank.value);
    }
}

