/*
 * Decompiled with CFR 0.152.
 */
package com.github.pravin.raha.lexorank4j;

import com.github.pravin.raha.lexorank4j.LexoInteger;
import com.github.pravin.raha.lexorank4j.LexoRank;
import java.util.Objects;

public class LexoRankBucket {
    protected static final LexoRankBucket BUCKET_0 = new LexoRankBucket("0");
    protected static final LexoRankBucket BUCKET_1 = new LexoRankBucket("1");
    protected static final LexoRankBucket BUCKET_2 = new LexoRankBucket("2");
    private static final LexoRankBucket[] VALUES = new LexoRankBucket[]{BUCKET_0, BUCKET_1, BUCKET_2};
    private final LexoInteger value;

    private LexoRankBucket(String val) {
        this.value = LexoInteger.parse(val, LexoRank.NUMERAL_SYSTEM);
    }

    public static LexoRankBucket resolve(int bucketId) {
        for (LexoRankBucket bucket : VALUES) {
            if (!bucket.equals(LexoRankBucket.from(String.valueOf(bucketId)))) continue;
            return bucket;
        }
        throw new IllegalArgumentException("No bucket found with id " + bucketId);
    }

    public static LexoRankBucket from(String str) {
        LexoInteger val = LexoInteger.parse(str, LexoRank.NUMERAL_SYSTEM);
        for (LexoRankBucket bucket : VALUES) {
            if (!bucket.value.equals(val)) continue;
            return bucket;
        }
        throw new IllegalArgumentException("Unknown bucket: " + str);
    }

    public static LexoRankBucket min() {
        return VALUES[0];
    }

    public static LexoRankBucket max() {
        return VALUES[VALUES.length - 1];
    }

    public String format() {
        return this.value.format();
    }

    public LexoRankBucket next() {
        if (this == BUCKET_0) {
            return BUCKET_1;
        }
        if (this == BUCKET_1) {
            return BUCKET_2;
        }
        return this == BUCKET_2 ? BUCKET_0 : BUCKET_2;
    }

    public LexoRankBucket prev() {
        if (this == BUCKET_0) {
            return BUCKET_2;
        }
        if (this == BUCKET_1) {
            return BUCKET_0;
        }
        return this == BUCKET_2 ? BUCKET_1 : BUCKET_0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexoRankBucket that = (LexoRankBucket)o;
        return Objects.equals(this.value, that.value);
    }

    public String toString() {
        return this.format();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

