/*
 * Decompiled with CFR 0.152.
 */
package com.github.pravin.raha.lexorank4j.numerical.system;

import com.github.pravin.raha.lexorank4j.numerical.system.LexoNumeralSystem;

public class LexoNumeralSystem64
implements LexoNumeralSystem {
    private final char[] digits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ^_abcdefghijklmnopqrstuvwxyz".toCharArray();

    @Override
    public String getName() {
        return "Base64";
    }

    @Override
    public int getBase() {
        return 64;
    }

    @Override
    public char getPositiveChar() {
        return '+';
    }

    @Override
    public char getNegativeChar() {
        return '-';
    }

    @Override
    public char getRadixPointChar() {
        return ':';
    }

    @Override
    public int toDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 65 + 10;
        }
        if (ch == '^') {
            return 36;
        }
        if (ch == '_') {
            return 37;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 97 + 38;
        }
        throw new IllegalArgumentException("Not valid digit: " + ch);
    }

    @Override
    public char toChar(int digit) {
        return this.digits[digit];
    }
}

