/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld;

import com.github.princesslana.smalld.GatewayIntent;
import java.time.Clock;

public class Config {
    private String baseUrl;
    private final Clock clock;
    private final int currentShard;
    private final int numberOfShards;
    private final String token;
    private final int intents;

    private Config(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.clock = builder.clock;
        this.currentShard = builder.currentShard;
        this.numberOfShards = builder.numberOfShards;
        this.token = builder.token;
        this.intents = builder.intents;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Clock getClock() {
        return this.clock;
    }

    public int getCurrentShard() {
        return this.currentShard;
    }

    public int getIntents() {
        return this.intents;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public String getToken() {
        return this.token;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String V6_BASE_URL = "https://discord.com/api/v6";
        private String baseUrl = "https://discord.com/api/v6";
        private Clock clock = Clock.systemUTC();
        private int currentShard = 0;
        private int numberOfShards = 1;
        private String token;
        private int intents = GatewayIntent.UNPRIVILEGED;

        private Builder() {
        }

        public Builder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setIntents(GatewayIntent ... intents) {
            this.intents = GatewayIntent.toMask(intents);
            return this;
        }

        public Builder setShard(int current, int number) {
            this.currentShard = current;
            this.numberOfShards = number;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

