/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld;

import java.util.Arrays;

public enum GatewayIntent {
    GUILDS(1),
    GUILD_MEMEBERS(2),
    GUILD_BANS(4),
    GUILD_EMOJIS(8),
    GUILD_INTEGRATIONS(16),
    GUILD_WEBHOOKS(32),
    GUILD_INVITES(64),
    GUILD_VOICE_STATES(128),
    GUILD_PRESENCES(256),
    GUILD_MESSAGES(512),
    GUILD_MESSAGE_REACTIONS(1024),
    GUILD_MESSAGE_TYPING(2048),
    DIRECT_MESSAGES(4096),
    DIRECT_MESSAGE_REACTIONS(8192),
    DIRECT_MESSAGE_TYPING(16384);

    public static final int ALL;
    public static final int PRIVILEGED;
    public static final int UNPRIVILEGED;
    private final int mask;

    private GatewayIntent(int mask) {
        this.mask = mask;
    }

    public static int toMask(GatewayIntent ... intents) {
        return Arrays.stream(intents).mapToInt(g -> g.mask).reduce((x, y) -> x | y).orElse(0);
    }

    static {
        ALL = GatewayIntent.toMask(GatewayIntent.values());
        PRIVILEGED = GatewayIntent.toMask(GUILD_PRESENCES, GUILD_MEMEBERS);
        UNPRIVILEGED = ALL ^ PRIVILEGED;
    }
}

