/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Optional;

public class GatewayPayload {
    public static final int OP_DISPATCH = 0;
    public static final int OP_HEARTBEAT = 1;
    public static final int OP_IDENTIFY = 2;
    public static final int OP_RESUME = 6;
    public static final int OP_RECONNECT = 7;
    public static final int OP_INVALID_SESSION = 9;
    public static final int OP_HELLO = 10;
    public static final int OP_HEARTBEAT_ACK = 11;
    private final JsonObject json;

    private GatewayPayload(JsonObject json) {
        this.json = json;
    }

    public int getOp() {
        int op = this.json.getInt("op", -1);
        if (op < 0) {
            throw new IllegalStateException("No op received in payload");
        }
        return op;
    }

    public boolean isT(String other) {
        JsonValue t = this.json.get("t");
        return t != null && t.isString() && t.asString().equals(other);
    }

    public JsonObject getD() {
        return this.json.get("d").asObject();
    }

    public Optional<Long> getS() {
        JsonValue s = this.json.get("s");
        return s != null && s.isNumber() ? Optional.of(s.asLong()) : Optional.empty();
    }

    public static GatewayPayload parse(String s) {
        return new GatewayPayload(Json.parse((String)s).asObject());
    }
}

