/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.github.princesslana.smalld.GatewayPayload;
import com.github.princesslana.smalld.SequenceNumber;
import com.github.princesslana.smalld.SmallD;
import java.util.function.Consumer;

public class Heartbeat
implements Consumer<SmallD> {
    private final SequenceNumber sequenceNumber;
    private Thread heartbeatThread = null;
    private volatile long heartbeatInterval;
    private volatile boolean ackReceived = false;

    public Heartbeat(SequenceNumber sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public void accept(SmallD smalld) {
        smalld.onGatewayPayload(s -> {
            GatewayPayload p = GatewayPayload.parse(s);
            switch (p.getOp()) {
                case 10: {
                    this.onHello(smalld, p.getD());
                    break;
                }
                case 1: {
                    this.onHeartbeat(smalld);
                    break;
                }
                case 11: {
                    this.onHeartbeatAck();
                }
            }
        });
    }

    private void onHello(SmallD smalld, JsonObject d) {
        this.heartbeatInterval = d.getInt("heartbeat_interval", -1);
        if (this.heartbeatThread == null || !this.heartbeatThread.isAlive()) {
            this.heartbeatThread = SmallD.DAEMON_THREAD_FACTORY.newThread(() -> this.runHeartbeatLoop(smalld));
            this.heartbeatThread.start();
        }
    }

    private void runHeartbeatLoop(SmallD smalld) {
        try {
            Thread.sleep(this.heartbeatInterval);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return;
        }
        while (true) {
            this.sendHeartbeat(smalld);
            try {
                Thread.sleep(this.heartbeatInterval);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                return;
            }
            if (!this.ackReceived) break;
            this.ackReceived = false;
        }
        smalld.reconnect();
    }

    private void onHeartbeat(SmallD smalld) {
        this.sendHeartbeat(smalld);
    }

    private void onHeartbeatAck() {
        this.ackReceived = true;
    }

    private void sendHeartbeat(SmallD smalld) {
        smalld.sendGatewayPayload(Json.object().add("op", 1).add("d", this.sequenceNumber.getLastSeen().map(Json::value).orElse(Json.NULL)).toString());
    }
}

