/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld;

import com.github.princesslana.smalld.Config;
import com.github.princesslana.smalld.HttpException;
import com.github.princesslana.smalld.SmallDException;
import com.github.princesslana.smalld.ratelimit.RateLimitInterceptor;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private final Config config;
    private final String userAgent;
    private OkHttpClient client;

    public HttpClient(Config config) {
        this.config = config;
        this.userAgent = this.loadUserAgent();
    }

    private String loadUserAgent() {
        try {
            Properties version = new Properties();
            version.load(this.getClass().getResourceAsStream("version.properties"));
            return String.format("DiscordBot (%s, %s)", version.getProperty("url"), version.getProperty("version"));
        }
        catch (IOException e) {
            throw new SmallDException(e);
        }
    }

    private synchronized OkHttpClient getClient() {
        if (this.client == null) {
            this.client = new OkHttpClient.Builder().addInterceptor((Interceptor)new RateLimitInterceptor(this.config.getClock())).addInterceptor(HttpClient.addHeader("Authorization", () -> "Bot " + this.config.getToken())).addInterceptor(HttpClient.addHeader("User-Agent", () -> this.userAgent)).build();
        }
        return this.client;
    }

    public WebSocket newWebSocket(Request request, WebSocketListener listener) {
        return this.getClient().newWebSocket(request, listener);
    }

    public String send(String path, UnaryOperator<Request.Builder> build, Map<String, Object> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.get((String)this.config.getBaseUrl()).newBuilder().addPathSegment(path);
        parameters.forEach((string, object) -> urlBuilder.addQueryParameter(string, String.valueOf(object)));
        Request.Builder builder = new Request.Builder().url(urlBuilder.build());
        return this.send(((Request.Builder)build.apply(builder)).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String send(Request request) {
        try (Response response = this.getClient().newCall(request).execute();){
            int code = response.code();
            String status = response.message();
            String body = response.body().string();
            LOG.debug("HTTP Response: [{} {}] {}", new Object[]{code, status, body});
            if (response.code() >= 500) {
                throw new HttpException.ServerException(code, status, body);
            }
            if (response.code() >= 400) {
                throw new HttpException.ClientException(code, status, body);
            }
            if (!response.isSuccessful()) {
                throw new HttpException(code, status, body);
            }
            String string = body;
            return string;
        }
        catch (IOException e) {
            throw new SmallDException(e);
        }
    }

    @Override
    public synchronized void close() {
        if (this.client != null) {
            this.client.dispatcher().executorService().shutdown();
            this.client.connectionPool().evictAll();
            this.client = null;
        }
    }

    private static final Interceptor addHeader(String name, Supplier<String> valueSupplier) {
        return c -> c.proceed(c.request().newBuilder().header(name, (String)valueSupplier.get()).build());
    }
}

