/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.github.princesslana.smalld.GatewayPayload;
import com.github.princesslana.smalld.SequenceNumber;
import com.github.princesslana.smalld.SmallD;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Identify
implements Consumer<SmallD> {
    private final SequenceNumber sequenceNumber;
    private String sessionId;

    public Identify(SequenceNumber sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public void accept(SmallD smalld) {
        smalld.onGatewayPayload(s -> {
            GatewayPayload p = GatewayPayload.parse(s);
            switch (p.getOp()) {
                case 0: {
                    if (!p.isT("READY")) break;
                    this.onReady(p.getD());
                    break;
                }
                case 9: {
                    this.onInvalidSession(smalld);
                    break;
                }
                case 10: {
                    this.onHello(smalld);
                    break;
                }
                case 7: {
                    this.onReconnect(smalld);
                    break;
                }
            }
        });
    }

    private void onHello(SmallD smalld) {
        Long seq = this.sequenceNumber.getLastSeen().orElse(null);
        JsonObject payload = seq == null || this.sessionId == null ? this.identify(smalld) : this.resume(smalld, seq, this.sessionId);
        smalld.sendGatewayPayload(payload.toString());
    }

    private JsonObject identify(SmallD smalld) {
        JsonObject properties = Json.object().add("$os", System.getProperty("os.name")).add("$device", "SmallD").add("$browser", "SmallD");
        JsonObject d = Json.object().add("token", smalld.getToken()).add("properties", (JsonValue)properties).add("compress", false).add("intents", smalld.getIntents()).add("shard", (JsonValue)Json.array().add(smalld.getCurrentShard()).add(smalld.getNumberOfShards()));
        return Json.object().add("op", 2).add("d", (JsonValue)d);
    }

    private JsonObject resume(SmallD smalld, Long seq, String session) {
        JsonObject d = Json.object().add("token", smalld.getToken()).add("session_id", session).add("seq", seq.longValue());
        return Json.object().add("op", 6).add("d", (JsonValue)d);
    }

    private void onReady(JsonObject d) {
        this.sessionId = d.get("session_id").asString();
    }

    private void onInvalidSession(SmallD smalld) {
        this.sessionId = null;
        try {
            TimeUnit.SECONDS.sleep(2L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        smalld.sendGatewayPayload(this.identify(smalld).toString());
    }

    private void onReconnect(SmallD smalld) {
        smalld.reconnect();
    }
}

