/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld;

import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;

public class LoggingWebSocketListener
extends WebSocketListener {
    private final Logger log;
    private final WebSocketListener wrapped;

    public LoggingWebSocketListener(Logger log, WebSocketListener wrapped) {
        this.log = log;
        this.wrapped = wrapped;
    }

    public void onClosed(WebSocket ws, int code, String reason) {
        this.log.debug("WebSocket Closed: {}, {}", (Object)code, (Object)reason);
        this.wrapped.onClosed(ws, code, reason);
    }

    public void onClosing(WebSocket ws, int code, String reason) {
        this.log.debug("WebSocket Closing: {}, {}", (Object)code, (Object)reason);
        this.wrapped.onClosing(ws, code, reason);
    }

    public void onFailure(WebSocket ws, Throwable t, Response response) {
        this.log.debug("WebSocket Failure: {}", (Object)response, (Object)t);
        this.wrapped.onFailure(ws, t, response);
    }

    public void onMessage(WebSocket ws, ByteString bytes) {
        this.log.debug("WebSocket Message (ByteString): {} bytes", (Object)bytes.size());
        this.wrapped.onMessage(ws, bytes);
    }

    public void onMessage(WebSocket ws, String text) {
        this.log.debug("WebSocket Message (String): {}", (Object)text);
        this.wrapped.onMessage(ws, text);
    }

    public void onOpen(WebSocket ws, Response response) {
        this.log.debug("WebSocket Open: {}", (Object)response);
        this.wrapped.onOpen(ws, response);
    }
}

