/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.ParseException;
import com.github.princesslana.smalld.Attachment;
import com.github.princesslana.smalld.Config;
import com.github.princesslana.smalld.Heartbeat;
import com.github.princesslana.smalld.HttpClient;
import com.github.princesslana.smalld.Identify;
import com.github.princesslana.smalld.LoggingWebSocketListener;
import com.github.princesslana.smalld.SequenceNumber;
import com.github.princesslana.smalld.SmallDException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmallD
implements AutoCloseable {
    public static final ThreadFactory DAEMON_THREAD_FACTORY = r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    };
    private static final Logger LOG = LoggerFactory.getLogger(SmallD.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Set<Integer> FATAL_WEBSOCKET_CLOSE_CODES = new HashSet<Integer>(Arrays.asList(4004, 4010, 4011, 4012, 4013, 4014));
    private final Config config;
    private final HttpClient http;
    private final List<Consumer<String>> gatewayPayloadListeners = new ArrayList<Consumer<String>>();
    private final ExecutorService onGatewayPayloadExecutor = Executors.newSingleThreadExecutor(DAEMON_THREAD_FACTORY);
    private CountDownLatch closeGate;
    private WebSocket gatewayWebSocket;
    private volatile boolean running = false;

    public SmallD(Config config) {
        this(config, new HttpClient(config));
    }

    public SmallD(Config config, HttpClient http) {
        this.config = config;
        this.http = http;
    }

    public String getToken() {
        return this.config.getToken();
    }

    public int getCurrentShard() {
        return this.config.getCurrentShard();
    }

    public int getNumberOfShards() {
        return this.config.getNumberOfShards();
    }

    public int getIntents() {
        return this.config.getIntents();
    }

    private void connect() {
        String gatewayUrl = this.getGatewayUrl();
        Request request = new Request.Builder().url(gatewayUrl).build();
        WebSocketListener onMessageListener = new WebSocketListener(){

            public void onMessage(WebSocket ws, String text) {
                SmallD.this.onGatewayPayloadExecutor.execute(() -> SmallD.this.notifyListeners(text));
            }

            public void onFailure(WebSocket ws, Throwable t, Response r) {
                SmallD.this.reconnect();
            }

            public void onClosing(WebSocket ws, int code, String reason) {
                if (FATAL_WEBSOCKET_CLOSE_CODES.contains(code)) {
                    LOG.error("Unrecoverable gateway closure: ({}) {}", (Object)code, (Object)reason);
                    SmallD.this.close();
                } else {
                    LOG.info("Gateway closed: ({}) {}", (Object)code, (Object)reason);
                    SmallD.this.reconnect();
                }
            }
        };
        this.gatewayWebSocket = this.http.newWebSocket(request, new LoggingWebSocketListener(LOG, onMessageListener));
    }

    private void await() {
        if (this.closeGate == null) {
            this.closeGate = new CountDownLatch(1);
        }
        try {
            this.closeGate.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void reconnect() {
        this.close(4900, "To be resumed...");
    }

    @Override
    public void close() {
        this.running = false;
        this.close(1000, "Closed.");
    }

    private void close(int status, String reason) {
        if (this.gatewayWebSocket != null) {
            this.gatewayWebSocket.close(status, reason);
            this.gatewayWebSocket = null;
        }
        this.http.close();
        if (this.closeGate != null) {
            this.closeGate.countDown();
            this.closeGate = null;
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            try {
                this.connect();
                this.await();
            }
            catch (SmallDException e) {
                LOG.warn("Exception during run", (Throwable)e);
            }
            if (!this.running) continue;
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void onGatewayPayload(Consumer<String> consumer) {
        this.gatewayPayloadListeners.add(consumer);
    }

    private void notifyListeners(String text) {
        try {
            this.gatewayPayloadListeners.forEach(l -> l.accept(text));
        }
        catch (Exception e) {
            LOG.warn("Exception thrown when notifying listeners of gateway payload", (Throwable)e);
        }
    }

    public void sendGatewayPayload(String text) {
        LOG.debug("Gateway Send: {}", (Object)text);
        this.gatewayWebSocket.send(text);
    }

    public String get(String path) {
        return this.get(path, Collections.emptyMap());
    }

    public String get(String path, Map<String, Object> parameters) {
        LOG.debug("HTTP GET {}, {}", (Object)path, parameters);
        return this.http.send(path, Request.Builder::get, parameters);
    }

    public String post(String path, String payload, Attachment ... attachments) {
        return this.post(path, payload, Collections.emptyMap(), attachments);
    }

    public String post(String path, String payload, Map<String, Object> parameters, Attachment ... attachments) {
        LOG.debug("HTTP POST {}: {}, {}", new Object[]{path, payload, parameters});
        boolean isMultipart = attachments.length > 0;
        return isMultipart ? this.postMultipart(path, payload, attachments) : this.http.send(path, b -> b.post(this.jsonBody(payload)), parameters);
    }

    private String postMultipart(String path, String payload, Attachment ... attachments) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", payload);
        for (Attachment a : attachments) {
            builder.addFormDataPart("file", a.getFilename(), RequestBody.create((MediaType)MediaType.get((String)a.getMimeType()), (byte[])a.getBytes()));
        }
        return this.http.send(path, b -> b.post((RequestBody)builder.build()), Collections.emptyMap());
    }

    public String put(String path, String payload) {
        return this.put(path, payload, Collections.emptyMap());
    }

    public String put(String path, String payload, Map<String, Object> parameters) {
        LOG.debug("HTTP PUT {}: {}, {}", new Object[]{path, payload, parameters});
        return this.http.send(path, b -> b.put(this.jsonBody(payload)), parameters);
    }

    public String patch(String path, String payload) {
        LOG.debug("HTTP PATCH {}: {}", (Object)path, (Object)payload);
        return this.http.send(path, b -> b.patch(this.jsonBody(payload)), Collections.emptyMap());
    }

    public String delete(String path) {
        LOG.debug("HTTP DELETE {}", (Object)path);
        return this.http.send(path, Request.Builder::delete, Collections.emptyMap());
    }

    private String getGatewayUrl() {
        try {
            String url = Json.parse((String)this.get("/gateway/bot")).asObject().getString("url", null);
            if (url == null) {
                throw new SmallDException("No URL in /gateway/bot request");
            }
            return url;
        }
        catch (ParseException e) {
            throw new SmallDException(e);
        }
    }

    private RequestBody jsonBody(String content) {
        return RequestBody.create((MediaType)JSON, (String)content);
    }

    public static SmallD create(String token) {
        return SmallD.create(Config.builder().setToken(token).build());
    }

    public static SmallD create(Config config) {
        SmallD smalld = new SmallD(config);
        SequenceNumber seq = new SequenceNumber();
        Identify identify = new Identify(seq);
        Heartbeat heartbeat = new Heartbeat(seq);
        Stream.of(seq, identify, heartbeat).forEach(c -> c.accept(smalld));
        return smalld;
    }

    public static void run(String token, Consumer<SmallD> bot) {
        SmallD.run(Config.builder().setToken(token).build(), bot);
    }

    public static void run(Config config, Consumer<SmallD> bot) {
        try (SmallD smalld = SmallD.create(config);){
            bot.accept(smalld);
            smalld.run();
        }
    }
}

