/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld.examples;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.github.princesslana.smalld.Attachment;
import com.github.princesslana.smalld.SmallD;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class CatBot {
    private static final String CAT_URL = "http://aws.random.cat/meow";
    private static final OkHttpClient OK_HTTP = new OkHttpClient();
    private static final Request CAT_REQUEST = new Request.Builder().url("http://aws.random.cat/meow").get().build();
    private static SmallD smalld;

    public static void main(String[] args) {
        SmallD.run(System.getenv("SMALLD_TOKEN"), smalld -> smalld.onGatewayPayload(p -> {
            JsonObject json = Json.parse((String)p).asObject();
            if (json.getInt("op", -1) == 0 && json.getString("t", "").equals("MESSAGE_CREATE") && json.get("d").asObject().getString("content", "").equals("++cat")) {
                String channelId = json.get("d").asObject().getString("channel_id", null);
                CatBot.sendCat(smalld, channelId);
            }
        }));
    }

    private static void sendCat(SmallD smalld, String channelId) {
        smalld.post("/channels/" + channelId + "/messages", "", new Attachment("cat.jpg", "image/jpeg", CatBot.getCatUrl()));
    }

    private static URL getCatUrl() {
        try {
            Response response = OK_HTTP.newCall(CAT_REQUEST).execute();
            return new URL(Json.parse((Reader)response.body().charStream()).asObject().getString("file", null));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

