/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld.ratelimit;

import com.github.princesslana.smalld.ratelimit.RateLimitException;
import java.time.Clock;
import java.time.Instant;

public interface RateLimit {
    public void acquire();

    public static RateLimit allowAll() {
        return () -> {};
    }

    public static RateLimit denyUntil(Clock clock, Instant expiry) {
        return () -> {
            if (clock.instant().isBefore(expiry)) {
                throw new RateLimitException(expiry);
            }
        };
    }
}

