/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld.ratelimit;

import com.github.princesslana.smalld.SmallDException;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Request;

public class RateLimitBucket {
    private static final Collection<Mapping> MAPPINGS = RateLimitBucket.loadBucketMappings();
    private static final Mapping DELETE_MESSAGE_MAPPING = Mapping.of("/channels/(\\d+)/messages/(\\d+)", "DELETE /channels/$1/messages/{message.id}");
    private String bucket;

    private RateLimitBucket(String bucket) {
        this.bucket = bucket;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RateLimitBucket rhs = (RateLimitBucket)obj;
        return Objects.equals(this.bucket, rhs.bucket);
    }

    public int hashCode() {
        return this.bucket.hashCode();
    }

    public String toString() {
        return String.format("RateLimitBucket(%s)", this.bucket);
    }

    private static Collection<Mapping> loadBucketMappings() {
        try {
            Properties mappings = new Properties();
            mappings.load(RateLimitBucket.class.getResourceAsStream("rate_limit_buckets.properties"));
            return mappings.entrySet().stream().map(e -> Mapping.of((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
        catch (IOException e2) {
            throw new SmallDException(e2);
        }
    }

    public static RateLimitBucket from(String method, String path) {
        Stream<Mapping> deleteMessage = method.equalsIgnoreCase("DELETE") ? Stream.of(DELETE_MESSAGE_MAPPING) : Stream.of(new Mapping[0]);
        String bucket = Stream.concat(deleteMessage, MAPPINGS.stream()).map(m -> m.replaceIn(path)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(path);
        return new RateLimitBucket(bucket);
    }

    public static RateLimitBucket from(Request request) {
        return RateLimitBucket.from(request.method(), request.url().encodedPath());
    }

    private static class Mapping {
        private final Pattern from;
        private final String to;

        public Mapping(Pattern from, String to) {
            this.from = from;
            this.to = to;
        }

        public Optional<String> replaceIn(String path) {
            Matcher m = this.from.matcher(path);
            return m.matches() ? Optional.of(m.replaceAll(this.to)) : Optional.empty();
        }

        public static Mapping of(String from, String to) {
            return new Mapping(Pattern.compile(from), to);
        }
    }
}

