/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld.ratelimit;

import com.github.princesslana.smalld.ratelimit.RateLimit;
import com.github.princesslana.smalld.ratelimit.RateLimitBucket;
import com.github.princesslana.smalld.ratelimit.RateLimitException;
import com.github.princesslana.smalld.ratelimit.ResourceRateLimit;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RateLimitInterceptor
implements Interceptor {
    private final Clock clock;
    private RateLimit globalRateLimit = RateLimit.allowAll();
    private Map<RateLimitBucket, RateLimit> resourceRateLimit = new ConcurrentHashMap<RateLimitBucket, RateLimit>();

    public RateLimitInterceptor(Clock clock) {
        this.clock = clock;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        this.globalRateLimit.acquire();
        this.getRateLimitForPath(chain.request()).acquire();
        Response response = chain.proceed(chain.request());
        this.getRateLimit(response).ifPresent(rl -> this.setRateLimitForPath(chain.request(), (RateLimit)rl));
        if (response.code() == 429) {
            this.getRateLimitExpiry(response).ifPresent(expiryAt -> {
                if (this.isGlobalRateLimit(response)) {
                    this.globalRateLimit = RateLimit.denyUntil(this.clock, expiryAt);
                } else {
                    this.setRateLimitForPath(chain.request(), RateLimit.denyUntil(this.clock, expiryAt));
                }
                throw new RateLimitException((Instant)expiryAt);
            });
        }
        return response;
    }

    private RateLimit getRateLimitForPath(Request request) {
        return this.resourceRateLimit.getOrDefault(RateLimitBucket.from(request), RateLimit.allowAll());
    }

    private void setRateLimitForPath(Request request, RateLimit rateLimit) {
        this.resourceRateLimit.put(RateLimitBucket.from(request), rateLimit);
    }

    private Optional<Instant> getRateLimitExpiry(Response response) {
        Optional<Instant> reset = this.getRateLimitReset(response);
        Optional<Instant> responseDate = Optional.ofNullable(response.header("Date")).map(DateTimeFormatter.RFC_1123_DATE_TIME::parse).map(Instant::from);
        Optional<Instant> retryAfter = this.getRetryAfter(response).map(responseDate.orElse(this.clock.instant())::plusMillis);
        return Stream.of(reset, retryAfter).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<Long> getRetryAfter(Response response) {
        return this.headerAsLong(response, "Retry-After");
    }

    private Optional<Instant> getRateLimitReset(Response response) {
        return this.headerAsLong(response, "X-RateLimit-Reset").map(Instant::ofEpochMilli);
    }

    private boolean isGlobalRateLimit(Response response) {
        return Optional.ofNullable(response.header("X-RateLimit-Global")).map(String::toLowerCase).map(Boolean::valueOf).orElse(false);
    }

    private Optional<RateLimit> getRateLimit(Response response) {
        Optional<Long> remaining = this.headerAsLong(response, "X-RateLimit-Remaining");
        Optional<Instant> reset = this.getRateLimitReset(response);
        return remaining.flatMap(rem -> reset.map(res -> new ResourceRateLimit(this.clock, (long)rem, (Instant)res)));
    }

    private Optional<Long> headerAsLong(Response response, String header) {
        return Optional.ofNullable(response.header(header)).map(Long::parseLong);
    }
}

