/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld.ratelimit;

import com.github.princesslana.smalld.ratelimit.RateLimit;
import com.github.princesslana.smalld.ratelimit.RateLimitException;
import java.time.Clock;
import java.time.Instant;

public class ResourceRateLimit
implements RateLimit {
    private final Clock clock;
    private long remaining;
    private final Instant reset;

    public ResourceRateLimit(Clock clock, long remaining, Instant reset) {
        this.clock = clock;
        this.remaining = remaining;
        this.reset = reset;
    }

    @Override
    public void acquire() {
        if (this.clock.instant().isBefore(this.reset) && this.remaining <= 0L) {
            throw new RateLimitException(this.reset);
        }
        --this.remaining;
    }
}

