/*
 * Decompiled with CFR 0.152.
 */
package com.github.princesslana.smalld.test;

import com.github.princesslana.smalld.Attachment;
import com.github.princesslana.smalld.Config;
import com.github.princesslana.smalld.SmallD;
import com.github.princesslana.smalld.test.SentRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class MockSmallD
extends SmallD {
    public static final String MOCK_TOKEN = "Mock.Token";
    private final List<Consumer<String>> listeners = new ArrayList<Consumer<String>>();
    private final BlockingQueue<String> sentPayloads = new ArrayBlockingQueue<String>(100, true);
    private final BlockingQueue<SentRequest> sentRequests = new ArrayBlockingQueue<SentRequest>(100, true);
    private final BlockingQueue<LifecycleEvent> lifecycleEvents = new ArrayBlockingQueue<LifecycleEvent>(100, true);

    public MockSmallD() {
        super(Config.builder().setToken(MOCK_TOKEN).build());
    }

    public void receivePayload(String payload) {
        this.listeners.forEach(l -> l.accept(payload));
    }

    @Override
    public void onGatewayPayload(Consumer<String> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void sendGatewayPayload(String payload) {
        this.sentPayloads.add(payload);
    }

    public CompletableFuture<String> awaitSentPayload() {
        return this.take(this.sentPayloads);
    }

    @Override
    public void run() {
        this.lifecycleEvents.add(LifecycleEvent.RUN);
    }

    @Override
    public void reconnect() {
        this.lifecycleEvents.add(LifecycleEvent.RECONNECT);
    }

    @Override
    public void close() {
        this.lifecycleEvents.add(LifecycleEvent.CLOSE);
    }

    public CompletableFuture<LifecycleEvent> awaitLifecycleEvent() {
        return this.take(this.lifecycleEvents);
    }

    @Override
    public String get(String path) {
        this.sentRequests.add(new SentRequest("GET", path, ""));
        return "";
    }

    @Override
    public String post(String path, String payload, Attachment ... attachments) {
        this.sentRequests.add(new SentRequest("POST", path, payload));
        return "";
    }

    @Override
    public String put(String path, String payload) {
        this.sentRequests.add(new SentRequest("PUT", path, payload));
        return "";
    }

    @Override
    public String patch(String path, String payload) {
        this.sentRequests.add(new SentRequest("PATCH", path, payload));
        return "";
    }

    @Override
    public String delete(String path) {
        this.sentRequests.add(new SentRequest("DELETE", path, ""));
        return "";
    }

    public CompletableFuture<SentRequest> awaitSentRequest() {
        return this.take(this.sentRequests);
    }

    private <T> CompletableFuture<T> take(BlockingQueue<T> q) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return q.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static enum LifecycleEvent {
        RUN,
        RECONNECT,
        CLOSE;

    }
}

