/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api;

import com.github.prominence.openweathermap.api.annotation.SubscriptionAvailability;
import com.github.prominence.openweathermap.api.conf.TimeoutSettings;
import com.github.prominence.openweathermap.api.enums.SubscriptionPlan;
import com.github.prominence.openweathermap.api.request.RequestSettings;
import com.github.prominence.openweathermap.api.request.air.pollution.AirPollutionRequester;
import com.github.prominence.openweathermap.api.request.forecast.free.FiveDayThreeHourStepForecastRequester;
import com.github.prominence.openweathermap.api.request.onecall.OneCallWeatherRequester;
import com.github.prominence.openweathermap.api.request.weather.CurrentWeatherRequester;

public class OpenWeatherMapClient {
    private final String apiKey;
    private final TimeoutSettings timeoutSettings = new TimeoutSettings();

    public OpenWeatherMapClient(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.timeoutSettings.setConnectionTimeout(connectionTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.timeoutSettings.setReadTimeout(readTimeout);
    }

    @SubscriptionAvailability(plans={SubscriptionPlan.ALL})
    public CurrentWeatherRequester currentWeather() {
        return new CurrentWeatherRequester(new RequestSettings(this.apiKey, this.timeoutSettings));
    }

    @SubscriptionAvailability(plans={SubscriptionPlan.ALL})
    public FiveDayThreeHourStepForecastRequester forecast5Day3HourStep() {
        return new FiveDayThreeHourStepForecastRequester(new RequestSettings(this.apiKey, this.timeoutSettings));
    }

    @SubscriptionAvailability(plans={SubscriptionPlan.ALL})
    public OneCallWeatherRequester oneCall() {
        return new OneCallWeatherRequester(new RequestSettings(this.apiKey, this.timeoutSettings));
    }

    @SubscriptionAvailability(plans={SubscriptionPlan.ALL})
    public AirPollutionRequester airPollution() {
        return new AirPollutionRequester(new RequestSettings(this.apiKey, this.timeoutSettings));
    }
}

