/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.enums;

public enum MoonType {
    NEW_MOON,
    WAXING_CRESCENT,
    FIRST_QUARTER_MOON,
    WAXING_GIBBOUS,
    FULL_MOON,
    WANING_GIBBOUS,
    LAST_QUARTER_MOON,
    WANING_CRESCENT,
    INVALID;

    private static final double precision = 1.0E-6;

    public static MoonType valueOf(double numericValue) {
        if (MoonType.equals(numericValue, 0.0) || MoonType.equals(numericValue, 1.0)) {
            return NEW_MOON;
        }
        if (MoonType.equals(numericValue, 0.25)) {
            return FIRST_QUARTER_MOON;
        }
        if (MoonType.equals(numericValue, 0.5)) {
            return FULL_MOON;
        }
        if (MoonType.equals(numericValue, 0.75)) {
            return LAST_QUARTER_MOON;
        }
        if (numericValue > 0.0 && numericValue < 0.25) {
            return WAXING_CRESCENT;
        }
        if (numericValue > 0.25 && numericValue < 0.5) {
            return WAXING_GIBBOUS;
        }
        if (numericValue > 0.5 && numericValue < 0.75) {
            return WANING_GIBBOUS;
        }
        if (numericValue > 0.75 && numericValue < 1.0) {
            return WANING_CRESCENT;
        }
        return INVALID;
    }

    private static boolean equals(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-6;
    }
}

