/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.enums;

public enum UnitSystem {
    METRIC("metric"),
    IMPERIAL("imperial"),
    STANDARD("standard");

    private final String value;

    private UnitSystem(String value) {
        this.value = value;
    }

    public String getWindUnit() {
        switch (this) {
            case IMPERIAL: {
                return "miles/hour";
            }
        }
        return "meter/sec";
    }

    public String getTemperatureUnit() {
        switch (this) {
            case METRIC: {
                return "\u00b0C";
            }
            case IMPERIAL: {
                return "\u00b0F";
            }
        }
        return "\u212a";
    }

    public String getValue() {
        return this.value;
    }
}

